/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InterruptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InterruptionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InterruptionInfo> {
    private static final SdkField<String> SOURCE_CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCapacityReservationId").getter(InterruptionInfo.getter(InterruptionInfo::sourceCapacityReservationId)).setter(InterruptionInfo.setter(Builder::sourceCapacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservationId").unmarshallLocationName("sourceCapacityReservationId").build()}).build();
    private static final SdkField<String> INTERRUPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterruptionType").getter(InterruptionInfo.getter(InterruptionInfo::interruptionTypeAsString)).setter(InterruptionInfo.setter(Builder::interruptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionType").unmarshallLocationName("interruptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CAPACITY_RESERVATION_ID_FIELD, INTERRUPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InterruptionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceCapacityReservationId;
    private final String interruptionType;

    private InterruptionInfo(BuilderImpl builder) {
        this.sourceCapacityReservationId = builder.sourceCapacityReservationId;
        this.interruptionType = builder.interruptionType;
    }

    public final String sourceCapacityReservationId() {
        return this.sourceCapacityReservationId;
    }

    public final InterruptionType interruptionType() {
        return InterruptionType.fromValue(this.interruptionType);
    }

    public final String interruptionTypeAsString() {
        return this.interruptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interruptionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterruptionInfo)) {
            return false;
        }
        InterruptionInfo other = (InterruptionInfo)obj;
        return Objects.equals(this.sourceCapacityReservationId(), other.sourceCapacityReservationId()) && Objects.equals(this.interruptionTypeAsString(), other.interruptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InterruptionInfo").add("SourceCapacityReservationId", (Object)this.sourceCapacityReservationId()).add("InterruptionType", (Object)this.interruptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceCapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.sourceCapacityReservationId()));
            }
            case "InterruptionType": {
                return Optional.ofNullable(clazz.cast(this.interruptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SourceCapacityReservationId", SOURCE_CAPACITY_RESERVATION_ID_FIELD);
        map.put("InterruptionType", INTERRUPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InterruptionInfo, T> g) {
        return obj -> g.apply((InterruptionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceCapacityReservationId;
        private String interruptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(InterruptionInfo model) {
            this.sourceCapacityReservationId(model.sourceCapacityReservationId);
            this.interruptionType(model.interruptionType);
        }

        public final String getSourceCapacityReservationId() {
            return this.sourceCapacityReservationId;
        }

        public final void setSourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
        }

        @Override
        public final Builder sourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
            return this;
        }

        public final String getInterruptionType() {
            return this.interruptionType;
        }

        public final void setInterruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
        }

        @Override
        public final Builder interruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
            return this;
        }

        @Override
        public final Builder interruptionType(InterruptionType interruptionType) {
            this.interruptionType(interruptionType == null ? null : interruptionType.toString());
            return this;
        }

        public InterruptionInfo build() {
            return new InterruptionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InterruptionInfo> {
        public Builder sourceCapacityReservationId(String var1);

        public Builder interruptionType(String var1);

        public Builder interruptionType(InterruptionType var1);
    }
}

