/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleConditionOperation;
import software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPrefixListResolverRuleConditionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPrefixListResolverRuleConditionRequest> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(IpamPrefixListResolverRuleConditionRequest.getter(IpamPrefixListResolverRuleConditionRequest::operationAsString)).setter(IpamPrefixListResolverRuleConditionRequest.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").unmarshallLocationName("Operation").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(IpamPrefixListResolverRuleConditionRequest.getter(IpamPrefixListResolverRuleConditionRequest::ipamPoolId)).setter(IpamPrefixListResolverRuleConditionRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(IpamPrefixListResolverRuleConditionRequest.getter(IpamPrefixListResolverRuleConditionRequest::resourceId)).setter(IpamPrefixListResolverRuleConditionRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwner").getter(IpamPrefixListResolverRuleConditionRequest.getter(IpamPrefixListResolverRuleConditionRequest::resourceOwner)).setter(IpamPrefixListResolverRuleConditionRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").unmarshallLocationName("ResourceOwner").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(IpamPrefixListResolverRuleConditionRequest.getter(IpamPrefixListResolverRuleConditionRequest::resourceRegion)).setter(IpamPrefixListResolverRuleConditionRequest.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("ResourceRegion").build()}).build();
    private static final SdkField<RequestIpamResourceTag> RESOURCE_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceTag").getter(IpamPrefixListResolverRuleConditionRequest.getter(IpamPrefixListResolverRuleConditionRequest::resourceTag)).setter(IpamPrefixListResolverRuleConditionRequest.setter(Builder::resourceTag)).constructor(RequestIpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTag").unmarshallLocationName("ResourceTag").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(IpamPrefixListResolverRuleConditionRequest.getter(IpamPrefixListResolverRuleConditionRequest::cidr)).setter(IpamPrefixListResolverRuleConditionRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD, IPAM_POOL_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_OWNER_FIELD, RESOURCE_REGION_FIELD, RESOURCE_TAG_FIELD, CIDR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPrefixListResolverRuleConditionRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operation;
    private final String ipamPoolId;
    private final String resourceId;
    private final String resourceOwner;
    private final String resourceRegion;
    private final RequestIpamResourceTag resourceTag;
    private final String cidr;

    private IpamPrefixListResolverRuleConditionRequest(BuilderImpl builder) {
        this.operation = builder.operation;
        this.ipamPoolId = builder.ipamPoolId;
        this.resourceId = builder.resourceId;
        this.resourceOwner = builder.resourceOwner;
        this.resourceRegion = builder.resourceRegion;
        this.resourceTag = builder.resourceTag;
        this.cidr = builder.cidr;
    }

    public final IpamPrefixListResolverRuleConditionOperation operation() {
        return IpamPrefixListResolverRuleConditionOperation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceOwner() {
        return this.resourceOwner;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final RequestIpamResourceTag resourceTag() {
        return this.resourceTag;
    }

    public final String cidr() {
        return this.cidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPrefixListResolverRuleConditionRequest)) {
            return false;
        }
        IpamPrefixListResolverRuleConditionRequest other = (IpamPrefixListResolverRuleConditionRequest)obj;
        return Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceOwner(), other.resourceOwner()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.resourceTag(), other.resourceTag()) && Objects.equals(this.cidr(), other.cidr());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPrefixListResolverRuleConditionRequest").add("Operation", (Object)this.operationAsString()).add("IpamPoolId", (Object)this.ipamPoolId()).add("ResourceId", (Object)this.resourceId()).add("ResourceOwner", (Object)this.resourceOwner()).add("ResourceRegion", (Object)this.resourceRegion()).add("ResourceTag", (Object)this.resourceTag()).add("Cidr", (Object)this.cidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwner()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "ResourceTag": {
                return Optional.ofNullable(clazz.cast(this.resourceTag()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Operation", OPERATION_FIELD);
        map.put("IpamPoolId", IPAM_POOL_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceOwner", RESOURCE_OWNER_FIELD);
        map.put("ResourceRegion", RESOURCE_REGION_FIELD);
        map.put("ResourceTag", RESOURCE_TAG_FIELD);
        map.put("Cidr", CIDR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPrefixListResolverRuleConditionRequest, T> g) {
        return obj -> g.apply((IpamPrefixListResolverRuleConditionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operation;
        private String ipamPoolId;
        private String resourceId;
        private String resourceOwner;
        private String resourceRegion;
        private RequestIpamResourceTag resourceTag;
        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPrefixListResolverRuleConditionRequest model) {
            this.operation(model.operation);
            this.ipamPoolId(model.ipamPoolId);
            this.resourceId(model.resourceId);
            this.resourceOwner(model.resourceOwner);
            this.resourceRegion(model.resourceRegion);
            this.resourceTag(model.resourceTag);
            this.cidr(model.cidr);
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(IpamPrefixListResolverRuleConditionOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final RequestIpamResourceTag.Builder getResourceTag() {
            return this.resourceTag != null ? this.resourceTag.toBuilder() : null;
        }

        public final void setResourceTag(RequestIpamResourceTag.BuilderImpl resourceTag) {
            this.resourceTag = resourceTag != null ? resourceTag.build() : null;
        }

        @Override
        public final Builder resourceTag(RequestIpamResourceTag resourceTag) {
            this.resourceTag = resourceTag;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public IpamPrefixListResolverRuleConditionRequest build() {
            return new IpamPrefixListResolverRuleConditionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPrefixListResolverRuleConditionRequest> {
        public Builder operation(String var1);

        public Builder operation(IpamPrefixListResolverRuleConditionOperation var1);

        public Builder ipamPoolId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceOwner(String var1);

        public Builder resourceRegion(String var1);

        public Builder resourceTag(RequestIpamResourceTag var1);

        default public Builder resourceTag(Consumer<RequestIpamResourceTag.Builder> resourceTag) {
            return this.resourceTag((RequestIpamResourceTag)((RequestIpamResourceTag.Builder)RequestIpamResourceTag.builder().applyMutation(resourceTag)).build());
        }

        public Builder cidr(String var1);
    }
}

