/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a service configuration for a VPC endpoint service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConfiguration.Builder, ServiceConfiguration> {
    private static final SdkField<List<ServiceTypeDetail>> SERVICE_TYPE_FIELD = SdkField
            .<List<ServiceTypeDetail>> builder(MarshallingType.LIST)
            .memberName("ServiceType")
            .getter(getter(ServiceConfiguration::serviceType))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType")
                    .unmarshallLocationName("serviceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ServiceTypeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceTypeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceId")
            .getter(getter(ServiceConfiguration::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("serviceId").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceName")
            .getter(getter(ServiceConfiguration::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName")
                    .unmarshallLocationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceState")
            .getter(getter(ServiceConfiguration::serviceStateAsString))
            .setter(setter(Builder::serviceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceState")
                    .unmarshallLocationName("serviceState").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZoneIds")
            .getter(getter(ServiceConfiguration::availabilityZoneIds))
            .setter(setter(Builder::availabilityZoneIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneIdSet")
                    .unmarshallLocationName("availabilityZoneIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(ServiceConfiguration::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet")
                    .unmarshallLocationName("availabilityZoneSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptanceRequired")
            .getter(getter(ServiceConfiguration::acceptanceRequired))
            .setter(setter(Builder::acceptanceRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired")
                    .unmarshallLocationName("acceptanceRequired").build()).build();

    private static final SdkField<Boolean> MANAGES_VPC_ENDPOINTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ManagesVpcEndpoints")
            .getter(getter(ServiceConfiguration::managesVpcEndpoints))
            .setter(setter(Builder::managesVpcEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagesVpcEndpoints")
                    .unmarshallLocationName("managesVpcEndpoints").build()).build();

    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkLoadBalancerArns")
            .getter(getter(ServiceConfiguration::networkLoadBalancerArns))
            .setter(setter(Builder::networkLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArnSet")
                    .unmarshallLocationName("networkLoadBalancerArnSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GatewayLoadBalancerArns")
            .getter(getter(ServiceConfiguration::gatewayLoadBalancerArns))
            .setter(setter(Builder::gatewayLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayLoadBalancerArnSet")
                    .unmarshallLocationName("gatewayLoadBalancerArnSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SUPPORTED_IP_ADDRESS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedIpAddressTypes")
            .getter(getter(ServiceConfiguration::supportedIpAddressTypesAsStrings))
            .setter(setter(Builder::supportedIpAddressTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedIpAddressTypeSet")
                    .unmarshallLocationName("supportedIpAddressTypeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BaseEndpointDnsNames")
            .getter(getter(ServiceConfiguration::baseEndpointDnsNames))
            .setter(setter(Builder::baseEndpointDnsNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNameSet")
                    .unmarshallLocationName("baseEndpointDnsNameSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(ServiceConfiguration::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final SdkField<PrivateDnsNameConfiguration> PRIVATE_DNS_NAME_CONFIGURATION_FIELD = SdkField
            .<PrivateDnsNameConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PrivateDnsNameConfiguration")
            .getter(getter(ServiceConfiguration::privateDnsNameConfiguration))
            .setter(setter(Builder::privateDnsNameConfiguration))
            .constructor(PrivateDnsNameConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameConfiguration")
                    .unmarshallLocationName("privateDnsNameConfiguration").build()).build();

    private static final SdkField<String> PAYER_RESPONSIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PayerResponsibility")
            .getter(getter(ServiceConfiguration::payerResponsibilityAsString))
            .setter(setter(Builder::payerResponsibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayerResponsibility")
                    .unmarshallLocationName("payerResponsibility").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ServiceConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<SupportedRegionDetail>> SUPPORTED_REGIONS_FIELD = SdkField
            .<List<SupportedRegionDetail>> builder(MarshallingType.LIST)
            .memberName("SupportedRegions")
            .getter(getter(ServiceConfiguration::supportedRegions))
            .setter(setter(Builder::supportedRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedRegionSet")
                    .unmarshallLocationName("supportedRegionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SupportedRegionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedRegionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> REMOTE_ACCESS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoteAccessEnabled")
            .getter(getter(ServiceConfiguration::remoteAccessEnabled))
            .setter(setter(Builder::remoteAccessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteAccessEnabled")
                    .unmarshallLocationName("remoteAccessEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            SERVICE_ID_FIELD, SERVICE_NAME_FIELD, SERVICE_STATE_FIELD, AVAILABILITY_ZONE_IDS_FIELD, AVAILABILITY_ZONES_FIELD,
            ACCEPTANCE_REQUIRED_FIELD, MANAGES_VPC_ENDPOINTS_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD,
            GATEWAY_LOAD_BALANCER_ARNS_FIELD, SUPPORTED_IP_ADDRESS_TYPES_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD,
            PRIVATE_DNS_NAME_FIELD, PRIVATE_DNS_NAME_CONFIGURATION_FIELD, PAYER_RESPONSIBILITY_FIELD, TAGS_FIELD,
            SUPPORTED_REGIONS_FIELD, REMOTE_ACCESS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ServiceTypeDetail> serviceType;

    private final String serviceId;

    private final String serviceName;

    private final String serviceState;

    private final List<String> availabilityZoneIds;

    private final List<String> availabilityZones;

    private final Boolean acceptanceRequired;

    private final Boolean managesVpcEndpoints;

    private final List<String> networkLoadBalancerArns;

    private final List<String> gatewayLoadBalancerArns;

    private final List<String> supportedIpAddressTypes;

    private final List<String> baseEndpointDnsNames;

    private final String privateDnsName;

    private final PrivateDnsNameConfiguration privateDnsNameConfiguration;

    private final String payerResponsibility;

    private final List<Tag> tags;

    private final List<SupportedRegionDetail> supportedRegions;

    private final Boolean remoteAccessEnabled;

    private ServiceConfiguration(BuilderImpl builder) {
        this.serviceType = builder.serviceType;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceState = builder.serviceState;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.availabilityZones = builder.availabilityZones;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.managesVpcEndpoints = builder.managesVpcEndpoints;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.gatewayLoadBalancerArns = builder.gatewayLoadBalancerArns;
        this.supportedIpAddressTypes = builder.supportedIpAddressTypes;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.privateDnsNameConfiguration = builder.privateDnsNameConfiguration;
        this.payerResponsibility = builder.payerResponsibility;
        this.tags = builder.tags;
        this.supportedRegions = builder.supportedRegions;
        this.remoteAccessEnabled = builder.remoteAccessEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceType() {
        return serviceType != null && !(serviceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceType} method.
     * </p>
     * 
     * @return The type of service.
     */
    public final List<ServiceTypeDetail> serviceType() {
        return serviceType;
    }

    /**
     * <p>
     * The ID of the service.
     * </p>
     * 
     * @return The ID of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The service state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceState} will
     * return {@link ServiceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceStateAsString}.
     * </p>
     * 
     * @return The service state.
     * @see ServiceState
     */
    public final ServiceState serviceState() {
        return ServiceState.fromValue(serviceState);
    }

    /**
     * <p>
     * The service state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceState} will
     * return {@link ServiceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceStateAsString}.
     * </p>
     * 
     * @return The service state.
     * @see ServiceState
     */
    public final String serviceStateAsString() {
        return serviceState;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZoneIds() {
        return availabilityZoneIds != null && !(availabilityZoneIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Availability Zones in which the service is available.
     * </p>
     * <p>
     * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneIds} method.
     * </p>
     * 
     * @return The IDs of the Availability Zones in which the service is available.</p>
     *         <p>
     *         Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
     */
    public final List<String> availabilityZoneIds() {
        return availabilityZoneIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones in which the service is available.
     * </p>
     * <p>
     * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The Availability Zones in which the service is available.</p>
     *         <p>
     *         Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must
     * first be accepted.
     * </p>
     * 
     * @return Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service
     *         must first be accepted.
     */
    public final Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    /**
     * <p>
     * Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC
     * endpoint API is restricted.
     * </p>
     * 
     * @return Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using
     *         the VPC endpoint API is restricted.
     */
    public final Boolean managesVpcEndpoints() {
        return managesVpcEndpoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkLoadBalancerArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkLoadBalancerArns() {
        return networkLoadBalancerArns != null && !(networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
     */
    public final List<String> networkLoadBalancerArns() {
        return networkLoadBalancerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayLoadBalancerArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGatewayLoadBalancerArns() {
        return gatewayLoadBalancerArns != null && !(gatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
     */
    public final List<String> gatewayLoadBalancerArns() {
        return gatewayLoadBalancerArns;
    }

    /**
     * <p>
     * The supported IP address types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedIpAddressTypes} method.
     * </p>
     * 
     * @return The supported IP address types.
     */
    public final List<ServiceConnectivityType> supportedIpAddressTypes() {
        return SupportedIpAddressTypesCopier.copyStringToEnum(supportedIpAddressTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedIpAddressTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedIpAddressTypes() {
        return supportedIpAddressTypes != null && !(supportedIpAddressTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported IP address types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedIpAddressTypes} method.
     * </p>
     * 
     * @return The supported IP address types.
     */
    public final List<String> supportedIpAddressTypesAsStrings() {
        return supportedIpAddressTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the BaseEndpointDnsNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBaseEndpointDnsNames() {
        return baseEndpointDnsNames != null && !(baseEndpointDnsNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DNS names for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBaseEndpointDnsNames} method.
     * </p>
     * 
     * @return The DNS names for the service.
     */
    public final List<String> baseEndpointDnsNames() {
        return baseEndpointDnsNames;
    }

    /**
     * <p>
     * The private DNS name for the service.
     * </p>
     * 
     * @return The private DNS name for the service.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * Information about the endpoint service private DNS name configuration.
     * </p>
     * 
     * @return Information about the endpoint service private DNS name configuration.
     */
    public final PrivateDnsNameConfiguration privateDnsNameConfiguration() {
        return privateDnsNameConfiguration;
    }

    /**
     * <p>
     * The payer responsibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #payerResponsibility} will return {@link PayerResponsibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #payerResponsibilityAsString}.
     * </p>
     * 
     * @return The payer responsibility.
     * @see PayerResponsibility
     */
    public final PayerResponsibility payerResponsibility() {
        return PayerResponsibility.fromValue(payerResponsibility);
    }

    /**
     * <p>
     * The payer responsibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #payerResponsibility} will return {@link PayerResponsibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #payerResponsibilityAsString}.
     * </p>
     * 
     * @return The payer responsibility.
     * @see PayerResponsibility
     */
    public final String payerResponsibilityAsString() {
        return payerResponsibility;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the service.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedRegions() {
        return supportedRegions != null && !(supportedRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedRegions} method.
     * </p>
     * 
     * @return The supported Regions.
     */
    public final List<SupportedRegionDetail> supportedRegions() {
        return supportedRegions;
    }

    /**
     * <p>
     * Indicates whether consumers can access the service from a Region other than the Region where the service is
     * hosted.
     * </p>
     * 
     * @return Indicates whether consumers can access the service from a Region other than the Region where the service
     *         is hosted.
     */
    public final Boolean remoteAccessEnabled() {
        return remoteAccessEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceType() ? serviceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneIds() ? availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(managesVpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkLoadBalancerArns() ? networkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayLoadBalancerArns() ? gatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedIpAddressTypes() ? supportedIpAddressTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBaseEndpointDnsNames() ? baseEndpointDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsNameConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(payerResponsibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedRegions() ? supportedRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration) obj;
        return hasServiceType() == other.hasServiceType() && Objects.equals(serviceType(), other.serviceType())
                && Objects.equals(serviceId(), other.serviceId()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(serviceStateAsString(), other.serviceStateAsString())
                && hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds()
                && Objects.equals(availabilityZoneIds(), other.availabilityZoneIds())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(acceptanceRequired(), other.acceptanceRequired())
                && Objects.equals(managesVpcEndpoints(), other.managesVpcEndpoints())
                && hasNetworkLoadBalancerArns() == other.hasNetworkLoadBalancerArns()
                && Objects.equals(networkLoadBalancerArns(), other.networkLoadBalancerArns())
                && hasGatewayLoadBalancerArns() == other.hasGatewayLoadBalancerArns()
                && Objects.equals(gatewayLoadBalancerArns(), other.gatewayLoadBalancerArns())
                && hasSupportedIpAddressTypes() == other.hasSupportedIpAddressTypes()
                && Objects.equals(supportedIpAddressTypesAsStrings(), other.supportedIpAddressTypesAsStrings())
                && hasBaseEndpointDnsNames() == other.hasBaseEndpointDnsNames()
                && Objects.equals(baseEndpointDnsNames(), other.baseEndpointDnsNames())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateDnsNameConfiguration(), other.privateDnsNameConfiguration())
                && Objects.equals(payerResponsibilityAsString(), other.payerResponsibilityAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasSupportedRegions() == other.hasSupportedRegions()
                && Objects.equals(supportedRegions(), other.supportedRegions())
                && Objects.equals(remoteAccessEnabled(), other.remoteAccessEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConfiguration").add("ServiceType", hasServiceType() ? serviceType() : null)
                .add("ServiceId", serviceId()).add("ServiceName", serviceName()).add("ServiceState", serviceStateAsString())
                .add("AvailabilityZoneIds", hasAvailabilityZoneIds() ? availabilityZoneIds() : null)
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("AcceptanceRequired", acceptanceRequired()).add("ManagesVpcEndpoints", managesVpcEndpoints())
                .add("NetworkLoadBalancerArns", hasNetworkLoadBalancerArns() ? networkLoadBalancerArns() : null)
                .add("GatewayLoadBalancerArns", hasGatewayLoadBalancerArns() ? gatewayLoadBalancerArns() : null)
                .add("SupportedIpAddressTypes", hasSupportedIpAddressTypes() ? supportedIpAddressTypesAsStrings() : null)
                .add("BaseEndpointDnsNames", hasBaseEndpointDnsNames() ? baseEndpointDnsNames() : null)
                .add("PrivateDnsName", privateDnsName()).add("PrivateDnsNameConfiguration", privateDnsNameConfiguration())
                .add("PayerResponsibility", payerResponsibilityAsString()).add("Tags", hasTags() ? tags() : null)
                .add("SupportedRegions", hasSupportedRegions() ? supportedRegions() : null)
                .add("RemoteAccessEnabled", remoteAccessEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceType()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceState":
            return Optional.ofNullable(clazz.cast(serviceStateAsString()));
        case "AvailabilityZoneIds":
            return Optional.ofNullable(clazz.cast(availabilityZoneIds()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "AcceptanceRequired":
            return Optional.ofNullable(clazz.cast(acceptanceRequired()));
        case "ManagesVpcEndpoints":
            return Optional.ofNullable(clazz.cast(managesVpcEndpoints()));
        case "NetworkLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(networkLoadBalancerArns()));
        case "GatewayLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(gatewayLoadBalancerArns()));
        case "SupportedIpAddressTypes":
            return Optional.ofNullable(clazz.cast(supportedIpAddressTypesAsStrings()));
        case "BaseEndpointDnsNames":
            return Optional.ofNullable(clazz.cast(baseEndpointDnsNames()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateDnsNameConfiguration":
            return Optional.ofNullable(clazz.cast(privateDnsNameConfiguration()));
        case "PayerResponsibility":
            return Optional.ofNullable(clazz.cast(payerResponsibilityAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SupportedRegions":
            return Optional.ofNullable(clazz.cast(supportedRegions()));
        case "RemoteAccessEnabled":
            return Optional.ofNullable(clazz.cast(remoteAccessEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceType", SERVICE_TYPE_FIELD);
        map.put("ServiceId", SERVICE_ID_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("ServiceState", SERVICE_STATE_FIELD);
        map.put("AvailabilityZoneIdSet", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("AvailabilityZoneSet", AVAILABILITY_ZONES_FIELD);
        map.put("AcceptanceRequired", ACCEPTANCE_REQUIRED_FIELD);
        map.put("ManagesVpcEndpoints", MANAGES_VPC_ENDPOINTS_FIELD);
        map.put("NetworkLoadBalancerArnSet", NETWORK_LOAD_BALANCER_ARNS_FIELD);
        map.put("GatewayLoadBalancerArnSet", GATEWAY_LOAD_BALANCER_ARNS_FIELD);
        map.put("SupportedIpAddressTypeSet", SUPPORTED_IP_ADDRESS_TYPES_FIELD);
        map.put("BaseEndpointDnsNameSet", BASE_ENDPOINT_DNS_NAMES_FIELD);
        map.put("PrivateDnsName", PRIVATE_DNS_NAME_FIELD);
        map.put("PrivateDnsNameConfiguration", PRIVATE_DNS_NAME_CONFIGURATION_FIELD);
        map.put("PayerResponsibility", PAYER_RESPONSIBILITY_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("SupportedRegionSet", SUPPORTED_REGIONS_FIELD);
        map.put("RemoteAccessEnabled", REMOTE_ACCESS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConfiguration, T> g) {
        return obj -> g.apply((ServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConfiguration> {
        /**
         * <p>
         * The type of service.
         * </p>
         * 
         * @param serviceType
         *        The type of service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(Collection<ServiceTypeDetail> serviceType);

        /**
         * <p>
         * The type of service.
         * </p>
         * 
         * @param serviceType
         *        The type of service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(ServiceTypeDetail... serviceType);

        /**
         * <p>
         * The type of service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ServiceTypeDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ServiceTypeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ServiceTypeDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceType(List<ServiceTypeDetail>)}.
         * 
         * @param serviceType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ServiceTypeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceType(java.util.Collection<ServiceTypeDetail>)
         */
        Builder serviceType(Consumer<ServiceTypeDetail.Builder>... serviceType);

        /**
         * <p>
         * The ID of the service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param serviceName
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The service state.
         * </p>
         * 
         * @param serviceState
         *        The service state.
         * @see ServiceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceState
         */
        Builder serviceState(String serviceState);

        /**
         * <p>
         * The service state.
         * </p>
         * 
         * @param serviceState
         *        The service state.
         * @see ServiceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceState
         */
        Builder serviceState(ServiceState serviceState);

        /**
         * <p>
         * The IDs of the Availability Zones in which the service is available.
         * </p>
         * <p>
         * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * </p>
         * 
         * @param availabilityZoneIds
         *        The IDs of the Availability Zones in which the service is available.</p>
         *        <p>
         *        Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(Collection<String> availabilityZoneIds);

        /**
         * <p>
         * The IDs of the Availability Zones in which the service is available.
         * </p>
         * <p>
         * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * </p>
         * 
         * @param availabilityZoneIds
         *        The IDs of the Availability Zones in which the service is available.</p>
         *        <p>
         *        Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(String... availabilityZoneIds);

        /**
         * <p>
         * The Availability Zones in which the service is available.
         * </p>
         * <p>
         * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones in which the service is available.</p>
         *        <p>
         *        Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones in which the service is available.
         * </p>
         * <p>
         * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones in which the service is available.</p>
         *        <p>
         *        Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> can be specified, but not both
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must
         * first be accepted.
         * </p>
         * 
         * @param acceptanceRequired
         *        Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the
         *        service must first be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);

        /**
         * <p>
         * Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the
         * VPC endpoint API is restricted.
         * </p>
         * 
         * @param managesVpcEndpoints
         *        Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using
         *        the VPC endpoint API is restricted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managesVpcEndpoints(Boolean managesVpcEndpoints);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
         * </p>
         * 
         * @param networkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
         * </p>
         * 
         * @param networkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkLoadBalancerArns(String... networkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         * </p>
         * 
         * @param gatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         * </p>
         * 
         * @param gatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayLoadBalancerArns(String... gatewayLoadBalancerArns);

        /**
         * <p>
         * The supported IP address types.
         * </p>
         * 
         * @param supportedIpAddressTypes
         *        The supported IP address types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIpAddressTypesWithStrings(Collection<String> supportedIpAddressTypes);

        /**
         * <p>
         * The supported IP address types.
         * </p>
         * 
         * @param supportedIpAddressTypes
         *        The supported IP address types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIpAddressTypesWithStrings(String... supportedIpAddressTypes);

        /**
         * <p>
         * The supported IP address types.
         * </p>
         * 
         * @param supportedIpAddressTypes
         *        The supported IP address types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIpAddressTypes(Collection<ServiceConnectivityType> supportedIpAddressTypes);

        /**
         * <p>
         * The supported IP address types.
         * </p>
         * 
         * @param supportedIpAddressTypes
         *        The supported IP address types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIpAddressTypes(ServiceConnectivityType... supportedIpAddressTypes);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(String... baseEndpointDnsNames);

        /**
         * <p>
         * The private DNS name for the service.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * Information about the endpoint service private DNS name configuration.
         * </p>
         * 
         * @param privateDnsNameConfiguration
         *        Information about the endpoint service private DNS name configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsNameConfiguration(PrivateDnsNameConfiguration privateDnsNameConfiguration);

        /**
         * <p>
         * Information about the endpoint service private DNS name configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateDnsNameConfiguration.Builder}
         * avoiding the need to create one manually via {@link PrivateDnsNameConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateDnsNameConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #privateDnsNameConfiguration(PrivateDnsNameConfiguration)}.
         * 
         * @param privateDnsNameConfiguration
         *        a consumer that will call methods on {@link PrivateDnsNameConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsNameConfiguration(PrivateDnsNameConfiguration)
         */
        default Builder privateDnsNameConfiguration(Consumer<PrivateDnsNameConfiguration.Builder> privateDnsNameConfiguration) {
            return privateDnsNameConfiguration(PrivateDnsNameConfiguration.builder().applyMutation(privateDnsNameConfiguration)
                    .build());
        }

        /**
         * <p>
         * The payer responsibility.
         * </p>
         * 
         * @param payerResponsibility
         *        The payer responsibility.
         * @see PayerResponsibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayerResponsibility
         */
        Builder payerResponsibility(String payerResponsibility);

        /**
         * <p>
         * The payer responsibility.
         * </p>
         * 
         * @param payerResponsibility
         *        The payer responsibility.
         * @see PayerResponsibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayerResponsibility
         */
        Builder payerResponsibility(PayerResponsibility payerResponsibility);

        /**
         * <p>
         * The tags assigned to the service.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the service.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The supported Regions.
         * </p>
         * 
         * @param supportedRegions
         *        The supported Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRegions(Collection<SupportedRegionDetail> supportedRegions);

        /**
         * <p>
         * The supported Regions.
         * </p>
         * 
         * @param supportedRegions
         *        The supported Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRegions(SupportedRegionDetail... supportedRegions);

        /**
         * <p>
         * The supported Regions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SupportedRegionDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.SupportedRegionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SupportedRegionDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedRegions(List<SupportedRegionDetail>)}.
         * 
         * @param supportedRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SupportedRegionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedRegions(java.util.Collection<SupportedRegionDetail>)
         */
        Builder supportedRegions(Consumer<SupportedRegionDetail.Builder>... supportedRegions);

        /**
         * <p>
         * Indicates whether consumers can access the service from a Region other than the Region where the service is
         * hosted.
         * </p>
         * 
         * @param remoteAccessEnabled
         *        Indicates whether consumers can access the service from a Region other than the Region where the
         *        service is hosted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessEnabled(Boolean remoteAccessEnabled);
    }

    static final class BuilderImpl implements Builder {
        private List<ServiceTypeDetail> serviceType = DefaultSdkAutoConstructList.getInstance();

        private String serviceId;

        private String serviceName;

        private String serviceState;

        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Boolean acceptanceRequired;

        private Boolean managesVpcEndpoints;

        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> gatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedIpAddressTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();

        private String privateDnsName;

        private PrivateDnsNameConfiguration privateDnsNameConfiguration;

        private String payerResponsibility;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<SupportedRegionDetail> supportedRegions = DefaultSdkAutoConstructList.getInstance();

        private Boolean remoteAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConfiguration model) {
            serviceType(model.serviceType);
            serviceId(model.serviceId);
            serviceName(model.serviceName);
            serviceState(model.serviceState);
            availabilityZoneIds(model.availabilityZoneIds);
            availabilityZones(model.availabilityZones);
            acceptanceRequired(model.acceptanceRequired);
            managesVpcEndpoints(model.managesVpcEndpoints);
            networkLoadBalancerArns(model.networkLoadBalancerArns);
            gatewayLoadBalancerArns(model.gatewayLoadBalancerArns);
            supportedIpAddressTypesWithStrings(model.supportedIpAddressTypes);
            baseEndpointDnsNames(model.baseEndpointDnsNames);
            privateDnsName(model.privateDnsName);
            privateDnsNameConfiguration(model.privateDnsNameConfiguration);
            payerResponsibility(model.payerResponsibility);
            tags(model.tags);
            supportedRegions(model.supportedRegions);
            remoteAccessEnabled(model.remoteAccessEnabled);
        }

        public final List<ServiceTypeDetail.Builder> getServiceType() {
            List<ServiceTypeDetail.Builder> result = ServiceTypeDetailSetCopier.copyToBuilder(this.serviceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail... serviceType) {
            serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(Consumer<ServiceTypeDetail.Builder>... serviceType) {
            serviceType(Stream.of(serviceType).map(c -> ServiceTypeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceState() {
            return serviceState;
        }

        public final void setServiceState(String serviceState) {
            this.serviceState = serviceState;
        }

        @Override
        public final Builder serviceState(String serviceState) {
            this.serviceState = serviceState;
            return this;
        }

        @Override
        public final Builder serviceState(ServiceState serviceState) {
            this.serviceState(serviceState == null ? null : serviceState.toString());
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = ValueStringListCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = ValueStringListCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String... availabilityZoneIds) {
            availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final Boolean getManagesVpcEndpoints() {
            return managesVpcEndpoints;
        }

        public final void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
        }

        @Override
        public final Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
            return this;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            if (networkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return networkLoadBalancerArns;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
        }

        @Override
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String... networkLoadBalancerArns) {
            networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final Collection<String> getGatewayLoadBalancerArns() {
            if (gatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return gatewayLoadBalancerArns;
        }

        public final void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
        }

        @Override
        public final Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayLoadBalancerArns(String... gatewayLoadBalancerArns) {
            gatewayLoadBalancerArns(Arrays.asList(gatewayLoadBalancerArns));
            return this;
        }

        public final Collection<String> getSupportedIpAddressTypes() {
            if (supportedIpAddressTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedIpAddressTypes;
        }

        public final void setSupportedIpAddressTypes(Collection<String> supportedIpAddressTypes) {
            this.supportedIpAddressTypes = SupportedIpAddressTypesCopier.copy(supportedIpAddressTypes);
        }

        @Override
        public final Builder supportedIpAddressTypesWithStrings(Collection<String> supportedIpAddressTypes) {
            this.supportedIpAddressTypes = SupportedIpAddressTypesCopier.copy(supportedIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIpAddressTypesWithStrings(String... supportedIpAddressTypes) {
            supportedIpAddressTypesWithStrings(Arrays.asList(supportedIpAddressTypes));
            return this;
        }

        @Override
        public final Builder supportedIpAddressTypes(Collection<ServiceConnectivityType> supportedIpAddressTypes) {
            this.supportedIpAddressTypes = SupportedIpAddressTypesCopier.copyEnumToString(supportedIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIpAddressTypes(ServiceConnectivityType... supportedIpAddressTypes) {
            supportedIpAddressTypes(Arrays.asList(supportedIpAddressTypes));
            return this;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            if (baseEndpointDnsNames instanceof SdkAutoConstructList) {
                return null;
            }
            return baseEndpointDnsNames;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String... baseEndpointDnsNames) {
            baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final PrivateDnsNameConfiguration.Builder getPrivateDnsNameConfiguration() {
            return privateDnsNameConfiguration != null ? privateDnsNameConfiguration.toBuilder() : null;
        }

        public final void setPrivateDnsNameConfiguration(PrivateDnsNameConfiguration.BuilderImpl privateDnsNameConfiguration) {
            this.privateDnsNameConfiguration = privateDnsNameConfiguration != null ? privateDnsNameConfiguration.build() : null;
        }

        @Override
        public final Builder privateDnsNameConfiguration(PrivateDnsNameConfiguration privateDnsNameConfiguration) {
            this.privateDnsNameConfiguration = privateDnsNameConfiguration;
            return this;
        }

        public final String getPayerResponsibility() {
            return payerResponsibility;
        }

        public final void setPayerResponsibility(String payerResponsibility) {
            this.payerResponsibility = payerResponsibility;
        }

        @Override
        public final Builder payerResponsibility(String payerResponsibility) {
            this.payerResponsibility = payerResponsibility;
            return this;
        }

        @Override
        public final Builder payerResponsibility(PayerResponsibility payerResponsibility) {
            this.payerResponsibility(payerResponsibility == null ? null : payerResponsibility.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SupportedRegionDetail.Builder> getSupportedRegions() {
            List<SupportedRegionDetail.Builder> result = SupportedRegionSetCopier.copyToBuilder(this.supportedRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedRegions(Collection<SupportedRegionDetail.BuilderImpl> supportedRegions) {
            this.supportedRegions = SupportedRegionSetCopier.copyFromBuilder(supportedRegions);
        }

        @Override
        public final Builder supportedRegions(Collection<SupportedRegionDetail> supportedRegions) {
            this.supportedRegions = SupportedRegionSetCopier.copy(supportedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRegions(SupportedRegionDetail... supportedRegions) {
            supportedRegions(Arrays.asList(supportedRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRegions(Consumer<SupportedRegionDetail.Builder>... supportedRegions) {
            supportedRegions(Stream.of(supportedRegions).map(c -> SupportedRegionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRemoteAccessEnabled() {
            return remoteAccessEnabled;
        }

        public final void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
        }

        @Override
        public final Builder remoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
            return this;
        }

        @Override
        public ServiceConfiguration build() {
            return new ServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
