/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPAM prefix list resolver target.
 * </p>
 * <p>
 * An IPAM prefix list resolver target is an association between a specific customer-managed prefix list and an IPAM
 * prefix list resolver. The target enables the resolver to synchronize CIDRs selected by its rules into the specified
 * prefix list, which can then be referenced in Amazon Web Services resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamPrefixListResolverTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamPrefixListResolverTarget.Builder, IpamPrefixListResolverTarget> {
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPrefixListResolverTargetId")
            .getter(getter(IpamPrefixListResolverTarget::ipamPrefixListResolverTargetId))
            .setter(setter(Builder::ipamPrefixListResolverTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetId")
                    .unmarshallLocationName("ipamPrefixListResolverTargetId").build()).build();

    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_TARGET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPrefixListResolverTargetArn")
            .getter(getter(IpamPrefixListResolverTarget::ipamPrefixListResolverTargetArn))
            .setter(setter(Builder::ipamPrefixListResolverTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetArn")
                    .unmarshallLocationName("ipamPrefixListResolverTargetArn").build()).build();

    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPrefixListResolverId")
            .getter(getter(IpamPrefixListResolverTarget::ipamPrefixListResolverId))
            .setter(setter(Builder::ipamPrefixListResolverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverId")
                    .unmarshallLocationName("ipamPrefixListResolverId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(IpamPrefixListResolverTarget::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(IpamPrefixListResolverTarget::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<String> PREFIX_LIST_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListRegion")
            .getter(getter(IpamPrefixListResolverTarget::prefixListRegion))
            .setter(setter(Builder::prefixListRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListRegion")
                    .unmarshallLocationName("prefixListRegion").build()).build();

    private static final SdkField<Long> DESIRED_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("DesiredVersion")
            .getter(getter(IpamPrefixListResolverTarget::desiredVersion))
            .setter(setter(Builder::desiredVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredVersion")
                    .unmarshallLocationName("desiredVersion").build()).build();

    private static final SdkField<Long> LAST_SYNCED_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("LastSyncedVersion")
            .getter(getter(IpamPrefixListResolverTarget::lastSyncedVersion))
            .setter(setter(Builder::lastSyncedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncedVersion")
                    .unmarshallLocationName("lastSyncedVersion").build()).build();

    private static final SdkField<Boolean> TRACK_LATEST_VERSION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrackLatestVersion")
            .getter(getter(IpamPrefixListResolverTarget::trackLatestVersion))
            .setter(setter(Builder::trackLatestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackLatestVersion")
                    .unmarshallLocationName("trackLatestVersion").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateMessage")
            .getter(getter(IpamPrefixListResolverTarget::stateMessage))
            .setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage")
                    .unmarshallLocationName("stateMessage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(IpamPrefixListResolverTarget::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(IpamPrefixListResolverTarget::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD, IPAM_PREFIX_LIST_RESOLVER_TARGET_ARN_FIELD,
            IPAM_PREFIX_LIST_RESOLVER_ID_FIELD, OWNER_ID_FIELD, PREFIX_LIST_ID_FIELD, PREFIX_LIST_REGION_FIELD,
            DESIRED_VERSION_FIELD, LAST_SYNCED_VERSION_FIELD, TRACK_LATEST_VERSION_FIELD, STATE_MESSAGE_FIELD, STATE_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipamPrefixListResolverTargetId;

    private final String ipamPrefixListResolverTargetArn;

    private final String ipamPrefixListResolverId;

    private final String ownerId;

    private final String prefixListId;

    private final String prefixListRegion;

    private final Long desiredVersion;

    private final Long lastSyncedVersion;

    private final Boolean trackLatestVersion;

    private final String stateMessage;

    private final String state;

    private final List<Tag> tags;

    private IpamPrefixListResolverTarget(BuilderImpl builder) {
        this.ipamPrefixListResolverTargetId = builder.ipamPrefixListResolverTargetId;
        this.ipamPrefixListResolverTargetArn = builder.ipamPrefixListResolverTargetArn;
        this.ipamPrefixListResolverId = builder.ipamPrefixListResolverId;
        this.ownerId = builder.ownerId;
        this.prefixListId = builder.prefixListId;
        this.prefixListRegion = builder.prefixListRegion;
        this.desiredVersion = builder.desiredVersion;
        this.lastSyncedVersion = builder.lastSyncedVersion;
        this.trackLatestVersion = builder.trackLatestVersion;
        this.stateMessage = builder.stateMessage;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the IPAM prefix list resolver target.
     * </p>
     * 
     * @return The ID of the IPAM prefix list resolver target.
     */
    public final String ipamPrefixListResolverTargetId() {
        return ipamPrefixListResolverTargetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IPAM prefix list resolver target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IPAM prefix list resolver target.
     */
    public final String ipamPrefixListResolverTargetArn() {
        return ipamPrefixListResolverTargetArn;
    }

    /**
     * <p>
     * The ID of the IPAM prefix list resolver associated with this target.
     * </p>
     * 
     * @return The ID of the IPAM prefix list resolver associated with this target.
     */
    public final String ipamPrefixListResolverId() {
        return ipamPrefixListResolverId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the IPAM prefix list resolver target.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the IPAM prefix list resolver target.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the managed prefix list associated with this target.
     * </p>
     * 
     * @return The ID of the managed prefix list associated with this target.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the prefix list associated with this target is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the prefix list associated with this target is located.
     */
    public final String prefixListRegion() {
        return prefixListRegion;
    }

    /**
     * <p>
     * The desired version of the prefix list that this target should synchronize with.
     * </p>
     * 
     * @return The desired version of the prefix list that this target should synchronize with.
     */
    public final Long desiredVersion() {
        return desiredVersion;
    }

    /**
     * <p>
     * The version of the prefix list that was last successfully synchronized by this target.
     * </p>
     * 
     * @return The version of the prefix list that was last successfully synchronized by this target.
     */
    public final Long lastSyncedVersion() {
        return lastSyncedVersion;
    }

    /**
     * <p>
     * Indicates whether this target automatically tracks the latest version of the prefix list.
     * </p>
     * 
     * @return Indicates whether this target automatically tracks the latest version of the prefix list.
     */
    public final Boolean trackLatestVersion() {
        return trackLatestVersion;
    }

    /**
     * <p>
     * A message describing the current state of the IPAM prefix list resolver target, including any error information.
     * </p>
     * 
     * @return A message describing the current state of the IPAM prefix list resolver target, including any error
     *         information.
     */
    public final String stateMessage() {
        return stateMessage;
    }

    /**
     * <p>
     * The current state of the IPAM prefix list resolver target. Valid values include <code>create-in-progress</code>,
     * <code>create-complete</code>, <code>create-failed</code>, <code>modify-in-progress</code>,
     * <code>modify-complete</code>, <code>modify-failed</code>, <code>delete-in-progress</code>,
     * <code>delete-complete</code>, and <code>delete-failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IpamPrefixListResolverTargetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the IPAM prefix list resolver target. Valid values include
     *         <code>create-in-progress</code>, <code>create-complete</code>, <code>create-failed</code>,
     *         <code>modify-in-progress</code>, <code>modify-complete</code>, <code>modify-failed</code>,
     *         <code>delete-in-progress</code>, <code>delete-complete</code>, and <code>delete-failed</code>.
     * @see IpamPrefixListResolverTargetState
     */
    public final IpamPrefixListResolverTargetState state() {
        return IpamPrefixListResolverTargetState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the IPAM prefix list resolver target. Valid values include <code>create-in-progress</code>,
     * <code>create-complete</code>, <code>create-failed</code>, <code>modify-in-progress</code>,
     * <code>modify-complete</code>, <code>modify-failed</code>, <code>delete-in-progress</code>,
     * <code>delete-complete</code>, and <code>delete-failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IpamPrefixListResolverTargetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the IPAM prefix list resolver target. Valid values include
     *         <code>create-in-progress</code>, <code>create-complete</code>, <code>create-failed</code>,
     *         <code>modify-in-progress</code>, <code>modify-complete</code>, <code>modify-failed</code>,
     *         <code>delete-in-progress</code>, <code>delete-complete</code>, and <code>delete-failed</code>.
     * @see IpamPrefixListResolverTargetState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the IPAM prefix list resolver target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the IPAM prefix list resolver target.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipamPrefixListResolverTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPrefixListResolverTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPrefixListResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListRegion());
        hashCode = 31 * hashCode + Objects.hashCode(desiredVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastSyncedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(trackLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPrefixListResolverTarget)) {
            return false;
        }
        IpamPrefixListResolverTarget other = (IpamPrefixListResolverTarget) obj;
        return Objects.equals(ipamPrefixListResolverTargetId(), other.ipamPrefixListResolverTargetId())
                && Objects.equals(ipamPrefixListResolverTargetArn(), other.ipamPrefixListResolverTargetArn())
                && Objects.equals(ipamPrefixListResolverId(), other.ipamPrefixListResolverId())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(prefixListRegion(), other.prefixListRegion())
                && Objects.equals(desiredVersion(), other.desiredVersion())
                && Objects.equals(lastSyncedVersion(), other.lastSyncedVersion())
                && Objects.equals(trackLatestVersion(), other.trackLatestVersion())
                && Objects.equals(stateMessage(), other.stateMessage()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamPrefixListResolverTarget")
                .add("IpamPrefixListResolverTargetId", ipamPrefixListResolverTargetId())
                .add("IpamPrefixListResolverTargetArn", ipamPrefixListResolverTargetArn())
                .add("IpamPrefixListResolverId", ipamPrefixListResolverId()).add("OwnerId", ownerId())
                .add("PrefixListId", prefixListId()).add("PrefixListRegion", prefixListRegion())
                .add("DesiredVersion", desiredVersion()).add("LastSyncedVersion", lastSyncedVersion())
                .add("TrackLatestVersion", trackLatestVersion()).add("StateMessage", stateMessage())
                .add("State", stateAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPrefixListResolverTargetId":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolverTargetId()));
        case "IpamPrefixListResolverTargetArn":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolverTargetArn()));
        case "IpamPrefixListResolverId":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolverId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "PrefixListRegion":
            return Optional.ofNullable(clazz.cast(prefixListRegion()));
        case "DesiredVersion":
            return Optional.ofNullable(clazz.cast(desiredVersion()));
        case "LastSyncedVersion":
            return Optional.ofNullable(clazz.cast(lastSyncedVersion()));
        case "TrackLatestVersion":
            return Optional.ofNullable(clazz.cast(trackLatestVersion()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPrefixListResolverTargetId", IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD);
        map.put("IpamPrefixListResolverTargetArn", IPAM_PREFIX_LIST_RESOLVER_TARGET_ARN_FIELD);
        map.put("IpamPrefixListResolverId", IPAM_PREFIX_LIST_RESOLVER_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("PrefixListRegion", PREFIX_LIST_REGION_FIELD);
        map.put("DesiredVersion", DESIRED_VERSION_FIELD);
        map.put("LastSyncedVersion", LAST_SYNCED_VERSION_FIELD);
        map.put("TrackLatestVersion", TRACK_LATEST_VERSION_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPrefixListResolverTarget, T> g) {
        return obj -> g.apply((IpamPrefixListResolverTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamPrefixListResolverTarget> {
        /**
         * <p>
         * The ID of the IPAM prefix list resolver target.
         * </p>
         * 
         * @param ipamPrefixListResolverTargetId
         *        The ID of the IPAM prefix list resolver target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IPAM prefix list resolver target.
         * </p>
         * 
         * @param ipamPrefixListResolverTargetArn
         *        The Amazon Resource Name (ARN) of the IPAM prefix list resolver target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverTargetArn(String ipamPrefixListResolverTargetArn);

        /**
         * <p>
         * The ID of the IPAM prefix list resolver associated with this target.
         * </p>
         * 
         * @param ipamPrefixListResolverId
         *        The ID of the IPAM prefix list resolver associated with this target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverId(String ipamPrefixListResolverId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the IPAM prefix list resolver target.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the IPAM prefix list resolver target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the managed prefix list associated with this target.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the managed prefix list associated with this target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The Amazon Web Services Region where the prefix list associated with this target is located.
         * </p>
         * 
         * @param prefixListRegion
         *        The Amazon Web Services Region where the prefix list associated with this target is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListRegion(String prefixListRegion);

        /**
         * <p>
         * The desired version of the prefix list that this target should synchronize with.
         * </p>
         * 
         * @param desiredVersion
         *        The desired version of the prefix list that this target should synchronize with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredVersion(Long desiredVersion);

        /**
         * <p>
         * The version of the prefix list that was last successfully synchronized by this target.
         * </p>
         * 
         * @param lastSyncedVersion
         *        The version of the prefix list that was last successfully synchronized by this target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSyncedVersion(Long lastSyncedVersion);

        /**
         * <p>
         * Indicates whether this target automatically tracks the latest version of the prefix list.
         * </p>
         * 
         * @param trackLatestVersion
         *        Indicates whether this target automatically tracks the latest version of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackLatestVersion(Boolean trackLatestVersion);

        /**
         * <p>
         * A message describing the current state of the IPAM prefix list resolver target, including any error
         * information.
         * </p>
         * 
         * @param stateMessage
         *        A message describing the current state of the IPAM prefix list resolver target, including any error
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);

        /**
         * <p>
         * The current state of the IPAM prefix list resolver target. Valid values include
         * <code>create-in-progress</code>, <code>create-complete</code>, <code>create-failed</code>,
         * <code>modify-in-progress</code>, <code>modify-complete</code>, <code>modify-failed</code>,
         * <code>delete-in-progress</code>, <code>delete-complete</code>, and <code>delete-failed</code>.
         * </p>
         * 
         * @param state
         *        The current state of the IPAM prefix list resolver target. Valid values include
         *        <code>create-in-progress</code>, <code>create-complete</code>, <code>create-failed</code>,
         *        <code>modify-in-progress</code>, <code>modify-complete</code>, <code>modify-failed</code>,
         *        <code>delete-in-progress</code>, <code>delete-complete</code>, and <code>delete-failed</code>.
         * @see IpamPrefixListResolverTargetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPrefixListResolverTargetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the IPAM prefix list resolver target. Valid values include
         * <code>create-in-progress</code>, <code>create-complete</code>, <code>create-failed</code>,
         * <code>modify-in-progress</code>, <code>modify-complete</code>, <code>modify-failed</code>,
         * <code>delete-in-progress</code>, <code>delete-complete</code>, and <code>delete-failed</code>.
         * </p>
         * 
         * @param state
         *        The current state of the IPAM prefix list resolver target. Valid values include
         *        <code>create-in-progress</code>, <code>create-complete</code>, <code>create-failed</code>,
         *        <code>modify-in-progress</code>, <code>modify-complete</code>, <code>modify-failed</code>,
         *        <code>delete-in-progress</code>, <code>delete-complete</code>, and <code>delete-failed</code>.
         * @see IpamPrefixListResolverTargetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPrefixListResolverTargetState
         */
        Builder state(IpamPrefixListResolverTargetState state);

        /**
         * <p>
         * The tags assigned to the IPAM prefix list resolver target.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the IPAM prefix list resolver target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the IPAM prefix list resolver target.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the IPAM prefix list resolver target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the IPAM prefix list resolver target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String ipamPrefixListResolverTargetId;

        private String ipamPrefixListResolverTargetArn;

        private String ipamPrefixListResolverId;

        private String ownerId;

        private String prefixListId;

        private String prefixListRegion;

        private Long desiredVersion;

        private Long lastSyncedVersion;

        private Boolean trackLatestVersion;

        private String stateMessage;

        private String state;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPrefixListResolverTarget model) {
            ipamPrefixListResolverTargetId(model.ipamPrefixListResolverTargetId);
            ipamPrefixListResolverTargetArn(model.ipamPrefixListResolverTargetArn);
            ipamPrefixListResolverId(model.ipamPrefixListResolverId);
            ownerId(model.ownerId);
            prefixListId(model.prefixListId);
            prefixListRegion(model.prefixListRegion);
            desiredVersion(model.desiredVersion);
            lastSyncedVersion(model.lastSyncedVersion);
            trackLatestVersion(model.trackLatestVersion);
            stateMessage(model.stateMessage);
            state(model.state);
            tags(model.tags);
        }

        public final String getIpamPrefixListResolverTargetId() {
            return ipamPrefixListResolverTargetId;
        }

        public final void setIpamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
        }

        @Override
        public final Builder ipamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
            return this;
        }

        public final String getIpamPrefixListResolverTargetArn() {
            return ipamPrefixListResolverTargetArn;
        }

        public final void setIpamPrefixListResolverTargetArn(String ipamPrefixListResolverTargetArn) {
            this.ipamPrefixListResolverTargetArn = ipamPrefixListResolverTargetArn;
        }

        @Override
        public final Builder ipamPrefixListResolverTargetArn(String ipamPrefixListResolverTargetArn) {
            this.ipamPrefixListResolverTargetArn = ipamPrefixListResolverTargetArn;
            return this;
        }

        public final String getIpamPrefixListResolverId() {
            return ipamPrefixListResolverId;
        }

        public final void setIpamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
        }

        @Override
        public final Builder ipamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListRegion() {
            return prefixListRegion;
        }

        public final void setPrefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
        }

        @Override
        public final Builder prefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
            return this;
        }

        public final Long getDesiredVersion() {
            return desiredVersion;
        }

        public final void setDesiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
        }

        @Override
        public final Builder desiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
            return this;
        }

        public final Long getLastSyncedVersion() {
            return lastSyncedVersion;
        }

        public final void setLastSyncedVersion(Long lastSyncedVersion) {
            this.lastSyncedVersion = lastSyncedVersion;
        }

        @Override
        public final Builder lastSyncedVersion(Long lastSyncedVersion) {
            this.lastSyncedVersion = lastSyncedVersion;
            return this;
        }

        public final Boolean getTrackLatestVersion() {
            return trackLatestVersion;
        }

        public final void setTrackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
        }

        @Override
        public final Builder trackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
            return this;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamPrefixListResolverTargetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public IpamPrefixListResolverTarget build() {
            return new IpamPrefixListResolverTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
