/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableIpamPolicyResponse extends Ec2Response implements
        ToCopyableBuilder<EnableIpamPolicyResponse.Builder, EnableIpamPolicyResponse> {
    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPolicyId")
            .getter(getter(EnableIpamPolicyResponse::ipamPolicyId))
            .setter(setter(Builder::ipamPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId")
                    .unmarshallLocationName("ipamPolicyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POLICY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ipamPolicyId;

    private EnableIpamPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPolicyId = builder.ipamPolicyId;
    }

    /**
     * <p>
     * The ID of the IPAM policy that was enabled.
     * </p>
     * 
     * @return The ID of the IPAM policy that was enabled.
     */
    public final String ipamPolicyId() {
        return ipamPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPolicyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableIpamPolicyResponse)) {
            return false;
        }
        EnableIpamPolicyResponse other = (EnableIpamPolicyResponse) obj;
        return Objects.equals(ipamPolicyId(), other.ipamPolicyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableIpamPolicyResponse").add("IpamPolicyId", ipamPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPolicyId":
            return Optional.ofNullable(clazz.cast(ipamPolicyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableIpamPolicyResponse, T> g) {
        return obj -> g.apply((EnableIpamPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, EnableIpamPolicyResponse> {
        /**
         * <p>
         * The ID of the IPAM policy that was enabled.
         * </p>
         * 
         * @param ipamPolicyId
         *        The ID of the IPAM policy that was enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPolicyId(String ipamPolicyId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String ipamPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableIpamPolicyResponse model) {
            super(model);
            ipamPolicyId(model.ipamPolicyId);
        }

        public final String getIpamPolicyId() {
            return ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        @Override
        public EnableIpamPolicyResponse build() {
            return new EnableIpamPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
