/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the availability of capacity for a Capacity Reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationStatus.Builder, CapacityReservationStatus> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(CapacityReservationStatus::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<Integer> TOTAL_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCapacity")
            .getter(getter(CapacityReservationStatus::totalCapacity))
            .setter(setter(Builder::totalCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCapacity")
                    .unmarshallLocationName("totalCapacity").build()).build();

    private static final SdkField<Integer> TOTAL_AVAILABLE_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalAvailableCapacity")
            .getter(getter(CapacityReservationStatus::totalAvailableCapacity))
            .setter(setter(Builder::totalAvailableCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAvailableCapacity")
                    .unmarshallLocationName("totalAvailableCapacity").build()).build();

    private static final SdkField<Integer> TOTAL_UNAVAILABLE_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalUnavailableCapacity")
            .getter(getter(CapacityReservationStatus::totalUnavailableCapacity))
            .setter(setter(Builder::totalUnavailableCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUnavailableCapacity")
                    .unmarshallLocationName("totalUnavailableCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            TOTAL_CAPACITY_FIELD, TOTAL_AVAILABLE_CAPACITY_FIELD, TOTAL_UNAVAILABLE_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationId;

    private final Integer totalCapacity;

    private final Integer totalAvailableCapacity;

    private final Integer totalUnavailableCapacity;

    private CapacityReservationStatus(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.totalCapacity = builder.totalCapacity;
        this.totalAvailableCapacity = builder.totalAvailableCapacity;
        this.totalUnavailableCapacity = builder.totalUnavailableCapacity;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The combined amount of <code>Available</code> and <code>Unavailable</code> capacity in the Capacity Reservation.
     * </p>
     * 
     * @return The combined amount of <code>Available</code> and <code>Unavailable</code> capacity in the Capacity
     *         Reservation.
     */
    public final Integer totalCapacity() {
        return totalCapacity;
    }

    /**
     * <p>
     * The remaining capacity. Indicates the amount of resources that can be launched into the Capacity Reservation.
     * </p>
     * 
     * @return The remaining capacity. Indicates the amount of resources that can be launched into the Capacity
     *         Reservation.
     */
    public final Integer totalAvailableCapacity() {
        return totalAvailableCapacity;
    }

    /**
     * <p>
     * The used capacity. Indicates that the capacity is in use by resources that are running in the Capacity
     * Reservation.
     * </p>
     * 
     * @return The used capacity. Indicates that the capacity is in use by resources that are running in the Capacity
     *         Reservation.
     */
    public final Integer totalUnavailableCapacity() {
        return totalUnavailableCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(totalCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(totalAvailableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(totalUnavailableCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationStatus)) {
            return false;
        }
        CapacityReservationStatus other = (CapacityReservationStatus) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(totalCapacity(), other.totalCapacity())
                && Objects.equals(totalAvailableCapacity(), other.totalAvailableCapacity())
                && Objects.equals(totalUnavailableCapacity(), other.totalUnavailableCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservationStatus").add("CapacityReservationId", capacityReservationId())
                .add("TotalCapacity", totalCapacity()).add("TotalAvailableCapacity", totalAvailableCapacity())
                .add("TotalUnavailableCapacity", totalUnavailableCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "TotalCapacity":
            return Optional.ofNullable(clazz.cast(totalCapacity()));
        case "TotalAvailableCapacity":
            return Optional.ofNullable(clazz.cast(totalAvailableCapacity()));
        case "TotalUnavailableCapacity":
            return Optional.ofNullable(clazz.cast(totalUnavailableCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("TotalCapacity", TOTAL_CAPACITY_FIELD);
        map.put("TotalAvailableCapacity", TOTAL_AVAILABLE_CAPACITY_FIELD);
        map.put("TotalUnavailableCapacity", TOTAL_UNAVAILABLE_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationStatus, T> g) {
        return obj -> g.apply((CapacityReservationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationStatus> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The combined amount of <code>Available</code> and <code>Unavailable</code> capacity in the Capacity
         * Reservation.
         * </p>
         * 
         * @param totalCapacity
         *        The combined amount of <code>Available</code> and <code>Unavailable</code> capacity in the Capacity
         *        Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCapacity(Integer totalCapacity);

        /**
         * <p>
         * The remaining capacity. Indicates the amount of resources that can be launched into the Capacity Reservation.
         * </p>
         * 
         * @param totalAvailableCapacity
         *        The remaining capacity. Indicates the amount of resources that can be launched into the Capacity
         *        Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAvailableCapacity(Integer totalAvailableCapacity);

        /**
         * <p>
         * The used capacity. Indicates that the capacity is in use by resources that are running in the Capacity
         * Reservation.
         * </p>
         * 
         * @param totalUnavailableCapacity
         *        The used capacity. Indicates that the capacity is in use by resources that are running in the Capacity
         *        Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalUnavailableCapacity(Integer totalUnavailableCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationId;

        private Integer totalCapacity;

        private Integer totalAvailableCapacity;

        private Integer totalUnavailableCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationStatus model) {
            capacityReservationId(model.capacityReservationId);
            totalCapacity(model.totalCapacity);
            totalAvailableCapacity(model.totalAvailableCapacity);
            totalUnavailableCapacity(model.totalUnavailableCapacity);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final Integer getTotalCapacity() {
            return totalCapacity;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public final Integer getTotalAvailableCapacity() {
            return totalAvailableCapacity;
        }

        public final void setTotalAvailableCapacity(Integer totalAvailableCapacity) {
            this.totalAvailableCapacity = totalAvailableCapacity;
        }

        @Override
        public final Builder totalAvailableCapacity(Integer totalAvailableCapacity) {
            this.totalAvailableCapacity = totalAvailableCapacity;
            return this;
        }

        public final Integer getTotalUnavailableCapacity() {
            return totalUnavailableCapacity;
        }

        public final void setTotalUnavailableCapacity(Integer totalUnavailableCapacity) {
            this.totalUnavailableCapacity = totalUnavailableCapacity;
        }

        @Override
        public final Builder totalUnavailableCapacity(Integer totalUnavailableCapacity) {
            this.totalUnavailableCapacity = totalUnavailableCapacity;
            return this;
        }

        @Override
        public CapacityReservationStatus build() {
            return new CapacityReservationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
