/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRuleListRequestCopier;
import software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRuleRequest;
import software.amazon.awssdk.services.ec2.model.IpamPolicyResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpamPolicyAllocationRulesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIpamPolicyAllocationRulesRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyIpamPolicyAllocationRulesRequest.getter(ModifyIpamPolicyAllocationRulesRequest::dryRun)).setter(ModifyIpamPolicyAllocationRulesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPolicyId").getter(ModifyIpamPolicyAllocationRulesRequest.getter(ModifyIpamPolicyAllocationRulesRequest::ipamPolicyId)).setter(ModifyIpamPolicyAllocationRulesRequest.setter(Builder::ipamPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId").unmarshallLocationName("IpamPolicyId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(ModifyIpamPolicyAllocationRulesRequest.getter(ModifyIpamPolicyAllocationRulesRequest::locale)).setter(ModifyIpamPolicyAllocationRulesRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").unmarshallLocationName("Locale").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ModifyIpamPolicyAllocationRulesRequest.getter(ModifyIpamPolicyAllocationRulesRequest::resourceTypeAsString)).setter(ModifyIpamPolicyAllocationRulesRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("ResourceType").build()}).build();
    private static final SdkField<List<IpamPolicyAllocationRuleRequest>> ALLOCATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllocationRules").getter(ModifyIpamPolicyAllocationRulesRequest.getter(ModifyIpamPolicyAllocationRulesRequest::allocationRules)).setter(ModifyIpamPolicyAllocationRulesRequest.setter(Builder::allocationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationRule").unmarshallLocationName("AllocationRule").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPolicyAllocationRuleRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_POLICY_ID_FIELD, LOCALE_FIELD, RESOURCE_TYPE_FIELD, ALLOCATION_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyIpamPolicyAllocationRulesRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamPolicyId;
    private final String locale;
    private final String resourceType;
    private final List<IpamPolicyAllocationRuleRequest> allocationRules;

    private ModifyIpamPolicyAllocationRulesRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPolicyId = builder.ipamPolicyId;
        this.locale = builder.locale;
        this.resourceType = builder.resourceType;
        this.allocationRules = builder.allocationRules;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPolicyId() {
        return this.ipamPolicyId;
    }

    public final String locale() {
        return this.locale;
    }

    public final IpamPolicyResourceType resourceType() {
        return IpamPolicyResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasAllocationRules() {
        return this.allocationRules != null && !(this.allocationRules instanceof SdkAutoConstructList);
    }

    public final List<IpamPolicyAllocationRuleRequest> allocationRules() {
        return this.allocationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllocationRules() ? this.allocationRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPolicyAllocationRulesRequest)) {
            return false;
        }
        ModifyIpamPolicyAllocationRulesRequest other = (ModifyIpamPolicyAllocationRulesRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPolicyId(), other.ipamPolicyId()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasAllocationRules() == other.hasAllocationRules() && Objects.equals(this.allocationRules(), other.allocationRules());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpamPolicyAllocationRulesRequest").add("DryRun", (Object)this.dryRun()).add("IpamPolicyId", (Object)this.ipamPolicyId()).add("Locale", (Object)this.locale()).add("ResourceType", (Object)this.resourceTypeAsString()).add("AllocationRules", this.hasAllocationRules() ? this.allocationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPolicyId": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyId()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "AllocationRules": {
                return Optional.ofNullable(clazz.cast(this.allocationRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("AllocationRule", ALLOCATION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamPolicyAllocationRulesRequest, T> g) {
        return obj -> g.apply((ModifyIpamPolicyAllocationRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPolicyId;
        private String locale;
        private String resourceType;
        private List<IpamPolicyAllocationRuleRequest> allocationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamPolicyAllocationRulesRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPolicyId(model.ipamPolicyId);
            this.locale(model.locale);
            this.resourceType(model.resourceType);
            this.allocationRules(model.allocationRules);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPolicyId() {
            return this.ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamPolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamPolicyAllocationRuleRequest.Builder> getAllocationRules() {
            List<IpamPolicyAllocationRuleRequest.Builder> result = IpamPolicyAllocationRuleListRequestCopier.copyToBuilder(this.allocationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllocationRules(Collection<IpamPolicyAllocationRuleRequest.BuilderImpl> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListRequestCopier.copyFromBuilder(allocationRules);
        }

        @Override
        public final Builder allocationRules(Collection<IpamPolicyAllocationRuleRequest> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListRequestCopier.copy(allocationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(IpamPolicyAllocationRuleRequest ... allocationRules) {
            this.allocationRules(Arrays.asList(allocationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(Consumer<IpamPolicyAllocationRuleRequest.Builder> ... allocationRules) {
            this.allocationRules(Stream.of(allocationRules).map(c -> (IpamPolicyAllocationRuleRequest)((IpamPolicyAllocationRuleRequest.Builder)IpamPolicyAllocationRuleRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamPolicyAllocationRulesRequest build() {
            return new ModifyIpamPolicyAllocationRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpamPolicyAllocationRulesRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPolicyId(String var1);

        public Builder locale(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamPolicyResourceType var1);

        public Builder allocationRules(Collection<IpamPolicyAllocationRuleRequest> var1);

        public Builder allocationRules(IpamPolicyAllocationRuleRequest ... var1);

        public Builder allocationRules(Consumer<IpamPolicyAllocationRuleRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

