/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about how and when instances in an interruptible reservation can be terminated when capacity is
 * reclaimed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InterruptionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InterruptionInfo.Builder, InterruptionInfo> {
    private static final SdkField<String> SOURCE_CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCapacityReservationId")
            .getter(getter(InterruptionInfo::sourceCapacityReservationId))
            .setter(setter(Builder::sourceCapacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservationId")
                    .unmarshallLocationName("sourceCapacityReservationId").build()).build();

    private static final SdkField<String> INTERRUPTION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterruptionType")
            .getter(getter(InterruptionInfo::interruptionTypeAsString))
            .setter(setter(Builder::interruptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionType")
                    .unmarshallLocationName("interruptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_CAPACITY_RESERVATION_ID_FIELD, INTERRUPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceCapacityReservationId;

    private final String interruptionType;

    private InterruptionInfo(BuilderImpl builder) {
        this.sourceCapacityReservationId = builder.sourceCapacityReservationId;
        this.interruptionType = builder.interruptionType;
    }

    /**
     * <p>
     * The ID of the source Capacity Reservation from which the interruptible reservation was created.
     * </p>
     * 
     * @return The ID of the source Capacity Reservation from which the interruptible reservation was created.
     */
    public final String sourceCapacityReservationId() {
        return sourceCapacityReservationId;
    }

    /**
     * <p>
     * The interruption type that determines how instances are terminated when capacity is reclaimed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interruptionType}
     * will return {@link InterruptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interruptionTypeAsString}.
     * </p>
     * 
     * @return The interruption type that determines how instances are terminated when capacity is reclaimed.
     * @see InterruptionType
     */
    public final InterruptionType interruptionType() {
        return InterruptionType.fromValue(interruptionType);
    }

    /**
     * <p>
     * The interruption type that determines how instances are terminated when capacity is reclaimed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interruptionType}
     * will return {@link InterruptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interruptionTypeAsString}.
     * </p>
     * 
     * @return The interruption type that determines how instances are terminated when capacity is reclaimed.
     * @see InterruptionType
     */
    public final String interruptionTypeAsString() {
        return interruptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(interruptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterruptionInfo)) {
            return false;
        }
        InterruptionInfo other = (InterruptionInfo) obj;
        return Objects.equals(sourceCapacityReservationId(), other.sourceCapacityReservationId())
                && Objects.equals(interruptionTypeAsString(), other.interruptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InterruptionInfo").add("SourceCapacityReservationId", sourceCapacityReservationId())
                .add("InterruptionType", interruptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceCapacityReservationId":
            return Optional.ofNullable(clazz.cast(sourceCapacityReservationId()));
        case "InterruptionType":
            return Optional.ofNullable(clazz.cast(interruptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceCapacityReservationId", SOURCE_CAPACITY_RESERVATION_ID_FIELD);
        map.put("InterruptionType", INTERRUPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InterruptionInfo, T> g) {
        return obj -> g.apply((InterruptionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InterruptionInfo> {
        /**
         * <p>
         * The ID of the source Capacity Reservation from which the interruptible reservation was created.
         * </p>
         * 
         * @param sourceCapacityReservationId
         *        The ID of the source Capacity Reservation from which the interruptible reservation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCapacityReservationId(String sourceCapacityReservationId);

        /**
         * <p>
         * The interruption type that determines how instances are terminated when capacity is reclaimed.
         * </p>
         * 
         * @param interruptionType
         *        The interruption type that determines how instances are terminated when capacity is reclaimed.
         * @see InterruptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterruptionType
         */
        Builder interruptionType(String interruptionType);

        /**
         * <p>
         * The interruption type that determines how instances are terminated when capacity is reclaimed.
         * </p>
         * 
         * @param interruptionType
         *        The interruption type that determines how instances are terminated when capacity is reclaimed.
         * @see InterruptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterruptionType
         */
        Builder interruptionType(InterruptionType interruptionType);
    }

    static final class BuilderImpl implements Builder {
        private String sourceCapacityReservationId;

        private String interruptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(InterruptionInfo model) {
            sourceCapacityReservationId(model.sourceCapacityReservationId);
            interruptionType(model.interruptionType);
        }

        public final String getSourceCapacityReservationId() {
            return sourceCapacityReservationId;
        }

        public final void setSourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
        }

        @Override
        public final Builder sourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
            return this;
        }

        public final String getInterruptionType() {
            return interruptionType;
        }

        public final void setInterruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
        }

        @Override
        public final Builder interruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
            return this;
        }

        @Override
        public final Builder interruptionType(InterruptionType interruptionType) {
            this.interruptionType(interruptionType == null ? null : interruptionType.toString());
            return this;
        }

        @Override
        public InterruptionInfo build() {
            return new InterruptionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
