/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpamPrefixListResolverVersionsResponse extends Ec2Response implements
        ToCopyableBuilder<GetIpamPrefixListResolverVersionsResponse.Builder, GetIpamPrefixListResolverVersionsResponse> {
    private static final SdkField<List<IpamPrefixListResolverVersion>> IPAM_PREFIX_LIST_RESOLVER_VERSIONS_FIELD = SdkField
            .<List<IpamPrefixListResolverVersion>> builder(MarshallingType.LIST)
            .memberName("IpamPrefixListResolverVersions")
            .getter(getter(GetIpamPrefixListResolverVersionsResponse::ipamPrefixListResolverVersions))
            .setter(setter(Builder::ipamPrefixListResolverVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverVersionSet")
                    .unmarshallLocationName("ipamPrefixListResolverVersionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamPrefixListResolverVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamPrefixListResolverVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetIpamPrefixListResolverVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IPAM_PREFIX_LIST_RESOLVER_VERSIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<IpamPrefixListResolverVersion> ipamPrefixListResolverVersions;

    private final String nextToken;

    private GetIpamPrefixListResolverVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPrefixListResolverVersions = builder.ipamPrefixListResolverVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamPrefixListResolverVersions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpamPrefixListResolverVersions() {
        return ipamPrefixListResolverVersions != null && !(ipamPrefixListResolverVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPAM prefix list resolver versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamPrefixListResolverVersions} method.
     * </p>
     * 
     * @return Information about the IPAM prefix list resolver versions.
     */
    public final List<IpamPrefixListResolverVersion> ipamPrefixListResolverVersions() {
        return ipamPrefixListResolverVersions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIpamPrefixListResolverVersions() ? ipamPrefixListResolverVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamPrefixListResolverVersionsResponse)) {
            return false;
        }
        GetIpamPrefixListResolverVersionsResponse other = (GetIpamPrefixListResolverVersionsResponse) obj;
        return hasIpamPrefixListResolverVersions() == other.hasIpamPrefixListResolverVersions()
                && Objects.equals(ipamPrefixListResolverVersions(), other.ipamPrefixListResolverVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetIpamPrefixListResolverVersionsResponse")
                .add("IpamPrefixListResolverVersions",
                        hasIpamPrefixListResolverVersions() ? ipamPrefixListResolverVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPrefixListResolverVersions":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolverVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPrefixListResolverVersionSet", IPAM_PREFIX_LIST_RESOLVER_VERSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamPrefixListResolverVersionsResponse, T> g) {
        return obj -> g.apply((GetIpamPrefixListResolverVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIpamPrefixListResolverVersionsResponse> {
        /**
         * <p>
         * Information about the IPAM prefix list resolver versions.
         * </p>
         * 
         * @param ipamPrefixListResolverVersions
         *        Information about the IPAM prefix list resolver versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverVersions(Collection<IpamPrefixListResolverVersion> ipamPrefixListResolverVersions);

        /**
         * <p>
         * Information about the IPAM prefix list resolver versions.
         * </p>
         * 
         * @param ipamPrefixListResolverVersions
         *        Information about the IPAM prefix list resolver versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverVersions(IpamPrefixListResolverVersion... ipamPrefixListResolverVersions);

        /**
         * <p>
         * Information about the IPAM prefix list resolver versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersion.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #ipamPrefixListResolverVersions(List<IpamPrefixListResolverVersion>)}.
         * 
         * @param ipamPrefixListResolverVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPrefixListResolverVersions(java.util.Collection<IpamPrefixListResolverVersion>)
         */
        Builder ipamPrefixListResolverVersions(Consumer<IpamPrefixListResolverVersion.Builder>... ipamPrefixListResolverVersions);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<IpamPrefixListResolverVersion> ipamPrefixListResolverVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamPrefixListResolverVersionsResponse model) {
            super(model);
            ipamPrefixListResolverVersions(model.ipamPrefixListResolverVersions);
            nextToken(model.nextToken);
        }

        public final List<IpamPrefixListResolverVersion.Builder> getIpamPrefixListResolverVersions() {
            List<IpamPrefixListResolverVersion.Builder> result = IpamPrefixListResolverVersionSetCopier
                    .copyToBuilder(this.ipamPrefixListResolverVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPrefixListResolverVersions(
                Collection<IpamPrefixListResolverVersion.BuilderImpl> ipamPrefixListResolverVersions) {
            this.ipamPrefixListResolverVersions = IpamPrefixListResolverVersionSetCopier
                    .copyFromBuilder(ipamPrefixListResolverVersions);
        }

        @Override
        public final Builder ipamPrefixListResolverVersions(
                Collection<IpamPrefixListResolverVersion> ipamPrefixListResolverVersions) {
            this.ipamPrefixListResolverVersions = IpamPrefixListResolverVersionSetCopier.copy(ipamPrefixListResolverVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPrefixListResolverVersions(IpamPrefixListResolverVersion... ipamPrefixListResolverVersions) {
            ipamPrefixListResolverVersions(Arrays.asList(ipamPrefixListResolverVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPrefixListResolverVersions(
                Consumer<IpamPrefixListResolverVersion.Builder>... ipamPrefixListResolverVersions) {
            ipamPrefixListResolverVersions(Stream.of(ipamPrefixListResolverVersions)
                    .map(c -> IpamPrefixListResolverVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamPrefixListResolverVersionsResponse build() {
            return new GetIpamPrefixListResolverVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
