/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCapacityManagerMetricDataRequest extends Ec2Request implements
        ToCopyableBuilder<GetCapacityManagerMetricDataRequest.Builder, GetCapacityManagerMetricDataRequest> {
    private static final SdkField<List<String>> METRIC_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricNames")
            .getter(getter(GetCapacityManagerMetricDataRequest::metricNamesAsStrings))
            .setter(setter(Builder::metricNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName")
                    .unmarshallLocationName("MetricName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(GetCapacityManagerMetricDataRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(GetCapacityManagerMetricDataRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime")
                    .unmarshallLocationName("EndTime").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period")
            .getter(getter(GetCapacityManagerMetricDataRequest::period))
            .setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period")
                    .unmarshallLocationName("Period").build()).build();

    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupBy")
            .getter(getter(GetCapacityManagerMetricDataRequest::groupByAsStrings))
            .setter(setter(Builder::groupByWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy")
                    .unmarshallLocationName("GroupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<CapacityManagerCondition>> FILTER_BY_FIELD = SdkField
            .<List<CapacityManagerCondition>> builder(MarshallingType.LIST)
            .memberName("FilterBy")
            .getter(getter(GetCapacityManagerMetricDataRequest::filterBy))
            .setter(setter(Builder::filterBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBy")
                    .unmarshallLocationName("FilterBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityManagerCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityManagerCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(GetCapacityManagerMetricDataRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetCapacityManagerMetricDataRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(GetCapacityManagerMetricDataRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAMES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD, GROUP_BY_FIELD, FILTER_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> metricNames;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer period;

    private final List<String> groupBy;

    private final List<CapacityManagerCondition> filterBy;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean dryRun;

    private GetCapacityManagerMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.metricNames = builder.metricNames;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.groupBy = builder.groupBy;
        this.filterBy = builder.filterBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The names of the metrics to retrieve. Maximum of 10 metrics per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricNames} method.
     * </p>
     * 
     * @return The names of the metrics to retrieve. Maximum of 10 metrics per request.
     */
    public final List<Metric> metricNames() {
        return MetricSetCopier.copyStringToEnum(metricNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricNames() {
        return metricNames != null && !(metricNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the metrics to retrieve. Maximum of 10 metrics per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricNames} method.
     * </p>
     * 
     * @return The names of the metrics to retrieve. Maximum of 10 metrics per request.
     */
    public final List<String> metricNamesAsStrings() {
        return metricNames;
    }

    /**
     * <p>
     * The start time for the metric data query, in ISO 8601 format. The time range (end time - start time) must be a
     * multiple of the specified period.
     * </p>
     * 
     * @return The start time for the metric data query, in ISO 8601 format. The time range (end time - start time) must
     *         be a multiple of the specified period.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the metric data query, in ISO 8601 format. If the end time is beyond the latest ingested data,
     * it will be automatically adjusted to the latest available data point.
     * </p>
     * 
     * @return The end time for the metric data query, in ISO 8601 format. If the end time is beyond the latest ingested
     *         data, it will be automatically adjusted to the latest available data point.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points.
     * </p>
     * 
     * @return The granularity, in seconds, of the returned data points.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The dimensions by which to group the metric data. This determines how the data is aggregated and returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return The dimensions by which to group the metric data. This determines how the data is aggregated and
     *         returned.
     */
    public final List<GroupBy> groupBy() {
        return GroupBySetCopier.copyStringToEnum(groupBy);
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions by which to group the metric data. This determines how the data is aggregated and returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return The dimensions by which to group the metric data. This determines how the data is aggregated and
     *         returned.
     */
    public final List<String> groupByAsStrings() {
        return groupBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterBy() {
        return filterBy != null && !(filterBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Conditions to filter the metric data. Each filter specifies a dimension, comparison operator ('equals', 'in'),
     * and values to match against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterBy} method.
     * </p>
     * 
     * @return Conditions to filter the metric data. Each filter specifies a dimension, comparison operator ('equals',
     *         'in'), and values to match against.
     */
    public final List<CapacityManagerCondition> filterBy() {
        return filterBy;
    }

    /**
     * <p>
     * The maximum number of data points to return. Valid range is 1 to 100,000. Use with NextToken for pagination of
     * large result sets.
     * </p>
     * 
     * @return The maximum number of data points to return. Valid range is 1 to 100,000. Use with NextToken for
     *         pagination of large result sets.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results. Use this value in a subsequent call to retrieve additional data points.
     * </p>
     * 
     * @return The token for the next page of results. Use this value in a subsequent call to retrieve additional data
     *         points.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricNames() ? metricNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterBy() ? filterBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityManagerMetricDataRequest)) {
            return false;
        }
        GetCapacityManagerMetricDataRequest other = (GetCapacityManagerMetricDataRequest) obj;
        return hasMetricNames() == other.hasMetricNames() && Objects.equals(metricNamesAsStrings(), other.metricNamesAsStrings())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(period(), other.period()) && hasGroupBy() == other.hasGroupBy()
                && Objects.equals(groupByAsStrings(), other.groupByAsStrings()) && hasFilterBy() == other.hasFilterBy()
                && Objects.equals(filterBy(), other.filterBy()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCapacityManagerMetricDataRequest")
                .add("MetricNames", hasMetricNames() ? metricNamesAsStrings() : null).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Period", period()).add("GroupBy", hasGroupBy() ? groupByAsStrings() : null)
                .add("FilterBy", hasFilterBy() ? filterBy() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricNames":
            return Optional.ofNullable(clazz.cast(metricNamesAsStrings()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupByAsStrings()));
        case "FilterBy":
            return Optional.ofNullable(clazz.cast(filterBy()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricName", METRIC_NAMES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("FilterBy", FILTER_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityManagerMetricDataRequest, T> g) {
        return obj -> g.apply((GetCapacityManagerMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetCapacityManagerMetricDataRequest> {
        /**
         * <p>
         * The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * </p>
         * 
         * @param metricNames
         *        The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamesWithStrings(Collection<String> metricNames);

        /**
         * <p>
         * The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * </p>
         * 
         * @param metricNames
         *        The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamesWithStrings(String... metricNames);

        /**
         * <p>
         * The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * </p>
         * 
         * @param metricNames
         *        The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNames(Collection<Metric> metricNames);

        /**
         * <p>
         * The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * </p>
         * 
         * @param metricNames
         *        The names of the metrics to retrieve. Maximum of 10 metrics per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNames(Metric... metricNames);

        /**
         * <p>
         * The start time for the metric data query, in ISO 8601 format. The time range (end time - start time) must be
         * a multiple of the specified period.
         * </p>
         * 
         * @param startTime
         *        The start time for the metric data query, in ISO 8601 format. The time range (end time - start time)
         *        must be a multiple of the specified period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the metric data query, in ISO 8601 format. If the end time is beyond the latest ingested
         * data, it will be automatically adjusted to the latest available data point.
         * </p>
         * 
         * @param endTime
         *        The end time for the metric data query, in ISO 8601 format. If the end time is beyond the latest
         *        ingested data, it will be automatically adjusted to the latest available data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The granularity, in seconds, of the returned data points.
         * </p>
         * 
         * @param period
         *        The granularity, in seconds, of the returned data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The dimensions by which to group the metric data. This determines how the data is aggregated and returned.
         * </p>
         * 
         * @param groupBy
         *        The dimensions by which to group the metric data. This determines how the data is aggregated and
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(Collection<String> groupBy);

        /**
         * <p>
         * The dimensions by which to group the metric data. This determines how the data is aggregated and returned.
         * </p>
         * 
         * @param groupBy
         *        The dimensions by which to group the metric data. This determines how the data is aggregated and
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(String... groupBy);

        /**
         * <p>
         * The dimensions by which to group the metric data. This determines how the data is aggregated and returned.
         * </p>
         * 
         * @param groupBy
         *        The dimensions by which to group the metric data. This determines how the data is aggregated and
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<GroupBy> groupBy);

        /**
         * <p>
         * The dimensions by which to group the metric data. This determines how the data is aggregated and returned.
         * </p>
         * 
         * @param groupBy
         *        The dimensions by which to group the metric data. This determines how the data is aggregated and
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(GroupBy... groupBy);

        /**
         * <p>
         * Conditions to filter the metric data. Each filter specifies a dimension, comparison operator ('equals',
         * 'in'), and values to match against.
         * </p>
         * 
         * @param filterBy
         *        Conditions to filter the metric data. Each filter specifies a dimension, comparison operator
         *        ('equals', 'in'), and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBy(Collection<CapacityManagerCondition> filterBy);

        /**
         * <p>
         * Conditions to filter the metric data. Each filter specifies a dimension, comparison operator ('equals',
         * 'in'), and values to match against.
         * </p>
         * 
         * @param filterBy
         *        Conditions to filter the metric data. Each filter specifies a dimension, comparison operator
         *        ('equals', 'in'), and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBy(CapacityManagerCondition... filterBy);

        /**
         * <p>
         * Conditions to filter the metric data. Each filter specifies a dimension, comparison operator ('equals',
         * 'in'), and values to match against.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityManagerCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.CapacityManagerCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityManagerCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #filterBy(List<CapacityManagerCondition>)}.
         * 
         * @param filterBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityManagerCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterBy(java.util.Collection<CapacityManagerCondition>)
         */
        Builder filterBy(Consumer<CapacityManagerCondition.Builder>... filterBy);

        /**
         * <p>
         * The maximum number of data points to return. Valid range is 1 to 100,000. Use with NextToken for pagination
         * of large result sets.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of data points to return. Valid range is 1 to 100,000. Use with NextToken for
         *        pagination of large result sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results. Use this value in a subsequent call to retrieve additional data
         * points.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results. Use this value in a subsequent call to retrieve additional
         *        data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> metricNames = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private Integer period;

        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();

        private List<CapacityManagerCondition> filterBy = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityManagerMetricDataRequest model) {
            super(model);
            metricNamesWithStrings(model.metricNames);
            startTime(model.startTime);
            endTime(model.endTime);
            period(model.period);
            groupByWithStrings(model.groupBy);
            filterBy(model.filterBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            dryRun(model.dryRun);
        }

        public final Collection<String> getMetricNames() {
            if (metricNames instanceof SdkAutoConstructList) {
                return null;
            }
            return metricNames;
        }

        public final void setMetricNames(Collection<String> metricNames) {
            this.metricNames = MetricSetCopier.copy(metricNames);
        }

        @Override
        public final Builder metricNamesWithStrings(Collection<String> metricNames) {
            this.metricNames = MetricSetCopier.copy(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNamesWithStrings(String... metricNames) {
            metricNamesWithStrings(Arrays.asList(metricNames));
            return this;
        }

        @Override
        public final Builder metricNames(Collection<Metric> metricNames) {
            this.metricNames = MetricSetCopier.copyEnumToString(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNames(Metric... metricNames) {
            metricNames(Arrays.asList(metricNames));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = GroupBySetCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = GroupBySetCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String... groupBy) {
            groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<GroupBy> groupBy) {
            this.groupBy = GroupBySetCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupBy... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final List<CapacityManagerCondition.Builder> getFilterBy() {
            List<CapacityManagerCondition.Builder> result = CapacityManagerConditionSetCopier.copyToBuilder(this.filterBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterBy(Collection<CapacityManagerCondition.BuilderImpl> filterBy) {
            this.filterBy = CapacityManagerConditionSetCopier.copyFromBuilder(filterBy);
        }

        @Override
        public final Builder filterBy(Collection<CapacityManagerCondition> filterBy) {
            this.filterBy = CapacityManagerConditionSetCopier.copy(filterBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(CapacityManagerCondition... filterBy) {
            filterBy(Arrays.asList(filterBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(Consumer<CapacityManagerCondition.Builder>... filterBy) {
            filterBy(Stream.of(filterBy).map(c -> CapacityManagerCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCapacityManagerMetricDataRequest build() {
            return new GetCapacityManagerMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
