/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableInstanceSqlHaStandbyDetectionsRequest extends Ec2Request implements
        ToCopyableBuilder<EnableInstanceSqlHaStandbyDetectionsRequest.Builder, EnableInstanceSqlHaStandbyDetectionsRequest> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(EnableInstanceSqlHaStandbyDetectionsRequest::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SQL_SERVER_CREDENTIALS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SqlServerCredentials")
            .getter(getter(EnableInstanceSqlHaStandbyDetectionsRequest::sqlServerCredentials))
            .setter(setter(Builder::sqlServerCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlServerCredentials")
                    .unmarshallLocationName("SqlServerCredentials").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(EnableInstanceSqlHaStandbyDetectionsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD,
            SQL_SERVER_CREDENTIALS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> instanceIds;

    private final String sqlServerCredentials;

    private final Boolean dryRun;

    private EnableInstanceSqlHaStandbyDetectionsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.sqlServerCredentials = builder.sqlServerCredentials;
        this.dryRun = builder.dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the instances to enable for SQL Server High Availability standby detection monitoring.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return The IDs of the instances to enable for SQL Server High Availability standby detection monitoring.
     */
    public final List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret containing the SQL Server access credentials. The specified secret must
     * contain valid SQL Server credentials for the specified instances. If not specified, deafult local user
     * credentials will be used by the Amazon Web Services Systems Manager agent. To enable instances with different
     * credentials, you must make separate requests.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret containing the SQL Server access credentials. The specified secret
     *         must contain valid SQL Server credentials for the specified instances. If not specified, deafult local
     *         user credentials will be used by the Amazon Web Services Systems Manager agent. To enable instances with
     *         different credentials, you must make separate requests.
     */
    public final String sqlServerCredentials() {
        return sqlServerCredentials;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sqlServerCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableInstanceSqlHaStandbyDetectionsRequest)) {
            return false;
        }
        EnableInstanceSqlHaStandbyDetectionsRequest other = (EnableInstanceSqlHaStandbyDetectionsRequest) obj;
        return hasInstanceIds() == other.hasInstanceIds() && Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(sqlServerCredentials(), other.sqlServerCredentials())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableInstanceSqlHaStandbyDetectionsRequest")
                .add("InstanceIds", hasInstanceIds() ? instanceIds() : null).add("SqlServerCredentials", sqlServerCredentials())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "SqlServerCredentials":
            return Optional.ofNullable(clazz.cast(sqlServerCredentials()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_IDS_FIELD);
        map.put("SqlServerCredentials", SQL_SERVER_CREDENTIALS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableInstanceSqlHaStandbyDetectionsRequest, T> g) {
        return obj -> g.apply((EnableInstanceSqlHaStandbyDetectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableInstanceSqlHaStandbyDetectionsRequest> {
        /**
         * <p>
         * The IDs of the instances to enable for SQL Server High Availability standby detection monitoring.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances to enable for SQL Server High Availability standby detection monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the instances to enable for SQL Server High Availability standby detection monitoring.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances to enable for SQL Server High Availability standby detection monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The ARN of the Secrets Manager secret containing the SQL Server access credentials. The specified secret must
         * contain valid SQL Server credentials for the specified instances. If not specified, deafult local user
         * credentials will be used by the Amazon Web Services Systems Manager agent. To enable instances with different
         * credentials, you must make separate requests.
         * </p>
         * 
         * @param sqlServerCredentials
         *        The ARN of the Secrets Manager secret containing the SQL Server access credentials. The specified
         *        secret must contain valid SQL Server credentials for the specified instances. If not specified,
         *        deafult local user credentials will be used by the Amazon Web Services Systems Manager agent. To
         *        enable instances with different credentials, you must make separate requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlServerCredentials(String sqlServerCredentials);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private String sqlServerCredentials;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableInstanceSqlHaStandbyDetectionsRequest model) {
            super(model);
            instanceIds(model.instanceIds);
            sqlServerCredentials(model.sqlServerCredentials);
            dryRun(model.dryRun);
        }

        public final Collection<String> getInstanceIds() {
            if (instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdUpdateStringListCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdUpdateStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final String getSqlServerCredentials() {
            return sqlServerCredentials;
        }

        public final void setSqlServerCredentials(String sqlServerCredentials) {
            this.sqlServerCredentials = sqlServerCredentials;
        }

        @Override
        public final Builder sqlServerCredentials(String sqlServerCredentials) {
            this.sqlServerCredentials = sqlServerCredentials;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableInstanceSqlHaStandbyDetectionsRequest build() {
            return new EnableInstanceSqlHaStandbyDetectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
