/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMacModificationTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeMacModificationTasksResponse.Builder, DescribeMacModificationTasksResponse> {
    private static final SdkField<List<MacModificationTask>> MAC_MODIFICATION_TASKS_FIELD = SdkField
            .<List<MacModificationTask>> builder(MarshallingType.LIST)
            .memberName("MacModificationTasks")
            .getter(getter(DescribeMacModificationTasksResponse::macModificationTasks))
            .setter(setter(Builder::macModificationTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacModificationTaskSet")
                    .unmarshallLocationName("macModificationTaskSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<MacModificationTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(MacModificationTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeMacModificationTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAC_MODIFICATION_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MacModificationTask> macModificationTasks;

    private final String nextToken;

    private DescribeMacModificationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.macModificationTasks = builder.macModificationTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MacModificationTasks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMacModificationTasks() {
        return macModificationTasks != null && !(macModificationTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMacModificationTasks} method.
     * </p>
     * 
     * @return Information about the tasks.
     */
    public final List<MacModificationTask> macModificationTasks() {
        return macModificationTasks;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMacModificationTasks() ? macModificationTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMacModificationTasksResponse)) {
            return false;
        }
        DescribeMacModificationTasksResponse other = (DescribeMacModificationTasksResponse) obj;
        return hasMacModificationTasks() == other.hasMacModificationTasks()
                && Objects.equals(macModificationTasks(), other.macModificationTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMacModificationTasksResponse")
                .add("MacModificationTasks", hasMacModificationTasks() ? macModificationTasks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MacModificationTasks":
            return Optional.ofNullable(clazz.cast(macModificationTasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MacModificationTaskSet", MAC_MODIFICATION_TASKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMacModificationTasksResponse, T> g) {
        return obj -> g.apply((DescribeMacModificationTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMacModificationTasksResponse> {
        /**
         * <p>
         * Information about the tasks.
         * </p>
         * 
         * @param macModificationTasks
         *        Information about the tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macModificationTasks(Collection<MacModificationTask> macModificationTasks);

        /**
         * <p>
         * Information about the tasks.
         * </p>
         * 
         * @param macModificationTasks
         *        Information about the tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macModificationTasks(MacModificationTask... macModificationTasks);

        /**
         * <p>
         * Information about the tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.MacModificationTask.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.MacModificationTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.MacModificationTask.Builder#build()} is called immediately
         * and its result is passed to {@link #macModificationTasks(List<MacModificationTask>)}.
         * 
         * @param macModificationTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.MacModificationTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #macModificationTasks(java.util.Collection<MacModificationTask>)
         */
        Builder macModificationTasks(Consumer<MacModificationTask.Builder>... macModificationTasks);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<MacModificationTask> macModificationTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMacModificationTasksResponse model) {
            super(model);
            macModificationTasks(model.macModificationTasks);
            nextToken(model.nextToken);
        }

        public final List<MacModificationTask.Builder> getMacModificationTasks() {
            List<MacModificationTask.Builder> result = MacModificationTaskListCopier.copyToBuilder(this.macModificationTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMacModificationTasks(Collection<MacModificationTask.BuilderImpl> macModificationTasks) {
            this.macModificationTasks = MacModificationTaskListCopier.copyFromBuilder(macModificationTasks);
        }

        @Override
        public final Builder macModificationTasks(Collection<MacModificationTask> macModificationTasks) {
            this.macModificationTasks = MacModificationTaskListCopier.copy(macModificationTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macModificationTasks(MacModificationTask... macModificationTasks) {
            macModificationTasks(Arrays.asList(macModificationTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macModificationTasks(Consumer<MacModificationTask.Builder>... macModificationTasks) {
            macModificationTasks(Stream.of(macModificationTasks).map(c -> MacModificationTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMacModificationTasksResponse build() {
            return new DescribeMacModificationTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
