/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateRouteServerResponse extends Ec2Response implements
        ToCopyableBuilder<AssociateRouteServerResponse.Builder, AssociateRouteServerResponse> {
    private static final SdkField<RouteServerAssociation> ROUTE_SERVER_ASSOCIATION_FIELD = SdkField
            .<RouteServerAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("RouteServerAssociation")
            .getter(getter(AssociateRouteServerResponse::routeServerAssociation))
            .setter(setter(Builder::routeServerAssociation))
            .constructor(RouteServerAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerAssociation")
                    .unmarshallLocationName("routeServerAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROUTE_SERVER_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouteServerAssociation routeServerAssociation;

    private AssociateRouteServerResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerAssociation = builder.routeServerAssociation;
    }

    /**
     * <p>
     * Information about the association between the route server and the VPC.
     * </p>
     * 
     * @return Information about the association between the route server and the VPC.
     */
    public final RouteServerAssociation routeServerAssociation() {
        return routeServerAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeServerAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRouteServerResponse)) {
            return false;
        }
        AssociateRouteServerResponse other = (AssociateRouteServerResponse) obj;
        return Objects.equals(routeServerAssociation(), other.routeServerAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateRouteServerResponse").add("RouteServerAssociation", routeServerAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerAssociation":
            return Optional.ofNullable(clazz.cast(routeServerAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerAssociation", ROUTE_SERVER_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateRouteServerResponse, T> g) {
        return obj -> g.apply((AssociateRouteServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AssociateRouteServerResponse> {
        /**
         * <p>
         * Information about the association between the route server and the VPC.
         * </p>
         * 
         * @param routeServerAssociation
         *        Information about the association between the route server and the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerAssociation(RouteServerAssociation routeServerAssociation);

        /**
         * <p>
         * Information about the association between the route server and the VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteServerAssociation.Builder} avoiding
         * the need to create one manually via {@link RouteServerAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteServerAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #routeServerAssociation(RouteServerAssociation)}.
         * 
         * @param routeServerAssociation
         *        a consumer that will call methods on {@link RouteServerAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServerAssociation(RouteServerAssociation)
         */
        default Builder routeServerAssociation(Consumer<RouteServerAssociation.Builder> routeServerAssociation) {
            return routeServerAssociation(RouteServerAssociation.builder().applyMutation(routeServerAssociation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private RouteServerAssociation routeServerAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRouteServerResponse model) {
            super(model);
            routeServerAssociation(model.routeServerAssociation);
        }

        public final RouteServerAssociation.Builder getRouteServerAssociation() {
            return routeServerAssociation != null ? routeServerAssociation.toBuilder() : null;
        }

        public final void setRouteServerAssociation(RouteServerAssociation.BuilderImpl routeServerAssociation) {
            this.routeServerAssociation = routeServerAssociation != null ? routeServerAssociation.build() : null;
        }

        @Override
        public final Builder routeServerAssociation(RouteServerAssociation routeServerAssociation) {
            this.routeServerAssociation = routeServerAssociation;
            return this;
        }

        @Override
        public AssociateRouteServerResponse build() {
            return new AssociateRouteServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
