/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InterruptibleCapacityReservationAllocationStatus;
import software.amazon.awssdk.services.ec2.model.InterruptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InterruptibleCapacityAllocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InterruptibleCapacityAllocation> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(InterruptibleCapacityAllocation.getter(InterruptibleCapacityAllocation::instanceCount)).setter(InterruptibleCapacityAllocation.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<Integer> TARGET_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetInstanceCount").getter(InterruptibleCapacityAllocation.getter(InterruptibleCapacityAllocation::targetInstanceCount)).setter(InterruptibleCapacityAllocation.setter(Builder::targetInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetInstanceCount").unmarshallLocationName("targetInstanceCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InterruptibleCapacityAllocation.getter(InterruptibleCapacityAllocation::statusAsString)).setter(InterruptibleCapacityAllocation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> INTERRUPTIBLE_CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterruptibleCapacityReservationId").getter(InterruptibleCapacityAllocation.getter(InterruptibleCapacityAllocation::interruptibleCapacityReservationId)).setter(InterruptibleCapacityAllocation.setter(Builder::interruptibleCapacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptibleCapacityReservationId").unmarshallLocationName("interruptibleCapacityReservationId").build()}).build();
    private static final SdkField<String> INTERRUPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterruptionType").getter(InterruptibleCapacityAllocation.getter(InterruptibleCapacityAllocation::interruptionTypeAsString)).setter(InterruptibleCapacityAllocation.setter(Builder::interruptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionType").unmarshallLocationName("interruptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, TARGET_INSTANCE_COUNT_FIELD, STATUS_FIELD, INTERRUPTIBLE_CAPACITY_RESERVATION_ID_FIELD, INTERRUPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InterruptibleCapacityAllocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final Integer targetInstanceCount;
    private final String status;
    private final String interruptibleCapacityReservationId;
    private final String interruptionType;

    private InterruptibleCapacityAllocation(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.targetInstanceCount = builder.targetInstanceCount;
        this.status = builder.status;
        this.interruptibleCapacityReservationId = builder.interruptibleCapacityReservationId;
        this.interruptionType = builder.interruptionType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Integer targetInstanceCount() {
        return this.targetInstanceCount;
    }

    public final InterruptibleCapacityReservationAllocationStatus status() {
        return InterruptibleCapacityReservationAllocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String interruptibleCapacityReservationId() {
        return this.interruptibleCapacityReservationId;
    }

    public final InterruptionType interruptionType() {
        return InterruptionType.fromValue(this.interruptionType);
    }

    public final String interruptionTypeAsString() {
        return this.interruptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.interruptibleCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interruptionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterruptibleCapacityAllocation)) {
            return false;
        }
        InterruptibleCapacityAllocation other = (InterruptibleCapacityAllocation)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.targetInstanceCount(), other.targetInstanceCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.interruptibleCapacityReservationId(), other.interruptibleCapacityReservationId()) && Objects.equals(this.interruptionTypeAsString(), other.interruptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InterruptibleCapacityAllocation").add("InstanceCount", (Object)this.instanceCount()).add("TargetInstanceCount", (Object)this.targetInstanceCount()).add("Status", (Object)this.statusAsString()).add("InterruptibleCapacityReservationId", (Object)this.interruptibleCapacityReservationId()).add("InterruptionType", (Object)this.interruptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "TargetInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "InterruptibleCapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.interruptibleCapacityReservationId()));
            }
            case "InterruptionType": {
                return Optional.ofNullable(clazz.cast(this.interruptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("TargetInstanceCount", TARGET_INSTANCE_COUNT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("InterruptibleCapacityReservationId", INTERRUPTIBLE_CAPACITY_RESERVATION_ID_FIELD);
        map.put("InterruptionType", INTERRUPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InterruptibleCapacityAllocation, T> g) {
        return obj -> g.apply((InterruptibleCapacityAllocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private Integer targetInstanceCount;
        private String status;
        private String interruptibleCapacityReservationId;
        private String interruptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(InterruptibleCapacityAllocation model) {
            this.instanceCount(model.instanceCount);
            this.targetInstanceCount(model.targetInstanceCount);
            this.status(model.status);
            this.interruptibleCapacityReservationId(model.interruptibleCapacityReservationId);
            this.interruptionType(model.interruptionType);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getTargetInstanceCount() {
            return this.targetInstanceCount;
        }

        public final void setTargetInstanceCount(Integer targetInstanceCount) {
            this.targetInstanceCount = targetInstanceCount;
        }

        @Override
        public final Builder targetInstanceCount(Integer targetInstanceCount) {
            this.targetInstanceCount = targetInstanceCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InterruptibleCapacityReservationAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getInterruptibleCapacityReservationId() {
            return this.interruptibleCapacityReservationId;
        }

        public final void setInterruptibleCapacityReservationId(String interruptibleCapacityReservationId) {
            this.interruptibleCapacityReservationId = interruptibleCapacityReservationId;
        }

        @Override
        public final Builder interruptibleCapacityReservationId(String interruptibleCapacityReservationId) {
            this.interruptibleCapacityReservationId = interruptibleCapacityReservationId;
            return this;
        }

        public final String getInterruptionType() {
            return this.interruptionType;
        }

        public final void setInterruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
        }

        @Override
        public final Builder interruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
            return this;
        }

        @Override
        public final Builder interruptionType(InterruptionType interruptionType) {
            this.interruptionType(interruptionType == null ? null : interruptionType.toString());
            return this;
        }

        public InterruptibleCapacityAllocation build() {
            return new InterruptibleCapacityAllocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InterruptibleCapacityAllocation> {
        public Builder instanceCount(Integer var1);

        public Builder targetInstanceCount(Integer var1);

        public Builder status(String var1);

        public Builder status(InterruptibleCapacityReservationAllocationStatus var1);

        public Builder interruptibleCapacityReservationId(String var1);

        public Builder interruptionType(String var1);

        public Builder interruptionType(InterruptionType var1);
    }
}

