/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a subnet and an IPv6 CIDR block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetIpv6CidrBlockAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<SubnetIpv6CidrBlockAssociation.Builder, SubnetIpv6CidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationId")
            .getter(getter(SubnetIpv6CidrBlockAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock")
            .getter(getter(SubnetIpv6CidrBlockAssociation::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("ipv6CidrBlock").build()).build();

    private static final SdkField<SubnetCidrBlockState> IPV6_CIDR_BLOCK_STATE_FIELD = SdkField
            .<SubnetCidrBlockState> builder(MarshallingType.SDK_POJO)
            .memberName("Ipv6CidrBlockState")
            .getter(getter(SubnetIpv6CidrBlockAssociation::ipv6CidrBlockState))
            .setter(setter(Builder::ipv6CidrBlockState))
            .constructor(SubnetCidrBlockState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockState")
                    .unmarshallLocationName("ipv6CidrBlockState").build()).build();

    private static final SdkField<String> IPV6_ADDRESS_ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6AddressAttribute")
            .getter(getter(SubnetIpv6CidrBlockAssociation::ipv6AddressAttributeAsString))
            .setter(setter(Builder::ipv6AddressAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressAttribute")
                    .unmarshallLocationName("ipv6AddressAttribute").build()).build();

    private static final SdkField<String> IP_SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpSource")
            .getter(getter(SubnetIpv6CidrBlockAssociation::ipSourceAsString))
            .setter(setter(Builder::ipSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpSource")
                    .unmarshallLocationName("ipSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            IPV6_CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_STATE_FIELD, IPV6_ADDRESS_ATTRIBUTE_FIELD, IP_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String ipv6CidrBlock;

    private final SubnetCidrBlockState ipv6CidrBlockState;

    private final String ipv6AddressAttribute;

    private final String ipSource;

    private SubnetIpv6CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv6CidrBlockState = builder.ipv6CidrBlockState;
        this.ipv6AddressAttribute = builder.ipv6AddressAttribute;
        this.ipSource = builder.ipSource;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @return The IPv6 CIDR block.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * The state of the CIDR block.
     * </p>
     * 
     * @return The state of the CIDR block.
     */
    public final SubnetCidrBlockState ipv6CidrBlockState() {
        return ipv6CidrBlockState;
    }

    /**
     * <p>
     * Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP addresses are not
     * and cannot be advertised on the internet from Amazon Web Services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ipv6AddressAttribute} will return {@link Ipv6AddressAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ipv6AddressAttributeAsString}.
     * </p>
     * 
     * @return Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP addresses
     *         are not and cannot be advertised on the internet from Amazon Web Services.
     * @see Ipv6AddressAttribute
     */
    public final Ipv6AddressAttribute ipv6AddressAttribute() {
        return Ipv6AddressAttribute.fromValue(ipv6AddressAttribute);
    }

    /**
     * <p>
     * Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP addresses are not
     * and cannot be advertised on the internet from Amazon Web Services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ipv6AddressAttribute} will return {@link Ipv6AddressAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ipv6AddressAttributeAsString}.
     * </p>
     * 
     * @return Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP addresses
     *         are not and cannot be advertised on the internet from Amazon Web Services.
     * @see Ipv6AddressAttribute
     */
    public final String ipv6AddressAttributeAsString() {
        return ipv6AddressAttribute;
    }

    /**
     * <p>
     * The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates public IP
     * address space allocated by Amazon or space that you have allocated with Bring your own IP (BYOIP).
     * <code>none</code> indicates private space.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipSource} will
     * return {@link IpSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipSourceAsString}.
     * </p>
     * 
     * @return The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates
     *         public IP address space allocated by Amazon or space that you have allocated with Bring your own IP
     *         (BYOIP). <code>none</code> indicates private space.
     * @see IpSource
     */
    public final IpSource ipSource() {
        return IpSource.fromValue(ipSource);
    }

    /**
     * <p>
     * The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates public IP
     * address space allocated by Amazon or space that you have allocated with Bring your own IP (BYOIP).
     * <code>none</code> indicates private space.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipSource} will
     * return {@link IpSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipSourceAsString}.
     * </p>
     * 
     * @return The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates
     *         public IP address space allocated by Amazon or space that you have allocated with Bring your own IP
     *         (BYOIP). <code>none</code> indicates private space.
     * @see IpSource
     */
    public final String ipSourceAsString() {
        return ipSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockState());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipSourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetIpv6CidrBlockAssociation)) {
            return false;
        }
        SubnetIpv6CidrBlockAssociation other = (SubnetIpv6CidrBlockAssociation) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(ipv6CidrBlockState(), other.ipv6CidrBlockState())
                && Objects.equals(ipv6AddressAttributeAsString(), other.ipv6AddressAttributeAsString())
                && Objects.equals(ipSourceAsString(), other.ipSourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubnetIpv6CidrBlockAssociation").add("AssociationId", associationId())
                .add("Ipv6CidrBlock", ipv6CidrBlock()).add("Ipv6CidrBlockState", ipv6CidrBlockState())
                .add("Ipv6AddressAttribute", ipv6AddressAttributeAsString()).add("IpSource", ipSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "Ipv6CidrBlockState":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockState()));
        case "Ipv6AddressAttribute":
            return Optional.ofNullable(clazz.cast(ipv6AddressAttributeAsString()));
        case "IpSource":
            return Optional.ofNullable(clazz.cast(ipSourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
        map.put("Ipv6CidrBlockState", IPV6_CIDR_BLOCK_STATE_FIELD);
        map.put("Ipv6AddressAttribute", IPV6_ADDRESS_ATTRIBUTE_FIELD);
        map.put("IpSource", IP_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubnetIpv6CidrBlockAssociation, T> g) {
        return obj -> g.apply((SubnetIpv6CidrBlockAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetIpv6CidrBlockAssociation> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param associationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The IPv6 CIDR block.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * The state of the CIDR block.
         * </p>
         * 
         * @param ipv6CidrBlockState
         *        The state of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState);

        /**
         * <p>
         * The state of the CIDR block.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubnetCidrBlockState.Builder} avoiding
         * the need to create one manually via {@link SubnetCidrBlockState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubnetCidrBlockState.Builder#build()} is called immediately and
         * its result is passed to {@link #ipv6CidrBlockState(SubnetCidrBlockState)}.
         * 
         * @param ipv6CidrBlockState
         *        a consumer that will call methods on {@link SubnetCidrBlockState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockState(SubnetCidrBlockState)
         */
        default Builder ipv6CidrBlockState(Consumer<SubnetCidrBlockState.Builder> ipv6CidrBlockState) {
            return ipv6CidrBlockState(SubnetCidrBlockState.builder().applyMutation(ipv6CidrBlockState).build());
        }

        /**
         * <p>
         * Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP addresses are
         * not and cannot be advertised on the internet from Amazon Web Services.
         * </p>
         * 
         * @param ipv6AddressAttribute
         *        Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP
         *        addresses are not and cannot be advertised on the internet from Amazon Web Services.
         * @see Ipv6AddressAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ipv6AddressAttribute
         */
        Builder ipv6AddressAttribute(String ipv6AddressAttribute);

        /**
         * <p>
         * Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP addresses are
         * not and cannot be advertised on the internet from Amazon Web Services.
         * </p>
         * 
         * @param ipv6AddressAttribute
         *        Public IPv6 addresses are those advertised on the internet from Amazon Web Services. Private IP
         *        addresses are not and cannot be advertised on the internet from Amazon Web Services.
         * @see Ipv6AddressAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ipv6AddressAttribute
         */
        Builder ipv6AddressAttribute(Ipv6AddressAttribute ipv6AddressAttribute);

        /**
         * <p>
         * The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates public IP
         * address space allocated by Amazon or space that you have allocated with Bring your own IP (BYOIP).
         * <code>none</code> indicates private space.
         * </p>
         * 
         * @param ipSource
         *        The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates
         *        public IP address space allocated by Amazon or space that you have allocated with Bring your own IP
         *        (BYOIP). <code>none</code> indicates private space.
         * @see IpSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSource
         */
        Builder ipSource(String ipSource);

        /**
         * <p>
         * The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates public IP
         * address space allocated by Amazon or space that you have allocated with Bring your own IP (BYOIP).
         * <code>none</code> indicates private space.
         * </p>
         * 
         * @param ipSource
         *        The source that allocated the IP address space. <code>byoip</code> or <code>amazon</code> indicates
         *        public IP address space allocated by Amazon or space that you have allocated with Bring your own IP
         *        (BYOIP). <code>none</code> indicates private space.
         * @see IpSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSource
         */
        Builder ipSource(IpSource ipSource);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String ipv6CidrBlock;

        private SubnetCidrBlockState ipv6CidrBlockState;

        private String ipv6AddressAttribute;

        private String ipSource;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetIpv6CidrBlockAssociation model) {
            associationId(model.associationId);
            ipv6CidrBlock(model.ipv6CidrBlock);
            ipv6CidrBlockState(model.ipv6CidrBlockState);
            ipv6AddressAttribute(model.ipv6AddressAttribute);
            ipSource(model.ipSource);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final SubnetCidrBlockState.Builder getIpv6CidrBlockState() {
            return ipv6CidrBlockState != null ? ipv6CidrBlockState.toBuilder() : null;
        }

        public final void setIpv6CidrBlockState(SubnetCidrBlockState.BuilderImpl ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState != null ? ipv6CidrBlockState.build() : null;
        }

        @Override
        public final Builder ipv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState;
            return this;
        }

        public final String getIpv6AddressAttribute() {
            return ipv6AddressAttribute;
        }

        public final void setIpv6AddressAttribute(String ipv6AddressAttribute) {
            this.ipv6AddressAttribute = ipv6AddressAttribute;
        }

        @Override
        public final Builder ipv6AddressAttribute(String ipv6AddressAttribute) {
            this.ipv6AddressAttribute = ipv6AddressAttribute;
            return this;
        }

        @Override
        public final Builder ipv6AddressAttribute(Ipv6AddressAttribute ipv6AddressAttribute) {
            this.ipv6AddressAttribute(ipv6AddressAttribute == null ? null : ipv6AddressAttribute.toString());
            return this;
        }

        public final String getIpSource() {
            return ipSource;
        }

        public final void setIpSource(String ipSource) {
            this.ipSource = ipSource;
        }

        @Override
        public final Builder ipSource(String ipSource) {
            this.ipSource = ipSource;
            return this;
        }

        @Override
        public final Builder ipSource(IpSource ipSource) {
            this.ipSource(ipSource == null ? null : ipSource.toString());
            return this;
        }

        @Override
        public SubnetIpv6CidrBlockAssociation build() {
            return new SubnetIpv6CidrBlockAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
