/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Image implements SdkPojo, Serializable, ToCopyableBuilder<Image.Builder, Image> {
    private static final SdkField<String> PLATFORM_DETAILS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PlatformDetails")
            .getter(getter(Image::platformDetails))
            .setter(setter(Builder::platformDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDetails")
                    .unmarshallLocationName("platformDetails").build()).build();

    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UsageOperation")
            .getter(getter(Image::usageOperation))
            .setter(setter(Builder::usageOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation")
                    .unmarshallLocationName("usageOperation").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(Image::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(Image::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnaSupport")
            .getter(getter(Image::enaSupport))
            .setter(setter(Builder::enaSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<String> HYPERVISOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Hypervisor")
            .getter(getter(Image::hypervisorAsString))
            .setter(setter(Builder::hypervisor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor")
                    .unmarshallLocationName("hypervisor").build()).build();

    private static final SdkField<String> IMAGE_OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageOwnerAlias")
            .getter(getter(Image::imageOwnerAlias))
            .setter(setter(Builder::imageOwnerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerAlias")
                    .unmarshallLocationName("imageOwnerAlias").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(Image::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceName")
            .getter(getter(Image::rootDeviceName))
            .setter(setter(Builder::rootDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName")
                    .unmarshallLocationName("rootDeviceName").build()).build();

    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceType")
            .getter(getter(Image::rootDeviceTypeAsString))
            .setter(setter(Builder::rootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType")
                    .unmarshallLocationName("rootDeviceType").build()).build();

    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SriovNetSupport")
            .getter(getter(Image::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<StateReason> STATE_REASON_FIELD = SdkField
            .<StateReason> builder(MarshallingType.SDK_POJO)
            .memberName("StateReason")
            .getter(getter(Image::stateReason))
            .setter(setter(Builder::stateReason))
            .constructor(StateReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Image::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VirtualizationType")
            .getter(getter(Image::virtualizationTypeAsString))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType")
                    .unmarshallLocationName("virtualizationType").build()).build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootMode")
            .getter(getter(Image::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode")
                    .unmarshallLocationName("bootMode").build()).build();

    private static final SdkField<String> TPM_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TpmSupport")
            .getter(getter(Image::tpmSupportAsString))
            .setter(setter(Builder::tpmSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport")
                    .unmarshallLocationName("tpmSupport").build()).build();

    private static final SdkField<String> DEPRECATION_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeprecationTime")
            .getter(getter(Image::deprecationTime))
            .setter(setter(Builder::deprecationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationTime")
                    .unmarshallLocationName("deprecationTime").build()).build();

    private static final SdkField<String> IMDS_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImdsSupport")
            .getter(getter(Image::imdsSupportAsString))
            .setter(setter(Builder::imdsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImdsSupport")
                    .unmarshallLocationName("imdsSupport").build()).build();

    private static final SdkField<String> SOURCE_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceInstanceId")
            .getter(getter(Image::sourceInstanceId))
            .setter(setter(Builder::sourceInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceInstanceId")
                    .unmarshallLocationName("sourceInstanceId").build()).build();

    private static final SdkField<String> DEREGISTRATION_PROTECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeregistrationProtection")
            .getter(getter(Image::deregistrationProtection))
            .setter(setter(Builder::deregistrationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeregistrationProtection")
                    .unmarshallLocationName("deregistrationProtection").build()).build();

    private static final SdkField<String> LAST_LAUNCHED_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastLaunchedTime")
            .getter(getter(Image::lastLaunchedTime))
            .setter(setter(Builder::lastLaunchedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastLaunchedTime")
                    .unmarshallLocationName("lastLaunchedTime").build()).build();

    private static final SdkField<Boolean> IMAGE_ALLOWED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ImageAllowed")
            .getter(getter(Image::imageAllowed))
            .setter(setter(Builder::imageAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageAllowed")
                    .unmarshallLocationName("imageAllowed").build()).build();

    private static final SdkField<String> SOURCE_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceImageId")
            .getter(getter(Image::sourceImageId))
            .setter(setter(Builder::sourceImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageId")
                    .unmarshallLocationName("sourceImageId").build()).build();

    private static final SdkField<String> SOURCE_IMAGE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceImageRegion")
            .getter(getter(Image::sourceImageRegion))
            .setter(setter(Builder::sourceImageRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageRegion")
                    .unmarshallLocationName("sourceImageRegion").build()).build();

    private static final SdkField<Boolean> FREE_TIER_ELIGIBLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FreeTierEligible")
            .getter(getter(Image::freeTierEligible))
            .setter(setter(Builder::freeTierEligible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeTierEligible")
                    .unmarshallLocationName("freeTierEligible").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(Image::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> IMAGE_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageLocation")
            .getter(getter(Image::imageLocation))
            .setter(setter(Builder::imageLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageLocation")
                    .unmarshallLocationName("imageLocation").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(Image::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageState")
                    .unmarshallLocationName("imageState").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(Image::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerId")
                    .unmarshallLocationName("imageOwnerId").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreationDate")
            .getter(getter(Image::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate")
                    .unmarshallLocationName("creationDate").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(Image::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Architecture")
            .getter(getter(Image::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture")
                    .unmarshallLocationName("architecture").build()).build();

    private static final SdkField<String> IMAGE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageType")
            .getter(getter(Image::imageTypeAsString))
            .setter(setter(Builder::imageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageType")
                    .unmarshallLocationName("imageType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(Image::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId")
            .getter(getter(Image::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("ramdiskId").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(Image::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<Boolean> PUBLIC_LAUNCH_PERMISSIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PublicLaunchPermissions")
            .getter(getter(Image::publicLaunchPermissions))
            .setter(setter(Builder::publicLaunchPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPublic")
                    .unmarshallLocationName("isPublic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_DETAILS_FIELD,
            USAGE_OPERATION_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DESCRIPTION_FIELD, ENA_SUPPORT_FIELD, HYPERVISOR_FIELD,
            IMAGE_OWNER_ALIAS_FIELD, NAME_FIELD, ROOT_DEVICE_NAME_FIELD, ROOT_DEVICE_TYPE_FIELD, SRIOV_NET_SUPPORT_FIELD,
            STATE_REASON_FIELD, TAGS_FIELD, VIRTUALIZATION_TYPE_FIELD, BOOT_MODE_FIELD, TPM_SUPPORT_FIELD,
            DEPRECATION_TIME_FIELD, IMDS_SUPPORT_FIELD, SOURCE_INSTANCE_ID_FIELD, DEREGISTRATION_PROTECTION_FIELD,
            LAST_LAUNCHED_TIME_FIELD, IMAGE_ALLOWED_FIELD, SOURCE_IMAGE_ID_FIELD, SOURCE_IMAGE_REGION_FIELD,
            FREE_TIER_ELIGIBLE_FIELD, IMAGE_ID_FIELD, IMAGE_LOCATION_FIELD, STATE_FIELD, OWNER_ID_FIELD, CREATION_DATE_FIELD,
            PRODUCT_CODES_FIELD, ARCHITECTURE_FIELD, IMAGE_TYPE_FIELD, KERNEL_ID_FIELD, RAMDISK_ID_FIELD, PLATFORM_FIELD,
            PUBLIC_LAUNCH_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String platformDetails;

    private final String usageOperation;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final Boolean enaSupport;

    private final String hypervisor;

    private final String imageOwnerAlias;

    private final String name;

    private final String rootDeviceName;

    private final String rootDeviceType;

    private final String sriovNetSupport;

    private final StateReason stateReason;

    private final List<Tag> tags;

    private final String virtualizationType;

    private final String bootMode;

    private final String tpmSupport;

    private final String deprecationTime;

    private final String imdsSupport;

    private final String sourceInstanceId;

    private final String deregistrationProtection;

    private final String lastLaunchedTime;

    private final Boolean imageAllowed;

    private final String sourceImageId;

    private final String sourceImageRegion;

    private final Boolean freeTierEligible;

    private final String imageId;

    private final String imageLocation;

    private final String state;

    private final String ownerId;

    private final String creationDate;

    private final List<ProductCode> productCodes;

    private final String architecture;

    private final String imageType;

    private final String kernelId;

    private final String ramdiskId;

    private final String platform;

    private final Boolean publicLaunchPermissions;

    private Image(BuilderImpl builder) {
        this.platformDetails = builder.platformDetails;
        this.usageOperation = builder.usageOperation;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.name = builder.name;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.bootMode = builder.bootMode;
        this.tpmSupport = builder.tpmSupport;
        this.deprecationTime = builder.deprecationTime;
        this.imdsSupport = builder.imdsSupport;
        this.sourceInstanceId = builder.sourceInstanceId;
        this.deregistrationProtection = builder.deregistrationProtection;
        this.lastLaunchedTime = builder.lastLaunchedTime;
        this.imageAllowed = builder.imageAllowed;
        this.sourceImageId = builder.sourceImageId;
        this.sourceImageRegion = builder.sourceImageRegion;
        this.freeTierEligible = builder.freeTierEligible;
        this.imageId = builder.imageId;
        this.imageLocation = builder.imageLocation;
        this.state = builder.state;
        this.ownerId = builder.ownerId;
        this.creationDate = builder.creationDate;
        this.productCodes = builder.productCodes;
        this.architecture = builder.architecture;
        this.imageType = builder.imageType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.platform = builder.platform;
        this.publicLaunchPermissions = builder.publicLaunchPermissions;
    }

    /**
     * <p>
     * The platform details associated with the billing code of the AMI. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understand AMI billing
     * information</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The platform details associated with the billing code of the AMI. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understand AMI billing
     *         information</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String platformDetails() {
        return platformDetails;
    }

    /**
     * <p>
     * The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
     * <code>usageOperation</code> corresponds to the <a
     * href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation"
     * >lineitem/Operation</a> column on your Amazon Web Services Cost and Usage Report and in the <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web Services Price
     * List API</a>. You can view these fields on the <b>Instances</b> or <b>AMIs</b> pages in the Amazon EC2 console,
     * or in the responses that are returned by the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages</a> command
     * in the Amazon EC2 API, or the <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images</a> command in
     * the CLI.
     * </p>
     * 
     * @return The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
     *         <code>usageOperation</code> corresponds to the <a
     *         href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation"
     *         >lineitem/Operation</a> column on your Amazon Web Services Cost and Usage Report and in the <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web
     *         Services Price List API</a>. You can view these fields on the <b>Instances</b> or <b>AMIs</b> pages in
     *         the Amazon EC2 console, or in the responses that are returned by the <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages</a>
     *         command in the Amazon EC2 API, or the <a
     *         href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images</a>
     *         command in the CLI.
     */
    public final String usageOperation() {
        return usageOperation;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return Any block device mapping entries.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The description of the AMI that was provided during image creation.
     * </p>
     * 
     * @return The description of the AMI that was provided during image creation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with ENA is enabled.
     */
    public final Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not supported.
     * @see HypervisorType
     */
    public final HypervisorType hypervisor() {
        return HypervisorType.fromValue(hypervisor);
    }

    /**
     * <p>
     * The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not supported.
     * @see HypervisorType
     */
    public final String hypervisorAsString() {
        return hypervisor;
    }

    /**
     * <p>
     * The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>).
     * </p>
     * 
     * @return The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>).
     */
    public final String imageOwnerAlias() {
        return imageOwnerAlias;
    }

    /**
     * <p>
     * The name of the AMI that was provided during image creation.
     * </p>
     * 
     * @return The name of the AMI that was provided during image creation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public final String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store
     *         volume.
     * @see DeviceType
     */
    public final DeviceType rootDeviceType() {
        return DeviceType.fromValue(rootDeviceType);
    }

    /**
     * <p>
     * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store
     *         volume.
     * @see DeviceType
     */
    public final String rootDeviceTypeAsString() {
        return rootDeviceType;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public final String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The reason for the state change.
     * </p>
     * 
     * @return The reason for the state change.
     */
    public final StateReason stateReason() {
        return stateReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the image.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of virtualization of the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The type of virtualization of the AMI.
     * @see VirtualizationType
     */
    public final VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(virtualizationType);
    }

    /**
     * <p>
     * The type of virtualization of the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The type of virtualization of the AMI.
     * @see VirtualizationType
     */
    public final String virtualizationTypeAsString() {
        return virtualizationType;
    }

    /**
     * <p>
     * The boot mode of the image. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with Amazon EC2
     * boot modes</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the image. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with
     *         Amazon EC2 boot modes</a> in the <i>Amazon EC2 User Guide</i>.
     * @see BootModeValues
     */
    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(bootMode);
    }

    /**
     * <p>
     * The boot mode of the image. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with Amazon EC2
     * boot modes</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the image. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with
     *         Amazon EC2 boot modes</a> in the <i>Amazon EC2 User Guide</i>.
     * @see BootModeValues
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    /**
     * <p>
     * If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon EC2 User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tpmSupport} will
     * return {@link TpmSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tpmSupportAsString}.
     * </p>
     * 
     * @return If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     * @see TpmSupportValues
     */
    public final TpmSupportValues tpmSupport() {
        return TpmSupportValues.fromValue(tpmSupport);
    }

    /**
     * <p>
     * If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon EC2 User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tpmSupport} will
     * return {@link TpmSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tpmSupportAsString}.
     * </p>
     * 
     * @return If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     * @see TpmSupportValues
     */
    public final String tpmSupportAsString() {
        return tpmSupport;
    }

    /**
     * <p>
     * The date and time to deprecate the AMI, in UTC, in the following format:
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specified a value for seconds, Amazon EC2
     * rounds the seconds to the nearest minute.
     * </p>
     * 
     * @return The date and time to deprecate the AMI, in UTC, in the following format:
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specified a value for seconds,
     *         Amazon EC2 rounds the seconds to the nearest minute.
     */
    public final String deprecationTime() {
        return deprecationTime;
    }

    /**
     * <p>
     * If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will
     * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
     * requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code>
     * is set to <code>2</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imdsSupport} will
     * return {@link ImdsSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imdsSupportAsString}.
     * </p>
     * 
     * @return If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI
     *         will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
     *         instance requires that IMDSv2 is used when requesting instance metadata. In addition,
     *         <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     *         >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
     * @see ImdsSupportValues
     */
    public final ImdsSupportValues imdsSupport() {
        return ImdsSupportValues.fromValue(imdsSupport);
    }

    /**
     * <p>
     * If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will
     * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
     * requires that IMDSv2 is used when requesting instance metadata. In addition, <code>HttpPutResponseHopLimit</code>
     * is set to <code>2</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imdsSupport} will
     * return {@link ImdsSupportValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imdsSupportAsString}.
     * </p>
     * 
     * @return If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI
     *         will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the
     *         instance requires that IMDSv2 is used when requesting instance metadata. In addition,
     *         <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
     *         >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
     * @see ImdsSupportValues
     */
    public final String imdsSupportAsString() {
        return imdsSupport;
    }

    /**
     * <p>
     * The ID of the instance that the AMI was created from if the AMI was created using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html">CreateImage</a>. This field
     * only appears if the AMI was created using CreateImage.
     * </p>
     * 
     * @return The ID of the instance that the AMI was created from if the AMI was created using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html">CreateImage</a>. This
     *         field only appears if the AMI was created using CreateImage.
     */
    public final String sourceInstanceId() {
        return sourceInstanceId;
    }

    /**
     * <p>
     * Indicates whether deregistration protection is enabled for the AMI.
     * </p>
     * 
     * @return Indicates whether deregistration protection is enabled for the AMI.
     */
    public final String deregistrationProtection() {
        return deregistrationProtection;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the AMI was
     * last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before
     * that usage is reported.
     * </p>
     * <note>
     * <p>
     * <code>lastLaunchedTime</code> data is available starting April 2017.
     * </p>
     * </note>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a
     *         24-hour delay before that usage is reported.</p> <note>
     *         <p>
     *         <code>lastLaunchedTime</code> data is available starting April 2017.
     *         </p>
     */
    public final String lastLaunchedTime() {
        return lastLaunchedTime;
    }

    /**
     * <p>
     * If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used in the
     * account. If <code>false</code> and Allowed AMIs is set to <code>enabled</code>, the AMI can't be discovered or
     * used in the account. If <code>false</code> and Allowed AMIs is set to <code>audit-mode</code>, the AMI can be
     * discovered and used in the account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery and use of
     * AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used in
     *         the account. If <code>false</code> and Allowed AMIs is set to <code>enabled</code>, the AMI can't be
     *         discovered or used in the account. If <code>false</code> and Allowed AMIs is set to
     *         <code>audit-mode</code>, the AMI can be discovered and used in the account.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery
     *         and use of AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
     */
    public final Boolean imageAllowed() {
        return imageAllowed;
    }

    /**
     * <p>
     * The ID of the source AMI from which the AMI was created.
     * </p>
     * 
     * @return The ID of the source AMI from which the AMI was created.
     */
    public final String sourceImageId() {
        return sourceImageId;
    }

    /**
     * <p>
     * The Region of the source AMI.
     * </p>
     * 
     * @return The Region of the source AMI.
     */
    public final String sourceImageRegion() {
        return sourceImageRegion;
    }

    /**
     * <p>
     * Indicates whether the image is eligible for Amazon Web Services Free Tier.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>true</code>, the AMI is eligible for Free Tier and can be used to launch instances under the Free Tier
     * limits.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>false</code>, the AMI is not eligible for Free Tier.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the image is eligible for Amazon Web Services Free Tier.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>true</code>, the AMI is eligible for Free Tier and can be used to launch instances under the
     *         Free Tier limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>false</code>, the AMI is not eligible for Free Tier.
     *         </p>
     *         </li>
     */
    public final Boolean freeTierEligible() {
        return freeTierEligible;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The location of the AMI.
     * </p>
     * 
     * @return The location of the AMI.
     */
    public final String imageLocation() {
        return imageLocation;
    }

    /**
     * <p>
     * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and
     * can be used to launch an instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the AMI. If the state is <code>available</code>, the image is successfully
     *         registered and can be used to launch an instance.
     * @see ImageState
     */
    public final ImageState state() {
        return ImageState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and
     * can be used to launch an instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the AMI. If the state is <code>available</code>, the image is successfully
     *         registered and can be used to launch an instance.
     * @see ImageState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the image.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the image.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The date and time the image was created.
     * </p>
     * 
     * @return The date and time the image was created.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any product codes associated with the AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return Any product codes associated with the AMI.
     */
    public final List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public final ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The type of image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageType} will
     * return {@link ImageTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageTypeAsString}.
     * </p>
     * 
     * @return The type of image.
     * @see ImageTypeValues
     */
    public final ImageTypeValues imageType() {
        return ImageTypeValues.fromValue(imageType);
    }

    /**
     * <p>
     * The type of image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageType} will
     * return {@link ImageTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageTypeAsString}.
     * </p>
     * 
     * @return The type of image.
     * @see ImageTypeValues
     */
    public final String imageTypeAsString() {
        return imageType;
    }

    /**
     * <p>
     * The kernel associated with the image, if any. Only applicable for machine images.
     * </p>
     * 
     * @return The kernel associated with the image, if any. Only applicable for machine images.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The RAM disk associated with the image, if any. Only applicable for machine images.
     * </p>
     * 
     * @return The RAM disk associated with the image, if any. Only applicable for machine images.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
     * @see PlatformValues
     */
    public final PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
     * @see PlatformValues
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has
     * public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.
     * </p>
     * 
     * @return Indicates whether the image has public launch permissions. The value is <code>true</code> if this image
     *         has public launch permissions or <code>false</code> if it has only implicit and explicit launch
     *         permissions.
     */
    public final Boolean publicLaunchPermissions() {
        return publicLaunchPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformDetails());
        hashCode = 31 * hashCode + Objects.hashCode(usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageOwnerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tpmSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationTime());
        hashCode = 31 * hashCode + Objects.hashCode(imdsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(deregistrationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(lastLaunchedTime());
        hashCode = 31 * hashCode + Objects.hashCode(imageAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageRegion());
        hashCode = 31 * hashCode + Objects.hashCode(freeTierEligible());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(imageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicLaunchPermissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        return Objects.equals(platformDetails(), other.platformDetails())
                && Objects.equals(usageOperation(), other.usageOperation())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(description(), other.description()) && Objects.equals(enaSupport(), other.enaSupport())
                && Objects.equals(hypervisorAsString(), other.hypervisorAsString())
                && Objects.equals(imageOwnerAlias(), other.imageOwnerAlias()) && Objects.equals(name(), other.name())
                && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(rootDeviceTypeAsString(), other.rootDeviceTypeAsString())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(stateReason(), other.stateReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(virtualizationTypeAsString(), other.virtualizationTypeAsString())
                && Objects.equals(bootModeAsString(), other.bootModeAsString())
                && Objects.equals(tpmSupportAsString(), other.tpmSupportAsString())
                && Objects.equals(deprecationTime(), other.deprecationTime())
                && Objects.equals(imdsSupportAsString(), other.imdsSupportAsString())
                && Objects.equals(sourceInstanceId(), other.sourceInstanceId())
                && Objects.equals(deregistrationProtection(), other.deregistrationProtection())
                && Objects.equals(lastLaunchedTime(), other.lastLaunchedTime())
                && Objects.equals(imageAllowed(), other.imageAllowed()) && Objects.equals(sourceImageId(), other.sourceImageId())
                && Objects.equals(sourceImageRegion(), other.sourceImageRegion())
                && Objects.equals(freeTierEligible(), other.freeTierEligible()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(imageLocation(), other.imageLocation())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(creationDate(), other.creationDate()) && hasProductCodes() == other.hasProductCodes()
                && Objects.equals(productCodes(), other.productCodes())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(imageTypeAsString(), other.imageTypeAsString()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(ramdiskId(), other.ramdiskId()) && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(publicLaunchPermissions(), other.publicLaunchPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Image").add("PlatformDetails", platformDetails()).add("UsageOperation", usageOperation())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("Description", description()).add("EnaSupport", enaSupport()).add("Hypervisor", hypervisorAsString())
                .add("ImageOwnerAlias", imageOwnerAlias()).add("Name", name()).add("RootDeviceName", rootDeviceName())
                .add("RootDeviceType", rootDeviceTypeAsString()).add("SriovNetSupport", sriovNetSupport())
                .add("StateReason", stateReason()).add("Tags", hasTags() ? tags() : null)
                .add("VirtualizationType", virtualizationTypeAsString()).add("BootMode", bootModeAsString())
                .add("TpmSupport", tpmSupportAsString()).add("DeprecationTime", deprecationTime())
                .add("ImdsSupport", imdsSupportAsString()).add("SourceInstanceId", sourceInstanceId())
                .add("DeregistrationProtection", deregistrationProtection()).add("LastLaunchedTime", lastLaunchedTime())
                .add("ImageAllowed", imageAllowed()).add("SourceImageId", sourceImageId())
                .add("SourceImageRegion", sourceImageRegion()).add("FreeTierEligible", freeTierEligible())
                .add("ImageId", imageId()).add("ImageLocation", imageLocation()).add("State", stateAsString())
                .add("OwnerId", ownerId()).add("CreationDate", creationDate())
                .add("ProductCodes", hasProductCodes() ? productCodes() : null).add("Architecture", architectureAsString())
                .add("ImageType", imageTypeAsString()).add("KernelId", kernelId()).add("RamdiskId", ramdiskId())
                .add("Platform", platformAsString()).add("PublicLaunchPermissions", publicLaunchPermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformDetails":
            return Optional.ofNullable(clazz.cast(platformDetails()));
        case "UsageOperation":
            return Optional.ofNullable(clazz.cast(usageOperation()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupport()));
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisorAsString()));
        case "ImageOwnerAlias":
            return Optional.ofNullable(clazz.cast(imageOwnerAlias()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RootDeviceName":
            return Optional.ofNullable(clazz.cast(rootDeviceName()));
        case "RootDeviceType":
            return Optional.ofNullable(clazz.cast(rootDeviceTypeAsString()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationTypeAsString()));
        case "BootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        case "TpmSupport":
            return Optional.ofNullable(clazz.cast(tpmSupportAsString()));
        case "DeprecationTime":
            return Optional.ofNullable(clazz.cast(deprecationTime()));
        case "ImdsSupport":
            return Optional.ofNullable(clazz.cast(imdsSupportAsString()));
        case "SourceInstanceId":
            return Optional.ofNullable(clazz.cast(sourceInstanceId()));
        case "DeregistrationProtection":
            return Optional.ofNullable(clazz.cast(deregistrationProtection()));
        case "LastLaunchedTime":
            return Optional.ofNullable(clazz.cast(lastLaunchedTime()));
        case "ImageAllowed":
            return Optional.ofNullable(clazz.cast(imageAllowed()));
        case "SourceImageId":
            return Optional.ofNullable(clazz.cast(sourceImageId()));
        case "SourceImageRegion":
            return Optional.ofNullable(clazz.cast(sourceImageRegion()));
        case "FreeTierEligible":
            return Optional.ofNullable(clazz.cast(freeTierEligible()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImageLocation":
            return Optional.ofNullable(clazz.cast(imageLocation()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "ImageType":
            return Optional.ofNullable(clazz.cast(imageTypeAsString()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "PublicLaunchPermissions":
            return Optional.ofNullable(clazz.cast(publicLaunchPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlatformDetails", PLATFORM_DETAILS_FIELD);
        map.put("UsageOperation", USAGE_OPERATION_FIELD);
        map.put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EnaSupport", ENA_SUPPORT_FIELD);
        map.put("Hypervisor", HYPERVISOR_FIELD);
        map.put("ImageOwnerAlias", IMAGE_OWNER_ALIAS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RootDeviceName", ROOT_DEVICE_NAME_FIELD);
        map.put("RootDeviceType", ROOT_DEVICE_TYPE_FIELD);
        map.put("SriovNetSupport", SRIOV_NET_SUPPORT_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("VirtualizationType", VIRTUALIZATION_TYPE_FIELD);
        map.put("BootMode", BOOT_MODE_FIELD);
        map.put("TpmSupport", TPM_SUPPORT_FIELD);
        map.put("DeprecationTime", DEPRECATION_TIME_FIELD);
        map.put("ImdsSupport", IMDS_SUPPORT_FIELD);
        map.put("SourceInstanceId", SOURCE_INSTANCE_ID_FIELD);
        map.put("DeregistrationProtection", DEREGISTRATION_PROTECTION_FIELD);
        map.put("LastLaunchedTime", LAST_LAUNCHED_TIME_FIELD);
        map.put("ImageAllowed", IMAGE_ALLOWED_FIELD);
        map.put("SourceImageId", SOURCE_IMAGE_ID_FIELD);
        map.put("SourceImageRegion", SOURCE_IMAGE_REGION_FIELD);
        map.put("FreeTierEligible", FREE_TIER_ELIGIBLE_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ImageLocation", IMAGE_LOCATION_FIELD);
        map.put("ImageState", STATE_FIELD);
        map.put("ImageOwnerId", OWNER_ID_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("ProductCodes", PRODUCT_CODES_FIELD);
        map.put("Architecture", ARCHITECTURE_FIELD);
        map.put("ImageType", IMAGE_TYPE_FIELD);
        map.put("KernelId", KERNEL_ID_FIELD);
        map.put("RamdiskId", RAMDISK_ID_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("IsPublic", PUBLIC_LAUNCH_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * The platform details associated with the billing code of the AMI. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understand AMI billing
         * information</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param platformDetails
         *        The platform details associated with the billing code of the AMI. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understand AMI
         *        billing information</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDetails(String platformDetails);

        /**
         * <p>
         * The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
         * <code>usageOperation</code> corresponds to the <a
         * href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation"
         * >lineitem/Operation</a> column on your Amazon Web Services Cost and Usage Report and in the <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web Services
         * Price List API</a>. You can view these fields on the <b>Instances</b> or <b>AMIs</b> pages in the Amazon EC2
         * console, or in the responses that are returned by the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages</a>
         * command in the Amazon EC2 API, or the <a
         * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images</a> command
         * in the CLI.
         * </p>
         * 
         * @param usageOperation
         *        The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
         *        <code>usageOperation</code> corresponds to the <a
         *        href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation"
         *        >lineitem/Operation</a> column on your Amazon Web Services Cost and Usage Report and in the <a
         *        href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web
         *        Services Price List API</a>. You can view these fields on the <b>Instances</b> or <b>AMIs</b> pages in
         *        the Amazon EC2 console, or in the responses that are returned by the <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html"
         *        >DescribeImages</a> command in the Amazon EC2 API, or the <a
         *        href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images</a>
         *        command in the CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperation(String usageOperation);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The description of the AMI that was provided during image creation.
         * </p>
         * 
         * @param description
         *        The description of the AMI that was provided during image creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Specifies whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not supported.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not
         *        supported.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not supported.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is not
         *        supported.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(HypervisorType hypervisor);

        /**
         * <p>
         * The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>).
         * </p>
         * 
         * @param imageOwnerAlias
         *        The owner alias (<code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOwnerAlias(String imageOwnerAlias);

        /**
         * <p>
         * The name of the AMI that was provided during image creation.
         * </p>
         * 
         * @param name
         *        The name of the AMI that was provided during image creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store
         *        volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store
         *        volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(DeviceType rootDeviceType);

        /**
         * <p>
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The reason for the state change.
         * </p>
         * 
         * @param stateReason
         *        The reason for the state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(StateReason stateReason);

        /**
         * <p>
         * The reason for the state change.
         * </p>
         * This is a convenience method that creates an instance of the {@link StateReason.Builder} avoiding the need to
         * create one manually via {@link StateReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StateReason.Builder#build()} is called immediately and its result
         * is passed to {@link #stateReason(StateReason)}.
         * 
         * @param stateReason
         *        a consumer that will call methods on {@link StateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateReason(StateReason)
         */
        default Builder stateReason(Consumer<StateReason.Builder> stateReason) {
            return stateReason(StateReason.builder().applyMutation(stateReason).build());
        }

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The type of virtualization of the AMI.
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization of the AMI.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The type of virtualization of the AMI.
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization of the AMI.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);

        /**
         * <p>
         * The boot mode of the image. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with Amazon
         * EC2 boot modes</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the image. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with
         *        Amazon EC2 boot modes</a> in the <i>Amazon EC2 User Guide</i>.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * The boot mode of the image. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with Amazon
         * EC2 boot modes</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the image. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Instance launch behavior with
         *        Amazon EC2 boot modes</a> in the <i>Amazon EC2 User Guide</i>.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(BootModeValues bootMode);

        /**
         * <p>
         * If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon EC2
         * User Guide</i>.
         * </p>
         * 
         * @param tpmSupport
         *        If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information,
         *        see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the
         *        <i>Amazon EC2 User Guide</i>.
         * @see TpmSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TpmSupportValues
         */
        Builder tpmSupport(String tpmSupport);

        /**
         * <p>
         * If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the <i>Amazon EC2
         * User Guide</i>.
         * </p>
         * 
         * @param tpmSupport
         *        If the image is configured for NitroTPM support, the value is <code>v2.0</code>. For more information,
         *        see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the
         *        <i>Amazon EC2 User Guide</i>.
         * @see TpmSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TpmSupportValues
         */
        Builder tpmSupport(TpmSupportValues tpmSupport);

        /**
         * <p>
         * The date and time to deprecate the AMI, in UTC, in the following format:
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specified a value for seconds, Amazon
         * EC2 rounds the seconds to the nearest minute.
         * </p>
         * 
         * @param deprecationTime
         *        The date and time to deprecate the AMI, in UTC, in the following format:
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z. If you specified a value for seconds,
         *        Amazon EC2 rounds the seconds to the nearest minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationTime(String deprecationTime);

        /**
         * <p>
         * If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will
         * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
         * requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param imdsSupport
         *        If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this
         *        AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default,
         *        the instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         *        <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         *        >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * @see ImdsSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImdsSupportValues
         */
        Builder imdsSupport(String imdsSupport);

        /**
         * <p>
         * If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this AMI will
         * have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default, the instance
         * requires that IMDSv2 is used when requesting instance metadata. In addition,
         * <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         * >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param imdsSupport
         *        If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched from this
         *        AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so that, by default,
         *        the instance requires that IMDSv2 is used when requesting instance metadata. In addition,
         *        <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration"
         *        >Configure the AMI</a> in the <i>Amazon EC2 User Guide</i>.
         * @see ImdsSupportValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImdsSupportValues
         */
        Builder imdsSupport(ImdsSupportValues imdsSupport);

        /**
         * <p>
         * The ID of the instance that the AMI was created from if the AMI was created using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html">CreateImage</a>. This
         * field only appears if the AMI was created using CreateImage.
         * </p>
         * 
         * @param sourceInstanceId
         *        The ID of the instance that the AMI was created from if the AMI was created using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html">CreateImage</a>.
         *        This field only appears if the AMI was created using CreateImage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceInstanceId(String sourceInstanceId);

        /**
         * <p>
         * Indicates whether deregistration protection is enabled for the AMI.
         * </p>
         * 
         * @param deregistrationProtection
         *        Indicates whether deregistration protection is enabled for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregistrationProtection(String deregistrationProtection);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the AMI
         * was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay
         * before that usage is reported.
         * </p>
         * <note>
         * <p>
         * <code>lastLaunchedTime</code> data is available starting April 2017.
         * </p>
         * </note>
         * 
         * @param lastLaunchedTime
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a
         *        24-hour delay before that usage is reported.</p> <note>
         *        <p>
         *        <code>lastLaunchedTime</code> data is available starting April 2017.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastLaunchedTime(String lastLaunchedTime);

        /**
         * <p>
         * If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used in the
         * account. If <code>false</code> and Allowed AMIs is set to <code>enabled</code>, the AMI can't be discovered
         * or used in the account. If <code>false</code> and Allowed AMIs is set to <code>audit-mode</code>, the AMI can
         * be discovered and used in the account.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery and
         * use of AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param imageAllowed
         *        If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used
         *        in the account. If <code>false</code> and Allowed AMIs is set to <code>enabled</code>, the AMI can't
         *        be discovered or used in the account. If <code>false</code> and Allowed AMIs is set to
         *        <code>audit-mode</code>, the AMI can be discovered and used in the account.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery
         *        and use of AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAllowed(Boolean imageAllowed);

        /**
         * <p>
         * The ID of the source AMI from which the AMI was created.
         * </p>
         * 
         * @param sourceImageId
         *        The ID of the source AMI from which the AMI was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageId(String sourceImageId);

        /**
         * <p>
         * The Region of the source AMI.
         * </p>
         * 
         * @param sourceImageRegion
         *        The Region of the source AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageRegion(String sourceImageRegion);

        /**
         * <p>
         * Indicates whether the image is eligible for Amazon Web Services Free Tier.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>true</code>, the AMI is eligible for Free Tier and can be used to launch instances under the Free
         * Tier limits.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>false</code>, the AMI is not eligible for Free Tier.
         * </p>
         * </li>
         * </ul>
         * 
         * @param freeTierEligible
         *        Indicates whether the image is eligible for Amazon Web Services Free Tier.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>true</code>, the AMI is eligible for Free Tier and can be used to launch instances under the
         *        Free Tier limits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>false</code>, the AMI is not eligible for Free Tier.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTierEligible(Boolean freeTierEligible);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The location of the AMI.
         * </p>
         * 
         * @param imageLocation
         *        The location of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLocation(String imageLocation);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered
         * and can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the image is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered
         * and can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the image is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(ImageState state);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the image.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The date and time the image was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * 
         * @param productCodes
         *        Any product codes associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * 
         * @param productCodes
         *        Any product codes associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ProductCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(java.util.Collection<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * The type of image.
         * </p>
         * 
         * @param imageType
         *        The type of image.
         * @see ImageTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTypeValues
         */
        Builder imageType(String imageType);

        /**
         * <p>
         * The type of image.
         * </p>
         * 
         * @param imageType
         *        The type of image.
         * @see ImageTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTypeValues
         */
        Builder imageType(ImageTypeValues imageType);

        /**
         * <p>
         * The kernel associated with the image, if any. Only applicable for machine images.
         * </p>
         * 
         * @param kernelId
         *        The kernel associated with the image, if any. Only applicable for machine images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The RAM disk associated with the image, if any. Only applicable for machine images.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk associated with the image, if any. Only applicable for machine images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
         * </p>
         * 
         * @param platform
         *        This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
         * </p>
         * 
         * @param platform
         *        This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has
         * public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.
         * </p>
         * 
         * @param publicLaunchPermissions
         *        Indicates whether the image has public launch permissions. The value is <code>true</code> if this
         *        image has public launch permissions or <code>false</code> if it has only implicit and explicit launch
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicLaunchPermissions(Boolean publicLaunchPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String platformDetails;

        private String usageOperation;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean enaSupport;

        private String hypervisor;

        private String imageOwnerAlias;

        private String name;

        private String rootDeviceName;

        private String rootDeviceType;

        private String sriovNetSupport;

        private StateReason stateReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String virtualizationType;

        private String bootMode;

        private String tpmSupport;

        private String deprecationTime;

        private String imdsSupport;

        private String sourceInstanceId;

        private String deregistrationProtection;

        private String lastLaunchedTime;

        private Boolean imageAllowed;

        private String sourceImageId;

        private String sourceImageRegion;

        private Boolean freeTierEligible;

        private String imageId;

        private String imageLocation;

        private String state;

        private String ownerId;

        private String creationDate;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private String architecture;

        private String imageType;

        private String kernelId;

        private String ramdiskId;

        private String platform;

        private Boolean publicLaunchPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            platformDetails(model.platformDetails);
            usageOperation(model.usageOperation);
            blockDeviceMappings(model.blockDeviceMappings);
            description(model.description);
            enaSupport(model.enaSupport);
            hypervisor(model.hypervisor);
            imageOwnerAlias(model.imageOwnerAlias);
            name(model.name);
            rootDeviceName(model.rootDeviceName);
            rootDeviceType(model.rootDeviceType);
            sriovNetSupport(model.sriovNetSupport);
            stateReason(model.stateReason);
            tags(model.tags);
            virtualizationType(model.virtualizationType);
            bootMode(model.bootMode);
            tpmSupport(model.tpmSupport);
            deprecationTime(model.deprecationTime);
            imdsSupport(model.imdsSupport);
            sourceInstanceId(model.sourceInstanceId);
            deregistrationProtection(model.deregistrationProtection);
            lastLaunchedTime(model.lastLaunchedTime);
            imageAllowed(model.imageAllowed);
            sourceImageId(model.sourceImageId);
            sourceImageRegion(model.sourceImageRegion);
            freeTierEligible(model.freeTierEligible);
            imageId(model.imageId);
            imageLocation(model.imageLocation);
            state(model.state);
            ownerId(model.ownerId);
            creationDate(model.creationDate);
            productCodes(model.productCodes);
            architecture(model.architecture);
            imageType(model.imageType);
            kernelId(model.kernelId);
            ramdiskId(model.ramdiskId);
            platform(model.platform);
            publicLaunchPermissions(model.publicLaunchPermissions);
        }

        public final String getPlatformDetails() {
            return platformDetails;
        }

        public final void setPlatformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
        }

        @Override
        public final Builder platformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
            return this;
        }

        public final String getUsageOperation() {
            return usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor == null ? null : hypervisor.toString());
            return this;
        }

        public final String getImageOwnerAlias() {
            return imageOwnerAlias;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType == null ? null : rootDeviceType.toString());
            return this;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final StateReason.Builder getStateReason() {
            return stateReason != null ? stateReason.toBuilder() : null;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType == null ? null : virtualizationType.toString());
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final String getTpmSupport() {
            return tpmSupport;
        }

        public final void setTpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
        }

        @Override
        public final Builder tpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        @Override
        public final Builder tpmSupport(TpmSupportValues tpmSupport) {
            this.tpmSupport(tpmSupport == null ? null : tpmSupport.toString());
            return this;
        }

        public final String getDeprecationTime() {
            return deprecationTime;
        }

        public final void setDeprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
        }

        @Override
        public final Builder deprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
            return this;
        }

        public final String getImdsSupport() {
            return imdsSupport;
        }

        public final void setImdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
        }

        @Override
        public final Builder imdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
            return this;
        }

        @Override
        public final Builder imdsSupport(ImdsSupportValues imdsSupport) {
            this.imdsSupport(imdsSupport == null ? null : imdsSupport.toString());
            return this;
        }

        public final String getSourceInstanceId() {
            return sourceInstanceId;
        }

        public final void setSourceInstanceId(String sourceInstanceId) {
            this.sourceInstanceId = sourceInstanceId;
        }

        @Override
        public final Builder sourceInstanceId(String sourceInstanceId) {
            this.sourceInstanceId = sourceInstanceId;
            return this;
        }

        public final String getDeregistrationProtection() {
            return deregistrationProtection;
        }

        public final void setDeregistrationProtection(String deregistrationProtection) {
            this.deregistrationProtection = deregistrationProtection;
        }

        @Override
        public final Builder deregistrationProtection(String deregistrationProtection) {
            this.deregistrationProtection = deregistrationProtection;
            return this;
        }

        public final String getLastLaunchedTime() {
            return lastLaunchedTime;
        }

        public final void setLastLaunchedTime(String lastLaunchedTime) {
            this.lastLaunchedTime = lastLaunchedTime;
        }

        @Override
        public final Builder lastLaunchedTime(String lastLaunchedTime) {
            this.lastLaunchedTime = lastLaunchedTime;
            return this;
        }

        public final Boolean getImageAllowed() {
            return imageAllowed;
        }

        public final void setImageAllowed(Boolean imageAllowed) {
            this.imageAllowed = imageAllowed;
        }

        @Override
        public final Builder imageAllowed(Boolean imageAllowed) {
            this.imageAllowed = imageAllowed;
            return this;
        }

        public final String getSourceImageId() {
            return sourceImageId;
        }

        public final void setSourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
        }

        @Override
        public final Builder sourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        public final String getSourceImageRegion() {
            return sourceImageRegion;
        }

        public final void setSourceImageRegion(String sourceImageRegion) {
            this.sourceImageRegion = sourceImageRegion;
        }

        @Override
        public final Builder sourceImageRegion(String sourceImageRegion) {
            this.sourceImageRegion = sourceImageRegion;
            return this;
        }

        public final Boolean getFreeTierEligible() {
            return freeTierEligible;
        }

        public final void setFreeTierEligible(Boolean freeTierEligible) {
            this.freeTierEligible = freeTierEligible;
        }

        @Override
        public final Builder freeTierEligible(Boolean freeTierEligible) {
            this.freeTierEligible = freeTierEligible;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageLocation() {
            return imageLocation;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final String getImageType() {
            return imageType;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        @Override
        public final Builder imageType(ImageTypeValues imageType) {
            this.imageType(imageType == null ? null : imageType.toString());
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Boolean getPublicLaunchPermissions() {
            return publicLaunchPermissions;
        }

        public final void setPublicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
        }

        @Override
        public final Builder publicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
            return this;
        }

        @Override
        public Image build() {
            return new Image(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
