/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteServerRequest extends Ec2Request implements
        ToCopyableBuilder<CreateRouteServerRequest.Builder, CreateRouteServerRequest> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AmazonSideAsn")
            .getter(getter(CreateRouteServerRequest::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn")
                    .unmarshallLocationName("AmazonSideAsn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateRouteServerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateRouteServerRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> PERSIST_ROUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PersistRoutes")
            .getter(getter(CreateRouteServerRequest::persistRoutesAsString))
            .setter(setter(Builder::persistRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutes")
                    .unmarshallLocationName("PersistRoutes").build()).build();

    private static final SdkField<Long> PERSIST_ROUTES_DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PersistRoutesDuration")
            .getter(getter(CreateRouteServerRequest::persistRoutesDuration))
            .setter(setter(Builder::persistRoutesDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutesDuration")
                    .unmarshallLocationName("PersistRoutesDuration").build()).build();

    private static final SdkField<Boolean> SNS_NOTIFICATIONS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SnsNotificationsEnabled")
            .getter(getter(CreateRouteServerRequest::snsNotificationsEnabled))
            .setter(setter(Builder::snsNotificationsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsNotificationsEnabled")
                    .unmarshallLocationName("SnsNotificationsEnabled").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateRouteServerRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD,
            CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, PERSIST_ROUTES_FIELD, PERSIST_ROUTES_DURATION_FIELD,
            SNS_NOTIFICATIONS_ENABLED_FIELD, TAG_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long amazonSideAsn;

    private final String clientToken;

    private final Boolean dryRun;

    private final String persistRoutes;

    private final Long persistRoutesDuration;

    private final Boolean snsNotificationsEnabled;

    private final List<TagSpecification> tagSpecifications;

    private CreateRouteServerRequest(BuilderImpl builder) {
        super(builder);
        this.amazonSideAsn = builder.amazonSideAsn;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.persistRoutes = builder.persistRoutes;
        this.persistRoutesDuration = builder.persistRoutesDuration;
        this.snsNotificationsEnabled = builder.snsNotificationsEnabled;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The private Autonomous System Number (ASN) for the Amazon side of the BGP session. Valid values are from 1 to
     * 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294 (32-bit
     * ASN) range.
     * </p>
     * 
     * @return The private Autonomous System Number (ASN) for the Amazon side of the BGP session. Valid values are from
     *         1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or
     *         4200000000–4294967294 (32-bit ASN) range.
     */
    public final Long amazonSideAsn() {
        return amazonSideAsn;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Indicates whether routes should be persisted after all BGP sessions are terminated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistRoutes}
     * will return {@link RouteServerPersistRoutesAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #persistRoutesAsString}.
     * </p>
     * 
     * @return Indicates whether routes should be persisted after all BGP sessions are terminated.
     * @see RouteServerPersistRoutesAction
     */
    public final RouteServerPersistRoutesAction persistRoutes() {
        return RouteServerPersistRoutesAction.fromValue(persistRoutes);
    }

    /**
     * <p>
     * Indicates whether routes should be persisted after all BGP sessions are terminated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistRoutes}
     * will return {@link RouteServerPersistRoutesAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #persistRoutesAsString}.
     * </p>
     * 
     * @return Indicates whether routes should be persisted after all BGP sessions are terminated.
     * @see RouteServerPersistRoutesAction
     */
    public final String persistRoutesAsString() {
        return persistRoutes;
    }

    /**
     * <p>
     * The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB and
     * RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>.
     * </p>
     * <p>
     * If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route server, it
     * has 1 minute to relearn it's adjacent network and advertise those routes to route server before route server
     * resumes normal functionality. In most cases, 1 minute is probably sufficient. If, however, you have concerns that
     * your BGP network may not be capable of fully re-establishing and re-learning everything in 1 minute, you can
     * increase the duration up to 5 minutes.
     * </p>
     * 
     * @return The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the
     *         FIB and RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>.</p>
     *         <p>
     *         If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route
     *         server, it has 1 minute to relearn it's adjacent network and advertise those routes to route server
     *         before route server resumes normal functionality. In most cases, 1 minute is probably sufficient. If,
     *         however, you have concerns that your BGP network may not be capable of fully re-establishing and
     *         re-learning everything in 1 minute, you can increase the duration up to 5 minutes.
     */
    public final Long persistRoutesDuration() {
        return persistRoutesDuration;
    }

    /**
     * <p>
     * Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications
     * persists BGP status changes to an SNS topic provisioned by Amazon Web Services.
     * </p>
     * 
     * @return Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications
     *         persists BGP status changes to an SNS topic provisioned by Amazon Web Services.
     */
    public final Boolean snsNotificationsEnabled() {
        return snsNotificationsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the route server during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the route server during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(persistRoutesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(persistRoutesDuration());
        hashCode = 31 * hashCode + Objects.hashCode(snsNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteServerRequest)) {
            return false;
        }
        CreateRouteServerRequest other = (CreateRouteServerRequest) obj;
        return Objects.equals(amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(persistRoutesAsString(), other.persistRoutesAsString())
                && Objects.equals(persistRoutesDuration(), other.persistRoutesDuration())
                && Objects.equals(snsNotificationsEnabled(), other.snsNotificationsEnabled())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouteServerRequest").add("AmazonSideAsn", amazonSideAsn())
                .add("ClientToken", clientToken()).add("DryRun", dryRun()).add("PersistRoutes", persistRoutesAsString())
                .add("PersistRoutesDuration", persistRoutesDuration()).add("SnsNotificationsEnabled", snsNotificationsEnabled())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "PersistRoutes":
            return Optional.ofNullable(clazz.cast(persistRoutesAsString()));
        case "PersistRoutesDuration":
            return Optional.ofNullable(clazz.cast(persistRoutesDuration()));
        case "SnsNotificationsEnabled":
            return Optional.ofNullable(clazz.cast(snsNotificationsEnabled()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AmazonSideAsn", AMAZON_SIDE_ASN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PersistRoutes", PERSIST_ROUTES_FIELD);
        map.put("PersistRoutesDuration", PERSIST_ROUTES_DURATION_FIELD);
        map.put("SnsNotificationsEnabled", SNS_NOTIFICATIONS_ENABLED_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteServerRequest, T> g) {
        return obj -> g.apply((CreateRouteServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouteServerRequest> {
        /**
         * <p>
         * The private Autonomous System Number (ASN) for the Amazon side of the BGP session. Valid values are from 1 to
         * 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294 (32-bit
         * ASN) range.
         * </p>
         * 
         * @param amazonSideAsn
         *        The private Autonomous System Number (ASN) for the Amazon side of the BGP session. Valid values are
         *        from 1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or
         *        4200000000–4294967294 (32-bit ASN) range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);

        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Indicates whether routes should be persisted after all BGP sessions are terminated.
         * </p>
         * 
         * @param persistRoutes
         *        Indicates whether routes should be persisted after all BGP sessions are terminated.
         * @see RouteServerPersistRoutesAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerPersistRoutesAction
         */
        Builder persistRoutes(String persistRoutes);

        /**
         * <p>
         * Indicates whether routes should be persisted after all BGP sessions are terminated.
         * </p>
         * 
         * @param persistRoutes
         *        Indicates whether routes should be persisted after all BGP sessions are terminated.
         * @see RouteServerPersistRoutesAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerPersistRoutesAction
         */
        Builder persistRoutes(RouteServerPersistRoutesAction persistRoutes);

        /**
         * <p>
         * The number of minutes a route server will wait after BGP is re-established to unpersist the routes in the FIB
         * and RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>.
         * </p>
         * <p>
         * If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route server,
         * it has 1 minute to relearn it's adjacent network and advertise those routes to route server before route
         * server resumes normal functionality. In most cases, 1 minute is probably sufficient. If, however, you have
         * concerns that your BGP network may not be capable of fully re-establishing and re-learning everything in 1
         * minute, you can increase the duration up to 5 minutes.
         * </p>
         * 
         * @param persistRoutesDuration
         *        The number of minutes a route server will wait after BGP is re-established to unpersist the routes in
         *        the FIB and RIB. Value must be in the range of 1-5. Required if PersistRoutes is <code>enabled</code>
         *        .</p>
         *        <p>
         *        If you set the duration to 1 minute, then when your network appliance re-establishes BGP with route
         *        server, it has 1 minute to relearn it's adjacent network and advertise those routes to route server
         *        before route server resumes normal functionality. In most cases, 1 minute is probably sufficient. If,
         *        however, you have concerns that your BGP network may not be capable of fully re-establishing and
         *        re-learning everything in 1 minute, you can increase the duration up to 5 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistRoutesDuration(Long persistRoutesDuration);

        /**
         * <p>
         * Indicates whether SNS notifications should be enabled for route server events. Enabling SNS notifications
         * persists BGP status changes to an SNS topic provisioned by Amazon Web Services.
         * </p>
         * 
         * @param snsNotificationsEnabled
         *        Indicates whether SNS notifications should be enabled for route server events. Enabling SNS
         *        notifications persists BGP status changes to an SNS topic provisioned by Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsNotificationsEnabled(Boolean snsNotificationsEnabled);

        /**
         * <p>
         * The tags to apply to the route server during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the route server during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the route server during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the route server during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the route server during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Long amazonSideAsn;

        private String clientToken;

        private Boolean dryRun;

        private String persistRoutes;

        private Long persistRoutesDuration;

        private Boolean snsNotificationsEnabled;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteServerRequest model) {
            super(model);
            amazonSideAsn(model.amazonSideAsn);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
            persistRoutes(model.persistRoutes);
            persistRoutesDuration(model.persistRoutesDuration);
            snsNotificationsEnabled(model.snsNotificationsEnabled);
            tagSpecifications(model.tagSpecifications);
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getPersistRoutes() {
            return persistRoutes;
        }

        public final void setPersistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
        }

        @Override
        public final Builder persistRoutes(String persistRoutes) {
            this.persistRoutes = persistRoutes;
            return this;
        }

        @Override
        public final Builder persistRoutes(RouteServerPersistRoutesAction persistRoutes) {
            this.persistRoutes(persistRoutes == null ? null : persistRoutes.toString());
            return this;
        }

        public final Long getPersistRoutesDuration() {
            return persistRoutesDuration;
        }

        public final void setPersistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
        }

        @Override
        public final Builder persistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
            return this;
        }

        public final Boolean getSnsNotificationsEnabled() {
            return snsNotificationsEnabled;
        }

        public final void setSnsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
        }

        @Override
        public final Builder snsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteServerRequest build() {
            return new CreateRouteServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
