/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateRouteTableRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateRouteTableRequest.Builder, AssociateRouteTableRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GatewayId")
            .getter(getter(AssociateRouteTableRequest::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId")
                    .unmarshallLocationName("GatewayId").build()).build();

    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIpv4Pool")
            .getter(getter(AssociateRouteTableRequest::publicIpv4Pool))
            .setter(setter(Builder::publicIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool")
                    .unmarshallLocationName("PublicIpv4Pool").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(AssociateRouteTableRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(AssociateRouteTableRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId")
            .getter(getter(AssociateRouteTableRequest::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("routeTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            PUBLIC_IPV4_POOL_FIELD, DRY_RUN_FIELD, SUBNET_ID_FIELD, ROUTE_TABLE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayId;

    private final String publicIpv4Pool;

    private final Boolean dryRun;

    private final String subnetId;

    private final String routeTableId;

    private AssociateRouteTableRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.dryRun = builder.dryRun;
        this.subnetId = builder.subnetId;
        this.routeTableId = builder.routeTableId;
    }

    /**
     * <p>
     * The ID of the internet gateway or virtual private gateway.
     * </p>
     * 
     * @return The ID of the internet gateway or virtual private gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of a public IPv4 pool. A public IPv4 pool is a pool of IPv4 addresses that you've brought to Amazon Web
     * Services with BYOIP.
     * </p>
     * 
     * @return The ID of a public IPv4 pool. A public IPv4 pool is a pool of IPv4 addresses that you've brought to
     *         Amazon Web Services with BYOIP.
     */
    public final String publicIpv4Pool() {
        return publicIpv4Pool;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRouteTableRequest)) {
            return false;
        }
        AssociateRouteTableRequest other = (AssociateRouteTableRequest) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(publicIpv4Pool(), other.publicIpv4Pool())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(routeTableId(), other.routeTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateRouteTableRequest").add("GatewayId", gatewayId())
                .add("PublicIpv4Pool", publicIpv4Pool()).add("DryRun", dryRun()).add("SubnetId", subnetId())
                .add("RouteTableId", routeTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "PublicIpv4Pool":
            return Optional.ofNullable(clazz.cast(publicIpv4Pool()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("PublicIpv4Pool", PUBLIC_IPV4_POOL_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateRouteTableRequest, T> g) {
        return obj -> g.apply((AssociateRouteTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateRouteTableRequest> {
        /**
         * <p>
         * The ID of the internet gateway or virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the internet gateway or virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of a public IPv4 pool. A public IPv4 pool is a pool of IPv4 addresses that you've brought to Amazon
         * Web Services with BYOIP.
         * </p>
         * 
         * @param publicIpv4Pool
         *        The ID of a public IPv4 pool. A public IPv4 pool is a pool of IPv4 addresses that you've brought to
         *        Amazon Web Services with BYOIP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pool(String publicIpv4Pool);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String gatewayId;

        private String publicIpv4Pool;

        private Boolean dryRun;

        private String subnetId;

        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRouteTableRequest model) {
            super(model);
            gatewayId(model.gatewayId);
            publicIpv4Pool(model.publicIpv4Pool);
            dryRun(model.dryRun);
            subnetId(model.subnetId);
            routeTableId(model.routeTableId);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getPublicIpv4Pool() {
            return publicIpv4Pool;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateRouteTableRequest build() {
            return new AssociateRouteTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
