/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpamPoolAllocationResourceType {
    IPAM_POOL("ipam-pool"),
    VPC("vpc"),
    EC2_PUBLIC_IPV4_POOL("ec2-public-ipv4-pool"),
    CUSTOM("custom"),
    SUBNET("subnet"),
    EIP("eip"),
    ANYCAST_IP_LIST("anycast-ip-list"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpamPoolAllocationResourceType> VALUE_MAP;
    private final String value;

    private IpamPoolAllocationResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpamPoolAllocationResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpamPoolAllocationResourceType> knownValues() {
        EnumSet<IpamPoolAllocationResourceType> knownValues = EnumSet.allOf(IpamPoolAllocationResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpamPoolAllocationResourceType.class, IpamPoolAllocationResourceType::toString);
    }
}

