/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InterruptibleCapacityReservationAllocationStatus;
import software.amazon.awssdk.services.ec2.model.InterruptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInterruptibleCapacityReservationAllocationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateInterruptibleCapacityReservationAllocationResponse> {
    private static final SdkField<String> SOURCE_CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCapacityReservationId").getter(CreateInterruptibleCapacityReservationAllocationResponse.getter(CreateInterruptibleCapacityReservationAllocationResponse::sourceCapacityReservationId)).setter(CreateInterruptibleCapacityReservationAllocationResponse.setter(Builder::sourceCapacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservationId").unmarshallLocationName("sourceCapacityReservationId").build()}).build();
    private static final SdkField<Integer> TARGET_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetInstanceCount").getter(CreateInterruptibleCapacityReservationAllocationResponse.getter(CreateInterruptibleCapacityReservationAllocationResponse::targetInstanceCount)).setter(CreateInterruptibleCapacityReservationAllocationResponse.setter(Builder::targetInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetInstanceCount").unmarshallLocationName("targetInstanceCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateInterruptibleCapacityReservationAllocationResponse.getter(CreateInterruptibleCapacityReservationAllocationResponse::statusAsString)).setter(CreateInterruptibleCapacityReservationAllocationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> INTERRUPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterruptionType").getter(CreateInterruptibleCapacityReservationAllocationResponse.getter(CreateInterruptibleCapacityReservationAllocationResponse::interruptionTypeAsString)).setter(CreateInterruptibleCapacityReservationAllocationResponse.setter(Builder::interruptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionType").unmarshallLocationName("interruptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CAPACITY_RESERVATION_ID_FIELD, TARGET_INSTANCE_COUNT_FIELD, STATUS_FIELD, INTERRUPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInterruptibleCapacityReservationAllocationResponse.memberNameToFieldInitializer();
    private final String sourceCapacityReservationId;
    private final Integer targetInstanceCount;
    private final String status;
    private final String interruptionType;

    private CreateInterruptibleCapacityReservationAllocationResponse(BuilderImpl builder) {
        super(builder);
        this.sourceCapacityReservationId = builder.sourceCapacityReservationId;
        this.targetInstanceCount = builder.targetInstanceCount;
        this.status = builder.status;
        this.interruptionType = builder.interruptionType;
    }

    public final String sourceCapacityReservationId() {
        return this.sourceCapacityReservationId;
    }

    public final Integer targetInstanceCount() {
        return this.targetInstanceCount;
    }

    public final InterruptibleCapacityReservationAllocationStatus status() {
        return InterruptibleCapacityReservationAllocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final InterruptionType interruptionType() {
        return InterruptionType.fromValue(this.interruptionType);
    }

    public final String interruptionTypeAsString() {
        return this.interruptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.interruptionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInterruptibleCapacityReservationAllocationResponse)) {
            return false;
        }
        CreateInterruptibleCapacityReservationAllocationResponse other = (CreateInterruptibleCapacityReservationAllocationResponse)((Object)obj);
        return Objects.equals(this.sourceCapacityReservationId(), other.sourceCapacityReservationId()) && Objects.equals(this.targetInstanceCount(), other.targetInstanceCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.interruptionTypeAsString(), other.interruptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInterruptibleCapacityReservationAllocationResponse").add("SourceCapacityReservationId", (Object)this.sourceCapacityReservationId()).add("TargetInstanceCount", (Object)this.targetInstanceCount()).add("Status", (Object)this.statusAsString()).add("InterruptionType", (Object)this.interruptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceCapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.sourceCapacityReservationId()));
            }
            case "TargetInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "InterruptionType": {
                return Optional.ofNullable(clazz.cast(this.interruptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceCapacityReservationId", SOURCE_CAPACITY_RESERVATION_ID_FIELD);
        map.put("TargetInstanceCount", TARGET_INSTANCE_COUNT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("InterruptionType", INTERRUPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInterruptibleCapacityReservationAllocationResponse, T> g) {
        return obj -> g.apply((CreateInterruptibleCapacityReservationAllocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String sourceCapacityReservationId;
        private Integer targetInstanceCount;
        private String status;
        private String interruptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInterruptibleCapacityReservationAllocationResponse model) {
            super(model);
            this.sourceCapacityReservationId(model.sourceCapacityReservationId);
            this.targetInstanceCount(model.targetInstanceCount);
            this.status(model.status);
            this.interruptionType(model.interruptionType);
        }

        public final String getSourceCapacityReservationId() {
            return this.sourceCapacityReservationId;
        }

        public final void setSourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
        }

        @Override
        public final Builder sourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
            return this;
        }

        public final Integer getTargetInstanceCount() {
            return this.targetInstanceCount;
        }

        public final void setTargetInstanceCount(Integer targetInstanceCount) {
            this.targetInstanceCount = targetInstanceCount;
        }

        @Override
        public final Builder targetInstanceCount(Integer targetInstanceCount) {
            this.targetInstanceCount = targetInstanceCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InterruptibleCapacityReservationAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getInterruptionType() {
            return this.interruptionType;
        }

        public final void setInterruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
        }

        @Override
        public final Builder interruptionType(String interruptionType) {
            this.interruptionType = interruptionType;
            return this;
        }

        @Override
        public final Builder interruptionType(InterruptionType interruptionType) {
            this.interruptionType(interruptionType == null ? null : interruptionType.toString());
            return this;
        }

        @Override
        public CreateInterruptibleCapacityReservationAllocationResponse build() {
            return new CreateInterruptibleCapacityReservationAllocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInterruptibleCapacityReservationAllocationResponse> {
        public Builder sourceCapacityReservationId(String var1);

        public Builder targetInstanceCount(Integer var1);

        public Builder status(String var1);

        public Builder status(InterruptibleCapacityReservationAllocationStatus var1);

        public Builder interruptionType(String var1);

        public Builder interruptionType(InterruptionType var1);
    }
}

