/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolversRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolversResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolver;

public class DescribeIpamPrefixListResolversIterable
implements SdkIterable<DescribeIpamPrefixListResolversResponse> {
    private final Ec2Client client;
    private final DescribeIpamPrefixListResolversRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpamPrefixListResolversIterable(Ec2Client client, DescribeIpamPrefixListResolversRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeIpamPrefixListResolversResponseFetcher();
    }

    public Iterator<DescribeIpamPrefixListResolversResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPrefixListResolver> ipamPrefixListResolvers() {
        Function<DescribeIpamPrefixListResolversResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPrefixListResolvers() != null) {
                return response.ipamPrefixListResolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpamPrefixListResolversResponseFetcher
    implements SyncPageFetcher<DescribeIpamPrefixListResolversResponse> {
        private DescribeIpamPrefixListResolversResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamPrefixListResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpamPrefixListResolversResponse nextPage(DescribeIpamPrefixListResolversResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamPrefixListResolversIterable.this.client.describeIpamPrefixListResolvers(DescribeIpamPrefixListResolversIterable.this.firstRequest);
            }
            return DescribeIpamPrefixListResolversIterable.this.client.describeIpamPrefixListResolvers((DescribeIpamPrefixListResolversRequest)((Object)DescribeIpamPrefixListResolversIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

