/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.services.ec2.model.VpcEncryptionControlConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcRequest> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(CreateVpcRequest.getter(CreateVpcRequest::cidrBlock)).setter(CreateVpcRequest.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("CidrBlock").build()}).build();
    private static final SdkField<String> IPV6_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Pool").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6Pool)).setter(CreateVpcRequest.setter(Builder::ipv6Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Pool").unmarshallLocationName("Ipv6Pool").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6CidrBlock)).setter(CreateVpcRequest.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("Ipv6CidrBlock").build()}).build();
    private static final SdkField<String> IPV4_IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv4IpamPoolId").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv4IpamPoolId)).setter(CreateVpcRequest.setter(Builder::ipv4IpamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4IpamPoolId").unmarshallLocationName("Ipv4IpamPoolId").build()}).build();
    private static final SdkField<Integer> IPV4_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4NetmaskLength").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv4NetmaskLength)).setter(CreateVpcRequest.setter(Builder::ipv4NetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4NetmaskLength").unmarshallLocationName("Ipv4NetmaskLength").build()}).build();
    private static final SdkField<String> IPV6_IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6IpamPoolId").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6IpamPoolId)).setter(CreateVpcRequest.setter(Builder::ipv6IpamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6IpamPoolId").unmarshallLocationName("Ipv6IpamPoolId").build()}).build();
    private static final SdkField<Integer> IPV6_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6NetmaskLength").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6NetmaskLength)).setter(CreateVpcRequest.setter(Builder::ipv6NetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6NetmaskLength").unmarshallLocationName("Ipv6NetmaskLength").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlockNetworkBorderGroup").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6CidrBlockNetworkBorderGroup)).setter(CreateVpcRequest.setter(Builder::ipv6CidrBlockNetworkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockNetworkBorderGroup").unmarshallLocationName("Ipv6CidrBlockNetworkBorderGroup").build()}).build();
    private static final SdkField<VpcEncryptionControlConfiguration> VPC_ENCRYPTION_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcEncryptionControl").getter(CreateVpcRequest.getter(CreateVpcRequest::vpcEncryptionControl)).setter(CreateVpcRequest.setter(Builder::vpcEncryptionControl)).constructor(VpcEncryptionControlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEncryptionControl").unmarshallLocationName("VpcEncryptionControl").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVpcRequest.getter(CreateVpcRequest::tagSpecifications)).setter(CreateVpcRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVpcRequest.getter(CreateVpcRequest::dryRun)).setter(CreateVpcRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceTenancy").getter(CreateVpcRequest.getter(CreateVpcRequest::instanceTenancyAsString)).setter(CreateVpcRequest.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final SdkField<Boolean> AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AmazonProvidedIpv6CidrBlock").getter(CreateVpcRequest.getter(CreateVpcRequest::amazonProvidedIpv6CidrBlock)).setter(CreateVpcRequest.setter(Builder::amazonProvidedIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonProvidedIpv6CidrBlock").unmarshallLocationName("amazonProvidedIpv6CidrBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD, IPV6_POOL_FIELD, IPV6_CIDR_BLOCK_FIELD, IPV4_IPAM_POOL_ID_FIELD, IPV4_NETMASK_LENGTH_FIELD, IPV6_IPAM_POOL_ID_FIELD, IPV6_NETMASK_LENGTH_FIELD, IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD, VPC_ENCRYPTION_CONTROL_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, INSTANCE_TENANCY_FIELD, AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVpcRequest.memberNameToFieldInitializer();
    private final String cidrBlock;
    private final String ipv6Pool;
    private final String ipv6CidrBlock;
    private final String ipv4IpamPoolId;
    private final Integer ipv4NetmaskLength;
    private final String ipv6IpamPoolId;
    private final Integer ipv6NetmaskLength;
    private final String ipv6CidrBlockNetworkBorderGroup;
    private final VpcEncryptionControlConfiguration vpcEncryptionControl;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;
    private final String instanceTenancy;
    private final Boolean amazonProvidedIpv6CidrBlock;

    private CreateVpcRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.ipv6Pool = builder.ipv6Pool;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv4IpamPoolId = builder.ipv4IpamPoolId;
        this.ipv4NetmaskLength = builder.ipv4NetmaskLength;
        this.ipv6IpamPoolId = builder.ipv6IpamPoolId;
        this.ipv6NetmaskLength = builder.ipv6NetmaskLength;
        this.ipv6CidrBlockNetworkBorderGroup = builder.ipv6CidrBlockNetworkBorderGroup;
        this.vpcEncryptionControl = builder.vpcEncryptionControl;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.instanceTenancy = builder.instanceTenancy;
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final String ipv6Pool() {
        return this.ipv6Pool;
    }

    public final String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public final String ipv4IpamPoolId() {
        return this.ipv4IpamPoolId;
    }

    public final Integer ipv4NetmaskLength() {
        return this.ipv4NetmaskLength;
    }

    public final String ipv6IpamPoolId() {
        return this.ipv6IpamPoolId;
    }

    public final Integer ipv6NetmaskLength() {
        return this.ipv6NetmaskLength;
    }

    public final String ipv6CidrBlockNetworkBorderGroup() {
        return this.ipv6CidrBlockNetworkBorderGroup;
    }

    public final VpcEncryptionControlConfiguration vpcEncryptionControl() {
        return this.vpcEncryptionControl;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public final String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public final Boolean amazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockNetworkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEncryptionControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonProvidedIpv6CidrBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest)((Object)obj);
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.ipv6Pool(), other.ipv6Pool()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.ipv4IpamPoolId(), other.ipv4IpamPoolId()) && Objects.equals(this.ipv4NetmaskLength(), other.ipv4NetmaskLength()) && Objects.equals(this.ipv6IpamPoolId(), other.ipv6IpamPoolId()) && Objects.equals(this.ipv6NetmaskLength(), other.ipv6NetmaskLength()) && Objects.equals(this.ipv6CidrBlockNetworkBorderGroup(), other.ipv6CidrBlockNetworkBorderGroup()) && Objects.equals(this.vpcEncryptionControl(), other.vpcEncryptionControl()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcRequest").add("CidrBlock", (Object)this.cidrBlock()).add("Ipv6Pool", (Object)this.ipv6Pool()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("Ipv4IpamPoolId", (Object)this.ipv4IpamPoolId()).add("Ipv4NetmaskLength", (Object)this.ipv4NetmaskLength()).add("Ipv6IpamPoolId", (Object)this.ipv6IpamPoolId()).add("Ipv6NetmaskLength", (Object)this.ipv6NetmaskLength()).add("Ipv6CidrBlockNetworkBorderGroup", (Object)this.ipv6CidrBlockNetworkBorderGroup()).add("VpcEncryptionControl", (Object)this.vpcEncryptionControl()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("AmazonProvidedIpv6CidrBlock", (Object)this.amazonProvidedIpv6CidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6Pool": {
                return Optional.ofNullable(clazz.cast(this.ipv6Pool()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "Ipv4IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipv4IpamPoolId()));
            }
            case "Ipv4NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.ipv4NetmaskLength()));
            }
            case "Ipv6IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipv6IpamPoolId()));
            }
            case "Ipv6NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.ipv6NetmaskLength()));
            }
            case "Ipv6CidrBlockNetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockNetworkBorderGroup()));
            }
            case "VpcEncryptionControl": {
                return Optional.ofNullable(clazz.cast(this.vpcEncryptionControl()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
            case "AmazonProvidedIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.amazonProvidedIpv6CidrBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CidrBlock", CIDR_BLOCK_FIELD);
        map.put("Ipv6Pool", IPV6_POOL_FIELD);
        map.put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
        map.put("Ipv4IpamPoolId", IPV4_IPAM_POOL_ID_FIELD);
        map.put("Ipv4NetmaskLength", IPV4_NETMASK_LENGTH_FIELD);
        map.put("Ipv6IpamPoolId", IPV6_IPAM_POOL_ID_FIELD);
        map.put("Ipv6NetmaskLength", IPV6_NETMASK_LENGTH_FIELD);
        map.put("Ipv6CidrBlockNetworkBorderGroup", IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD);
        map.put("VpcEncryptionControl", VPC_ENCRYPTION_CONTROL_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceTenancy", INSTANCE_TENANCY_FIELD);
        map.put("AmazonProvidedIpv6CidrBlock", AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcRequest, T> g) {
        return obj -> g.apply((CreateVpcRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String cidrBlock;
        private String ipv6Pool;
        private String ipv6CidrBlock;
        private String ipv4IpamPoolId;
        private Integer ipv4NetmaskLength;
        private String ipv6IpamPoolId;
        private Integer ipv6NetmaskLength;
        private String ipv6CidrBlockNetworkBorderGroup;
        private VpcEncryptionControlConfiguration vpcEncryptionControl;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private String instanceTenancy;
        private Boolean amazonProvidedIpv6CidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcRequest model) {
            super(model);
            this.cidrBlock(model.cidrBlock);
            this.ipv6Pool(model.ipv6Pool);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.ipv4IpamPoolId(model.ipv4IpamPoolId);
            this.ipv4NetmaskLength(model.ipv4NetmaskLength);
            this.ipv6IpamPoolId(model.ipv6IpamPoolId);
            this.ipv6NetmaskLength(model.ipv6NetmaskLength);
            this.ipv6CidrBlockNetworkBorderGroup(model.ipv6CidrBlockNetworkBorderGroup);
            this.vpcEncryptionControl(model.vpcEncryptionControl);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
            this.instanceTenancy(model.instanceTenancy);
            this.amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getIpv6Pool() {
            return this.ipv6Pool;
        }

        public final void setIpv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
        }

        @Override
        public final Builder ipv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final String getIpv4IpamPoolId() {
            return this.ipv4IpamPoolId;
        }

        public final void setIpv4IpamPoolId(String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
        }

        @Override
        public final Builder ipv4IpamPoolId(String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        public final Integer getIpv4NetmaskLength() {
            return this.ipv4NetmaskLength;
        }

        public final void setIpv4NetmaskLength(Integer ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
        }

        @Override
        public final Builder ipv4NetmaskLength(Integer ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
            return this;
        }

        public final String getIpv6IpamPoolId() {
            return this.ipv6IpamPoolId;
        }

        public final void setIpv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
        }

        @Override
        public final Builder ipv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
            return this;
        }

        public final Integer getIpv6NetmaskLength() {
            return this.ipv6NetmaskLength;
        }

        public final void setIpv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
        }

        @Override
        public final Builder ipv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
            return this;
        }

        public final String getIpv6CidrBlockNetworkBorderGroup() {
            return this.ipv6CidrBlockNetworkBorderGroup;
        }

        public final void setIpv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
        }

        @Override
        public final Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
            return this;
        }

        public final VpcEncryptionControlConfiguration.Builder getVpcEncryptionControl() {
            return this.vpcEncryptionControl != null ? this.vpcEncryptionControl.toBuilder() : null;
        }

        public final void setVpcEncryptionControl(VpcEncryptionControlConfiguration.BuilderImpl vpcEncryptionControl) {
            this.vpcEncryptionControl = vpcEncryptionControl != null ? vpcEncryptionControl.build() : null;
        }

        @Override
        public final Builder vpcEncryptionControl(VpcEncryptionControlConfiguration vpcEncryptionControl) {
            this.vpcEncryptionControl = vpcEncryptionControl;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return this.amazonProvidedIpv6CidrBlock;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcRequest build() {
            return new CreateVpcRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcRequest> {
        public Builder cidrBlock(String var1);

        public Builder ipv6Pool(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder ipv4IpamPoolId(String var1);

        public Builder ipv4NetmaskLength(Integer var1);

        public Builder ipv6IpamPoolId(String var1);

        public Builder ipv6NetmaskLength(Integer var1);

        public Builder ipv6CidrBlockNetworkBorderGroup(String var1);

        public Builder vpcEncryptionControl(VpcEncryptionControlConfiguration var1);

        default public Builder vpcEncryptionControl(Consumer<VpcEncryptionControlConfiguration.Builder> vpcEncryptionControl) {
            return this.vpcEncryptionControl((VpcEncryptionControlConfiguration)((VpcEncryptionControlConfiguration.Builder)VpcEncryptionControlConfiguration.builder().applyMutation(vpcEncryptionControl)).build());
        }

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder amazonProvidedIpv6CidrBlock(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

