/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConcentratorsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConcentratorsResponse;
import software.amazon.awssdk.services.ec2.model.VpnConcentrator;

public class DescribeVpnConcentratorsIterable
implements SdkIterable<DescribeVpnConcentratorsResponse> {
    private final Ec2Client client;
    private final DescribeVpnConcentratorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpnConcentratorsIterable(Ec2Client client, DescribeVpnConcentratorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVpnConcentratorsResponseFetcher();
    }

    public Iterator<DescribeVpnConcentratorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpnConcentrator> vpnConcentrators() {
        Function<DescribeVpnConcentratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpnConcentrators() != null) {
                return response.vpnConcentrators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpnConcentratorsResponseFetcher
    implements SyncPageFetcher<DescribeVpnConcentratorsResponse> {
        private DescribeVpnConcentratorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpnConcentratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpnConcentratorsResponse nextPage(DescribeVpnConcentratorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpnConcentratorsIterable.this.client.describeVpnConcentrators(DescribeVpnConcentratorsIterable.this.firstRequest);
            }
            return DescribeVpnConcentratorsIterable.this.client.describeVpnConcentrators((DescribeVpnConcentratorsRequest)((Object)DescribeVpnConcentratorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

