/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddress;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateNatGatewayAddressResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DisassociateNatGatewayAddressResponse> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(DisassociateNatGatewayAddressResponse.getter(DisassociateNatGatewayAddressResponse::natGatewayId)).setter(DisassociateNatGatewayAddressResponse.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("natGatewayId").build()}).build();
    private static final SdkField<List<NatGatewayAddress>> NAT_GATEWAY_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NatGatewayAddresses").getter(DisassociateNatGatewayAddressResponse.getter(DisassociateNatGatewayAddressResponse::natGatewayAddresses)).setter(DisassociateNatGatewayAddressResponse.setter(Builder::natGatewayAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayAddressSet").unmarshallLocationName("natGatewayAddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NatGatewayAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD, NAT_GATEWAY_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateNatGatewayAddressResponse.memberNameToFieldInitializer();
    private final String natGatewayId;
    private final List<NatGatewayAddress> natGatewayAddresses;

    private DisassociateNatGatewayAddressResponse(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.natGatewayAddresses = builder.natGatewayAddresses;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final boolean hasNatGatewayAddresses() {
        return this.natGatewayAddresses != null && !(this.natGatewayAddresses instanceof SdkAutoConstructList);
    }

    public final List<NatGatewayAddress> natGatewayAddresses() {
        return this.natGatewayAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNatGatewayAddresses() ? this.natGatewayAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateNatGatewayAddressResponse)) {
            return false;
        }
        DisassociateNatGatewayAddressResponse other = (DisassociateNatGatewayAddressResponse)((Object)obj);
        return Objects.equals(this.natGatewayId(), other.natGatewayId()) && this.hasNatGatewayAddresses() == other.hasNatGatewayAddresses() && Objects.equals(this.natGatewayAddresses(), other.natGatewayAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateNatGatewayAddressResponse").add("NatGatewayId", (Object)this.natGatewayId()).add("NatGatewayAddresses", this.hasNatGatewayAddresses() ? this.natGatewayAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "NatGatewayAddresses": {
                return Optional.ofNullable(clazz.cast(this.natGatewayAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("NatGatewayAddressSet", NAT_GATEWAY_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateNatGatewayAddressResponse, T> g) {
        return obj -> g.apply((DisassociateNatGatewayAddressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String natGatewayId;
        private List<NatGatewayAddress> natGatewayAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateNatGatewayAddressResponse model) {
            super(model);
            this.natGatewayId(model.natGatewayId);
            this.natGatewayAddresses(model.natGatewayAddresses);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final List<NatGatewayAddress.Builder> getNatGatewayAddresses() {
            List<NatGatewayAddress.Builder> result = NatGatewayAddressListCopier.copyToBuilder(this.natGatewayAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNatGatewayAddresses(Collection<NatGatewayAddress.BuilderImpl> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copyFromBuilder(natGatewayAddresses);
        }

        @Override
        public final Builder natGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copy(natGatewayAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(NatGatewayAddress ... natGatewayAddresses) {
            this.natGatewayAddresses(Arrays.asList(natGatewayAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder> ... natGatewayAddresses) {
            this.natGatewayAddresses(Stream.of(natGatewayAddresses).map(c -> (NatGatewayAddress)((NatGatewayAddress.Builder)NatGatewayAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisassociateNatGatewayAddressResponse build() {
            return new DisassociateNatGatewayAddressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateNatGatewayAddressResponse> {
        public Builder natGatewayId(String var1);

        public Builder natGatewayAddresses(Collection<NatGatewayAddress> var1);

        public Builder natGatewayAddresses(NatGatewayAddress ... var1);

        public Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder> ... var1);
    }
}

