/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VpcEndpointType {
    INTERFACE("Interface"),
    GATEWAY("Gateway"),
    GATEWAY_LOAD_BALANCER("GatewayLoadBalancer"),
    RESOURCE("Resource"),
    SERVICE_NETWORK("ServiceNetwork"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VpcEndpointType> VALUE_MAP;
    private final String value;

    private VpcEndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VpcEndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VpcEndpointType> knownValues() {
        EnumSet<VpcEndpointType> knownValues = EnumSet.allOf(VpcEndpointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VpcEndpointType.class, VpcEndpointType::toString);
    }
}

