/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityTenancy;
import software.amazon.awssdk.services.ec2.model.ReservationEndDateType;
import software.amazon.awssdk.services.ec2.model.ReservationState;
import software.amazon.awssdk.services.ec2.model.ReservationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityManagerDimension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityManagerDimension> {
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(CapacityManagerDimension.getter(CapacityManagerDimension::resourceRegion)).setter(CapacityManagerDimension.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("resourceRegion").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CapacityManagerDimension.getter(CapacityManagerDimension::availabilityZoneId)).setter(CapacityManagerDimension.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CapacityManagerDimension.getter(CapacityManagerDimension::accountId)).setter(CapacityManagerDimension.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").unmarshallLocationName("accountId").build()}).build();
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(CapacityManagerDimension.getter(CapacityManagerDimension::instanceFamily)).setter(CapacityManagerDimension.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("instanceFamily").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CapacityManagerDimension.getter(CapacityManagerDimension::instanceType)).setter(CapacityManagerDimension.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstancePlatform").getter(CapacityManagerDimension.getter(CapacityManagerDimension::instancePlatform)).setter(CapacityManagerDimension.setter(Builder::instancePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform").unmarshallLocationName("instancePlatform").build()}).build();
    private static final SdkField<String> RESERVATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationArn").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationArn)).setter(CapacityManagerDimension.setter(Builder::reservationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationArn").unmarshallLocationName("reservationArn").build()}).build();
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationId").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationId)).setter(CapacityManagerDimension.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationId").unmarshallLocationName("reservationId").build()}).build();
    private static final SdkField<String> RESERVATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationType").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationTypeAsString)).setter(CapacityManagerDimension.setter(Builder::reservationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationType").unmarshallLocationName("reservationType").build()}).build();
    private static final SdkField<Instant> RESERVATION_CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReservationCreateTimestamp").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationCreateTimestamp)).setter(CapacityManagerDimension.setter(Builder::reservationCreateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationCreateTimestamp").unmarshallLocationName("reservationCreateTimestamp").build()}).build();
    private static final SdkField<Instant> RESERVATION_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReservationStartTimestamp").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationStartTimestamp)).setter(CapacityManagerDimension.setter(Builder::reservationStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationStartTimestamp").unmarshallLocationName("reservationStartTimestamp").build()}).build();
    private static final SdkField<Instant> RESERVATION_END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReservationEndTimestamp").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationEndTimestamp)).setter(CapacityManagerDimension.setter(Builder::reservationEndTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationEndTimestamp").unmarshallLocationName("reservationEndTimestamp").build()}).build();
    private static final SdkField<String> RESERVATION_END_DATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationEndDateType").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationEndDateTypeAsString)).setter(CapacityManagerDimension.setter(Builder::reservationEndDateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationEndDateType").unmarshallLocationName("reservationEndDateType").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CapacityManagerDimension.getter(CapacityManagerDimension::tenancyAsString)).setter(CapacityManagerDimension.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<String> RESERVATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationState").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationStateAsString)).setter(CapacityManagerDimension.setter(Builder::reservationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationState").unmarshallLocationName("reservationState").build()}).build();
    private static final SdkField<String> RESERVATION_INSTANCE_MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationInstanceMatchCriteria").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationInstanceMatchCriteria)).setter(CapacityManagerDimension.setter(Builder::reservationInstanceMatchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationInstanceMatchCriteria").unmarshallLocationName("reservationInstanceMatchCriteria").build()}).build();
    private static final SdkField<String> RESERVATION_UNUSED_FINANCIAL_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationUnusedFinancialOwner").getter(CapacityManagerDimension.getter(CapacityManagerDimension::reservationUnusedFinancialOwner)).setter(CapacityManagerDimension.setter(Builder::reservationUnusedFinancialOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationUnusedFinancialOwner").unmarshallLocationName("reservationUnusedFinancialOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_REGION_FIELD, AVAILABILITY_ZONE_ID_FIELD, ACCOUNT_ID_FIELD, INSTANCE_FAMILY_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, RESERVATION_ARN_FIELD, RESERVATION_ID_FIELD, RESERVATION_TYPE_FIELD, RESERVATION_CREATE_TIMESTAMP_FIELD, RESERVATION_START_TIMESTAMP_FIELD, RESERVATION_END_TIMESTAMP_FIELD, RESERVATION_END_DATE_TYPE_FIELD, TENANCY_FIELD, RESERVATION_STATE_FIELD, RESERVATION_INSTANCE_MATCH_CRITERIA_FIELD, RESERVATION_UNUSED_FINANCIAL_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityManagerDimension.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceRegion;
    private final String availabilityZoneId;
    private final String accountId;
    private final String instanceFamily;
    private final String instanceType;
    private final String instancePlatform;
    private final String reservationArn;
    private final String reservationId;
    private final String reservationType;
    private final Instant reservationCreateTimestamp;
    private final Instant reservationStartTimestamp;
    private final Instant reservationEndTimestamp;
    private final String reservationEndDateType;
    private final String tenancy;
    private final String reservationState;
    private final String reservationInstanceMatchCriteria;
    private final String reservationUnusedFinancialOwner;

    private CapacityManagerDimension(BuilderImpl builder) {
        this.resourceRegion = builder.resourceRegion;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.accountId = builder.accountId;
        this.instanceFamily = builder.instanceFamily;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.reservationArn = builder.reservationArn;
        this.reservationId = builder.reservationId;
        this.reservationType = builder.reservationType;
        this.reservationCreateTimestamp = builder.reservationCreateTimestamp;
        this.reservationStartTimestamp = builder.reservationStartTimestamp;
        this.reservationEndTimestamp = builder.reservationEndTimestamp;
        this.reservationEndDateType = builder.reservationEndDateType;
        this.tenancy = builder.tenancy;
        this.reservationState = builder.reservationState;
        this.reservationInstanceMatchCriteria = builder.reservationInstanceMatchCriteria;
        this.reservationUnusedFinancialOwner = builder.reservationUnusedFinancialOwner;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String instanceFamily() {
        return this.instanceFamily;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String instancePlatform() {
        return this.instancePlatform;
    }

    public final String reservationArn() {
        return this.reservationArn;
    }

    public final String reservationId() {
        return this.reservationId;
    }

    public final ReservationType reservationType() {
        return ReservationType.fromValue(this.reservationType);
    }

    public final String reservationTypeAsString() {
        return this.reservationType;
    }

    public final Instant reservationCreateTimestamp() {
        return this.reservationCreateTimestamp;
    }

    public final Instant reservationStartTimestamp() {
        return this.reservationStartTimestamp;
    }

    public final Instant reservationEndTimestamp() {
        return this.reservationEndTimestamp;
    }

    public final ReservationEndDateType reservationEndDateType() {
        return ReservationEndDateType.fromValue(this.reservationEndDateType);
    }

    public final String reservationEndDateTypeAsString() {
        return this.reservationEndDateType;
    }

    public final CapacityTenancy tenancy() {
        return CapacityTenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final ReservationState reservationState() {
        return ReservationState.fromValue(this.reservationState);
    }

    public final String reservationStateAsString() {
        return this.reservationState;
    }

    public final String reservationInstanceMatchCriteria() {
        return this.reservationInstanceMatchCriteria;
    }

    public final String reservationUnusedFinancialOwner() {
        return this.reservationUnusedFinancialOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationCreateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationEndTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationEndDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationInstanceMatchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationUnusedFinancialOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityManagerDimension)) {
            return false;
        }
        CapacityManagerDimension other = (CapacityManagerDimension)obj;
        return Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.instanceFamily(), other.instanceFamily()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instancePlatform(), other.instancePlatform()) && Objects.equals(this.reservationArn(), other.reservationArn()) && Objects.equals(this.reservationId(), other.reservationId()) && Objects.equals(this.reservationTypeAsString(), other.reservationTypeAsString()) && Objects.equals(this.reservationCreateTimestamp(), other.reservationCreateTimestamp()) && Objects.equals(this.reservationStartTimestamp(), other.reservationStartTimestamp()) && Objects.equals(this.reservationEndTimestamp(), other.reservationEndTimestamp()) && Objects.equals(this.reservationEndDateTypeAsString(), other.reservationEndDateTypeAsString()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.reservationStateAsString(), other.reservationStateAsString()) && Objects.equals(this.reservationInstanceMatchCriteria(), other.reservationInstanceMatchCriteria()) && Objects.equals(this.reservationUnusedFinancialOwner(), other.reservationUnusedFinancialOwner());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityManagerDimension").add("ResourceRegion", (Object)this.resourceRegion()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AccountId", (Object)this.accountId()).add("InstanceFamily", (Object)this.instanceFamily()).add("InstanceType", (Object)this.instanceType()).add("InstancePlatform", (Object)this.instancePlatform()).add("ReservationArn", (Object)this.reservationArn()).add("ReservationId", (Object)this.reservationId()).add("ReservationType", (Object)this.reservationTypeAsString()).add("ReservationCreateTimestamp", (Object)this.reservationCreateTimestamp()).add("ReservationStartTimestamp", (Object)this.reservationStartTimestamp()).add("ReservationEndTimestamp", (Object)this.reservationEndTimestamp()).add("ReservationEndDateType", (Object)this.reservationEndDateTypeAsString()).add("Tenancy", (Object)this.tenancyAsString()).add("ReservationState", (Object)this.reservationStateAsString()).add("ReservationInstanceMatchCriteria", (Object)this.reservationInstanceMatchCriteria()).add("ReservationUnusedFinancialOwner", (Object)this.reservationUnusedFinancialOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstancePlatform": {
                return Optional.ofNullable(clazz.cast(this.instancePlatform()));
            }
            case "ReservationArn": {
                return Optional.ofNullable(clazz.cast(this.reservationArn()));
            }
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
            case "ReservationType": {
                return Optional.ofNullable(clazz.cast(this.reservationTypeAsString()));
            }
            case "ReservationCreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.reservationCreateTimestamp()));
            }
            case "ReservationStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.reservationStartTimestamp()));
            }
            case "ReservationEndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.reservationEndTimestamp()));
            }
            case "ReservationEndDateType": {
                return Optional.ofNullable(clazz.cast(this.reservationEndDateTypeAsString()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "ReservationState": {
                return Optional.ofNullable(clazz.cast(this.reservationStateAsString()));
            }
            case "ReservationInstanceMatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.reservationInstanceMatchCriteria()));
            }
            case "ReservationUnusedFinancialOwner": {
                return Optional.ofNullable(clazz.cast(this.reservationUnusedFinancialOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceRegion", RESOURCE_REGION_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("InstanceFamily", INSTANCE_FAMILY_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
        map.put("ReservationArn", RESERVATION_ARN_FIELD);
        map.put("ReservationId", RESERVATION_ID_FIELD);
        map.put("ReservationType", RESERVATION_TYPE_FIELD);
        map.put("ReservationCreateTimestamp", RESERVATION_CREATE_TIMESTAMP_FIELD);
        map.put("ReservationStartTimestamp", RESERVATION_START_TIMESTAMP_FIELD);
        map.put("ReservationEndTimestamp", RESERVATION_END_TIMESTAMP_FIELD);
        map.put("ReservationEndDateType", RESERVATION_END_DATE_TYPE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("ReservationState", RESERVATION_STATE_FIELD);
        map.put("ReservationInstanceMatchCriteria", RESERVATION_INSTANCE_MATCH_CRITERIA_FIELD);
        map.put("ReservationUnusedFinancialOwner", RESERVATION_UNUSED_FINANCIAL_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityManagerDimension, T> g) {
        return obj -> g.apply((CapacityManagerDimension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceRegion;
        private String availabilityZoneId;
        private String accountId;
        private String instanceFamily;
        private String instanceType;
        private String instancePlatform;
        private String reservationArn;
        private String reservationId;
        private String reservationType;
        private Instant reservationCreateTimestamp;
        private Instant reservationStartTimestamp;
        private Instant reservationEndTimestamp;
        private String reservationEndDateType;
        private String tenancy;
        private String reservationState;
        private String reservationInstanceMatchCriteria;
        private String reservationUnusedFinancialOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityManagerDimension model) {
            this.resourceRegion(model.resourceRegion);
            this.availabilityZoneId(model.availabilityZoneId);
            this.accountId(model.accountId);
            this.instanceFamily(model.instanceFamily);
            this.instanceType(model.instanceType);
            this.instancePlatform(model.instancePlatform);
            this.reservationArn(model.reservationArn);
            this.reservationId(model.reservationId);
            this.reservationType(model.reservationType);
            this.reservationCreateTimestamp(model.reservationCreateTimestamp);
            this.reservationStartTimestamp(model.reservationStartTimestamp);
            this.reservationEndTimestamp(model.reservationEndTimestamp);
            this.reservationEndDateType(model.reservationEndDateType);
            this.tenancy(model.tenancy);
            this.reservationState(model.reservationState);
            this.reservationInstanceMatchCriteria(model.reservationInstanceMatchCriteria);
            this.reservationUnusedFinancialOwner(model.reservationUnusedFinancialOwner);
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstancePlatform() {
            return this.instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        public final String getReservationArn() {
            return this.reservationArn;
        }

        public final void setReservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
        }

        @Override
        public final Builder reservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
            return this;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final String getReservationType() {
            return this.reservationType;
        }

        public final void setReservationType(String reservationType) {
            this.reservationType = reservationType;
        }

        @Override
        public final Builder reservationType(String reservationType) {
            this.reservationType = reservationType;
            return this;
        }

        @Override
        public final Builder reservationType(ReservationType reservationType) {
            this.reservationType(reservationType == null ? null : reservationType.toString());
            return this;
        }

        public final Instant getReservationCreateTimestamp() {
            return this.reservationCreateTimestamp;
        }

        public final void setReservationCreateTimestamp(Instant reservationCreateTimestamp) {
            this.reservationCreateTimestamp = reservationCreateTimestamp;
        }

        @Override
        public final Builder reservationCreateTimestamp(Instant reservationCreateTimestamp) {
            this.reservationCreateTimestamp = reservationCreateTimestamp;
            return this;
        }

        public final Instant getReservationStartTimestamp() {
            return this.reservationStartTimestamp;
        }

        public final void setReservationStartTimestamp(Instant reservationStartTimestamp) {
            this.reservationStartTimestamp = reservationStartTimestamp;
        }

        @Override
        public final Builder reservationStartTimestamp(Instant reservationStartTimestamp) {
            this.reservationStartTimestamp = reservationStartTimestamp;
            return this;
        }

        public final Instant getReservationEndTimestamp() {
            return this.reservationEndTimestamp;
        }

        public final void setReservationEndTimestamp(Instant reservationEndTimestamp) {
            this.reservationEndTimestamp = reservationEndTimestamp;
        }

        @Override
        public final Builder reservationEndTimestamp(Instant reservationEndTimestamp) {
            this.reservationEndTimestamp = reservationEndTimestamp;
            return this;
        }

        public final String getReservationEndDateType() {
            return this.reservationEndDateType;
        }

        public final void setReservationEndDateType(String reservationEndDateType) {
            this.reservationEndDateType = reservationEndDateType;
        }

        @Override
        public final Builder reservationEndDateType(String reservationEndDateType) {
            this.reservationEndDateType = reservationEndDateType;
            return this;
        }

        @Override
        public final Builder reservationEndDateType(ReservationEndDateType reservationEndDateType) {
            this.reservationEndDateType(reservationEndDateType == null ? null : reservationEndDateType.toString());
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final String getReservationState() {
            return this.reservationState;
        }

        public final void setReservationState(String reservationState) {
            this.reservationState = reservationState;
        }

        @Override
        public final Builder reservationState(String reservationState) {
            this.reservationState = reservationState;
            return this;
        }

        @Override
        public final Builder reservationState(ReservationState reservationState) {
            this.reservationState(reservationState == null ? null : reservationState.toString());
            return this;
        }

        public final String getReservationInstanceMatchCriteria() {
            return this.reservationInstanceMatchCriteria;
        }

        public final void setReservationInstanceMatchCriteria(String reservationInstanceMatchCriteria) {
            this.reservationInstanceMatchCriteria = reservationInstanceMatchCriteria;
        }

        @Override
        public final Builder reservationInstanceMatchCriteria(String reservationInstanceMatchCriteria) {
            this.reservationInstanceMatchCriteria = reservationInstanceMatchCriteria;
            return this;
        }

        public final String getReservationUnusedFinancialOwner() {
            return this.reservationUnusedFinancialOwner;
        }

        public final void setReservationUnusedFinancialOwner(String reservationUnusedFinancialOwner) {
            this.reservationUnusedFinancialOwner = reservationUnusedFinancialOwner;
        }

        @Override
        public final Builder reservationUnusedFinancialOwner(String reservationUnusedFinancialOwner) {
            this.reservationUnusedFinancialOwner = reservationUnusedFinancialOwner;
            return this;
        }

        public CapacityManagerDimension build() {
            return new CapacityManagerDimension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityManagerDimension> {
        public Builder resourceRegion(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder accountId(String var1);

        public Builder instanceFamily(String var1);

        public Builder instanceType(String var1);

        public Builder instancePlatform(String var1);

        public Builder reservationArn(String var1);

        public Builder reservationId(String var1);

        public Builder reservationType(String var1);

        public Builder reservationType(ReservationType var1);

        public Builder reservationCreateTimestamp(Instant var1);

        public Builder reservationStartTimestamp(Instant var1);

        public Builder reservationEndTimestamp(Instant var1);

        public Builder reservationEndDateType(String var1);

        public Builder reservationEndDateType(ReservationEndDateType var1);

        public Builder tenancy(String var1);

        public Builder tenancy(CapacityTenancy var1);

        public Builder reservationState(String var1);

        public Builder reservationState(ReservationState var1);

        public Builder reservationInstanceMatchCriteria(String var1);

        public Builder reservationUnusedFinancialOwner(String var1);
    }
}

