/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVerifiedAccessTrustProviderRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVerifiedAccessTrustProviderRequest.Builder, CreateVerifiedAccessTrustProviderRequest> {
    private static final SdkField<String> TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrustProviderType")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::trustProviderTypeAsString))
            .setter(setter(Builder::trustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustProviderType")
                    .unmarshallLocationName("TrustProviderType").build()).build();

    private static final SdkField<String> USER_TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserTrustProviderType")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::userTrustProviderTypeAsString))
            .setter(setter(Builder::userTrustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTrustProviderType")
                    .unmarshallLocationName("UserTrustProviderType").build()).build();

    private static final SdkField<String> DEVICE_TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceTrustProviderType")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::deviceTrustProviderTypeAsString))
            .setter(setter(Builder::deviceTrustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTrustProviderType")
                    .unmarshallLocationName("DeviceTrustProviderType").build()).build();

    private static final SdkField<CreateVerifiedAccessTrustProviderOidcOptions> OIDC_OPTIONS_FIELD = SdkField
            .<CreateVerifiedAccessTrustProviderOidcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("OidcOptions")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::oidcOptions))
            .setter(setter(Builder::oidcOptions))
            .constructor(CreateVerifiedAccessTrustProviderOidcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcOptions")
                    .unmarshallLocationName("OidcOptions").build()).build();

    private static final SdkField<CreateVerifiedAccessTrustProviderDeviceOptions> DEVICE_OPTIONS_FIELD = SdkField
            .<CreateVerifiedAccessTrustProviderDeviceOptions> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceOptions")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::deviceOptions))
            .setter(setter(Builder::deviceOptions))
            .constructor(CreateVerifiedAccessTrustProviderDeviceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOptions")
                    .unmarshallLocationName("DeviceOptions").build()).build();

    private static final SdkField<String> POLICY_REFERENCE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyReferenceName")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::policyReferenceName))
            .setter(setter(Builder::policyReferenceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReferenceName")
                    .unmarshallLocationName("PolicyReferenceName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<VerifiedAccessSseSpecificationRequest> SSE_SPECIFICATION_FIELD = SdkField
            .<VerifiedAccessSseSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("SseSpecification")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::sseSpecification))
            .setter(setter(Builder::sseSpecification))
            .constructor(VerifiedAccessSseSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification")
                    .unmarshallLocationName("SseSpecification").build()).build();

    private static final SdkField<CreateVerifiedAccessNativeApplicationOidcOptions> NATIVE_APPLICATION_OIDC_OPTIONS_FIELD = SdkField
            .<CreateVerifiedAccessNativeApplicationOidcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("NativeApplicationOidcOptions")
            .getter(getter(CreateVerifiedAccessTrustProviderRequest::nativeApplicationOidcOptions))
            .setter(setter(Builder::nativeApplicationOidcOptions))
            .constructor(CreateVerifiedAccessNativeApplicationOidcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NativeApplicationOidcOptions")
                    .unmarshallLocationName("NativeApplicationOidcOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_PROVIDER_TYPE_FIELD,
            USER_TRUST_PROVIDER_TYPE_FIELD, DEVICE_TRUST_PROVIDER_TYPE_FIELD, OIDC_OPTIONS_FIELD, DEVICE_OPTIONS_FIELD,
            POLICY_REFERENCE_NAME_FIELD, DESCRIPTION_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD,
            SSE_SPECIFICATION_FIELD, NATIVE_APPLICATION_OIDC_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trustProviderType;

    private final String userTrustProviderType;

    private final String deviceTrustProviderType;

    private final CreateVerifiedAccessTrustProviderOidcOptions oidcOptions;

    private final CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions;

    private final String policyReferenceName;

    private final String description;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private final Boolean dryRun;

    private final VerifiedAccessSseSpecificationRequest sseSpecification;

    private final CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions;

    private CreateVerifiedAccessTrustProviderRequest(BuilderImpl builder) {
        super(builder);
        this.trustProviderType = builder.trustProviderType;
        this.userTrustProviderType = builder.userTrustProviderType;
        this.deviceTrustProviderType = builder.deviceTrustProviderType;
        this.oidcOptions = builder.oidcOptions;
        this.deviceOptions = builder.deviceOptions;
        this.policyReferenceName = builder.policyReferenceName;
        this.description = builder.description;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.sseSpecification = builder.sseSpecification;
        this.nativeApplicationOidcOptions = builder.nativeApplicationOidcOptions;
    }

    /**
     * <p>
     * The type of trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustProviderType}
     * will return {@link TrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of trust provider.
     * @see TrustProviderType
     */
    public final TrustProviderType trustProviderType() {
        return TrustProviderType.fromValue(trustProviderType);
    }

    /**
     * <p>
     * The type of trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustProviderType}
     * will return {@link TrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of trust provider.
     * @see TrustProviderType
     */
    public final String trustProviderTypeAsString() {
        return trustProviderType;
    }

    /**
     * <p>
     * The type of user-based trust provider. This parameter is required when the provider type is <code>user</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userTrustProviderType} will return {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of user-based trust provider. This parameter is required when the provider type is
     *         <code>user</code>.
     * @see UserTrustProviderType
     */
    public final UserTrustProviderType userTrustProviderType() {
        return UserTrustProviderType.fromValue(userTrustProviderType);
    }

    /**
     * <p>
     * The type of user-based trust provider. This parameter is required when the provider type is <code>user</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userTrustProviderType} will return {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of user-based trust provider. This parameter is required when the provider type is
     *         <code>user</code>.
     * @see UserTrustProviderType
     */
    public final String userTrustProviderTypeAsString() {
        return userTrustProviderType;
    }

    /**
     * <p>
     * The type of device-based trust provider. This parameter is required when the provider type is <code>device</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTrustProviderType} will return {@link DeviceTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of device-based trust provider. This parameter is required when the provider type is
     *         <code>device</code>.
     * @see DeviceTrustProviderType
     */
    public final DeviceTrustProviderType deviceTrustProviderType() {
        return DeviceTrustProviderType.fromValue(deviceTrustProviderType);
    }

    /**
     * <p>
     * The type of device-based trust provider. This parameter is required when the provider type is <code>device</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTrustProviderType} will return {@link DeviceTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of device-based trust provider. This parameter is required when the provider type is
     *         <code>device</code>.
     * @see DeviceTrustProviderType
     */
    public final String deviceTrustProviderTypeAsString() {
        return deviceTrustProviderType;
    }

    /**
     * <p>
     * The options for a OpenID Connect-compatible user-identity trust provider. This parameter is required when the
     * provider type is <code>user</code>.
     * </p>
     * 
     * @return The options for a OpenID Connect-compatible user-identity trust provider. This parameter is required when
     *         the provider type is <code>user</code>.
     */
    public final CreateVerifiedAccessTrustProviderOidcOptions oidcOptions() {
        return oidcOptions;
    }

    /**
     * <p>
     * The options for a device-based trust provider. This parameter is required when the provider type is
     * <code>device</code>.
     * </p>
     * 
     * @return The options for a device-based trust provider. This parameter is required when the provider type is
     *         <code>device</code>.
     */
    public final CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions() {
        return deviceOptions;
    }

    /**
     * <p>
     * The identifier to be used when working with policy rules.
     * </p>
     * 
     * @return The identifier to be used when working with policy rules.
     */
    public final String policyReferenceName() {
        return policyReferenceName;
    }

    /**
     * <p>
     * A description for the Verified Access trust provider.
     * </p>
     * 
     * @return A description for the Verified Access trust provider.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the Verified Access trust provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to assign to the Verified Access trust provider.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The options for server side encryption.
     * </p>
     * 
     * @return The options for server side encryption.
     */
    public final VerifiedAccessSseSpecificationRequest sseSpecification() {
        return sseSpecification;
    }

    /**
     * <p>
     * The OpenID Connect (OIDC) options.
     * </p>
     * 
     * @return The OpenID Connect (OIDC) options.
     */
    public final CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions() {
        return nativeApplicationOidcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oidcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(deviceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(policyReferenceName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(nativeApplicationOidcOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessTrustProviderRequest)) {
            return false;
        }
        CreateVerifiedAccessTrustProviderRequest other = (CreateVerifiedAccessTrustProviderRequest) obj;
        return Objects.equals(trustProviderTypeAsString(), other.trustProviderTypeAsString())
                && Objects.equals(userTrustProviderTypeAsString(), other.userTrustProviderTypeAsString())
                && Objects.equals(deviceTrustProviderTypeAsString(), other.deviceTrustProviderTypeAsString())
                && Objects.equals(oidcOptions(), other.oidcOptions()) && Objects.equals(deviceOptions(), other.deviceOptions())
                && Objects.equals(policyReferenceName(), other.policyReferenceName())
                && Objects.equals(description(), other.description()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(sseSpecification(), other.sseSpecification())
                && Objects.equals(nativeApplicationOidcOptions(), other.nativeApplicationOidcOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVerifiedAccessTrustProviderRequest").add("TrustProviderType", trustProviderTypeAsString())
                .add("UserTrustProviderType", userTrustProviderTypeAsString())
                .add("DeviceTrustProviderType", deviceTrustProviderTypeAsString()).add("OidcOptions", oidcOptions())
                .add("DeviceOptions", deviceOptions()).add("PolicyReferenceName", policyReferenceName())
                .add("Description", description()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("ClientToken", clientToken()).add("DryRun", dryRun()).add("SseSpecification", sseSpecification())
                .add("NativeApplicationOidcOptions", nativeApplicationOidcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustProviderType":
            return Optional.ofNullable(clazz.cast(trustProviderTypeAsString()));
        case "UserTrustProviderType":
            return Optional.ofNullable(clazz.cast(userTrustProviderTypeAsString()));
        case "DeviceTrustProviderType":
            return Optional.ofNullable(clazz.cast(deviceTrustProviderTypeAsString()));
        case "OidcOptions":
            return Optional.ofNullable(clazz.cast(oidcOptions()));
        case "DeviceOptions":
            return Optional.ofNullable(clazz.cast(deviceOptions()));
        case "PolicyReferenceName":
            return Optional.ofNullable(clazz.cast(policyReferenceName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "SseSpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        case "NativeApplicationOidcOptions":
            return Optional.ofNullable(clazz.cast(nativeApplicationOidcOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustProviderType", TRUST_PROVIDER_TYPE_FIELD);
        map.put("UserTrustProviderType", USER_TRUST_PROVIDER_TYPE_FIELD);
        map.put("DeviceTrustProviderType", DEVICE_TRUST_PROVIDER_TYPE_FIELD);
        map.put("OidcOptions", OIDC_OPTIONS_FIELD);
        map.put("DeviceOptions", DEVICE_OPTIONS_FIELD);
        map.put("PolicyReferenceName", POLICY_REFERENCE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        map.put("NativeApplicationOidcOptions", NATIVE_APPLICATION_OIDC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessTrustProviderRequest, T> g) {
        return obj -> g.apply((CreateVerifiedAccessTrustProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVerifiedAccessTrustProviderRequest> {
        /**
         * <p>
         * The type of trust provider.
         * </p>
         * 
         * @param trustProviderType
         *        The type of trust provider.
         * @see TrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustProviderType
         */
        Builder trustProviderType(String trustProviderType);

        /**
         * <p>
         * The type of trust provider.
         * </p>
         * 
         * @param trustProviderType
         *        The type of trust provider.
         * @see TrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustProviderType
         */
        Builder trustProviderType(TrustProviderType trustProviderType);

        /**
         * <p>
         * The type of user-based trust provider. This parameter is required when the provider type is <code>user</code>
         * .
         * </p>
         * 
         * @param userTrustProviderType
         *        The type of user-based trust provider. This parameter is required when the provider type is
         *        <code>user</code>.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder userTrustProviderType(String userTrustProviderType);

        /**
         * <p>
         * The type of user-based trust provider. This parameter is required when the provider type is <code>user</code>
         * .
         * </p>
         * 
         * @param userTrustProviderType
         *        The type of user-based trust provider. This parameter is required when the provider type is
         *        <code>user</code>.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder userTrustProviderType(UserTrustProviderType userTrustProviderType);

        /**
         * <p>
         * The type of device-based trust provider. This parameter is required when the provider type is
         * <code>device</code>.
         * </p>
         * 
         * @param deviceTrustProviderType
         *        The type of device-based trust provider. This parameter is required when the provider type is
         *        <code>device</code>.
         * @see DeviceTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceTrustProviderType
         */
        Builder deviceTrustProviderType(String deviceTrustProviderType);

        /**
         * <p>
         * The type of device-based trust provider. This parameter is required when the provider type is
         * <code>device</code>.
         * </p>
         * 
         * @param deviceTrustProviderType
         *        The type of device-based trust provider. This parameter is required when the provider type is
         *        <code>device</code>.
         * @see DeviceTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceTrustProviderType
         */
        Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType);

        /**
         * <p>
         * The options for a OpenID Connect-compatible user-identity trust provider. This parameter is required when the
         * provider type is <code>user</code>.
         * </p>
         * 
         * @param oidcOptions
         *        The options for a OpenID Connect-compatible user-identity trust provider. This parameter is required
         *        when the provider type is <code>user</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcOptions(CreateVerifiedAccessTrustProviderOidcOptions oidcOptions);

        /**
         * <p>
         * The options for a OpenID Connect-compatible user-identity trust provider. This parameter is required when the
         * provider type is <code>user</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateVerifiedAccessTrustProviderOidcOptions.Builder} avoiding the need to create one manually via
         * {@link CreateVerifiedAccessTrustProviderOidcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateVerifiedAccessTrustProviderOidcOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #oidcOptions(CreateVerifiedAccessTrustProviderOidcOptions)}.
         * 
         * @param oidcOptions
         *        a consumer that will call methods on {@link CreateVerifiedAccessTrustProviderOidcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcOptions(CreateVerifiedAccessTrustProviderOidcOptions)
         */
        default Builder oidcOptions(Consumer<CreateVerifiedAccessTrustProviderOidcOptions.Builder> oidcOptions) {
            return oidcOptions(CreateVerifiedAccessTrustProviderOidcOptions.builder().applyMutation(oidcOptions).build());
        }

        /**
         * <p>
         * The options for a device-based trust provider. This parameter is required when the provider type is
         * <code>device</code>.
         * </p>
         * 
         * @param deviceOptions
         *        The options for a device-based trust provider. This parameter is required when the provider type is
         *        <code>device</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions);

        /**
         * <p>
         * The options for a device-based trust provider. This parameter is required when the provider type is
         * <code>device</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateVerifiedAccessTrustProviderDeviceOptions.Builder} avoiding the need to create one manually via
         * {@link CreateVerifiedAccessTrustProviderDeviceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateVerifiedAccessTrustProviderDeviceOptions.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #deviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions)}.
         * 
         * @param deviceOptions
         *        a consumer that will call methods on {@link CreateVerifiedAccessTrustProviderDeviceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions)
         */
        default Builder deviceOptions(Consumer<CreateVerifiedAccessTrustProviderDeviceOptions.Builder> deviceOptions) {
            return deviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions.builder().applyMutation(deviceOptions).build());
        }

        /**
         * <p>
         * The identifier to be used when working with policy rules.
         * </p>
         * 
         * @param policyReferenceName
         *        The identifier to be used when working with policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyReferenceName(String policyReferenceName);

        /**
         * <p>
         * A description for the Verified Access trust provider.
         * </p>
         * 
         * @param description
         *        A description for the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags to assign to the Verified Access trust provider.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to the Verified Access trust provider.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to the Verified Access trust provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure idempotency of your modification request.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The options for server side encryption.
         * </p>
         * 
         * @param sseSpecification
         *        The options for server side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification);

        /**
         * <p>
         * The options for server side encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessSseSpecificationRequest.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessSseSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessSseSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #sseSpecification(VerifiedAccessSseSpecificationRequest)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link VerifiedAccessSseSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(VerifiedAccessSseSpecificationRequest)
         */
        default Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationRequest.Builder> sseSpecification) {
            return sseSpecification(VerifiedAccessSseSpecificationRequest.builder().applyMutation(sseSpecification).build());
        }

        /**
         * <p>
         * The OpenID Connect (OIDC) options.
         * </p>
         * 
         * @param nativeApplicationOidcOptions
         *        The OpenID Connect (OIDC) options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nativeApplicationOidcOptions(CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions);

        /**
         * <p>
         * The OpenID Connect (OIDC) options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateVerifiedAccessNativeApplicationOidcOptions.Builder} avoiding the need to create one manually via
         * {@link CreateVerifiedAccessNativeApplicationOidcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateVerifiedAccessNativeApplicationOidcOptions.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #nativeApplicationOidcOptions(CreateVerifiedAccessNativeApplicationOidcOptions)}.
         * 
         * @param nativeApplicationOidcOptions
         *        a consumer that will call methods on {@link CreateVerifiedAccessNativeApplicationOidcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nativeApplicationOidcOptions(CreateVerifiedAccessNativeApplicationOidcOptions)
         */
        default Builder nativeApplicationOidcOptions(
                Consumer<CreateVerifiedAccessNativeApplicationOidcOptions.Builder> nativeApplicationOidcOptions) {
            return nativeApplicationOidcOptions(CreateVerifiedAccessNativeApplicationOidcOptions.builder()
                    .applyMutation(nativeApplicationOidcOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trustProviderType;

        private String userTrustProviderType;

        private String deviceTrustProviderType;

        private CreateVerifiedAccessTrustProviderOidcOptions oidcOptions;

        private CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions;

        private String policyReferenceName;

        private String description;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Boolean dryRun;

        private VerifiedAccessSseSpecificationRequest sseSpecification;

        private CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessTrustProviderRequest model) {
            super(model);
            trustProviderType(model.trustProviderType);
            userTrustProviderType(model.userTrustProviderType);
            deviceTrustProviderType(model.deviceTrustProviderType);
            oidcOptions(model.oidcOptions);
            deviceOptions(model.deviceOptions);
            policyReferenceName(model.policyReferenceName);
            description(model.description);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
            sseSpecification(model.sseSpecification);
            nativeApplicationOidcOptions(model.nativeApplicationOidcOptions);
        }

        public final String getTrustProviderType() {
            return trustProviderType;
        }

        public final void setTrustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
        }

        @Override
        public final Builder trustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
            return this;
        }

        @Override
        public final Builder trustProviderType(TrustProviderType trustProviderType) {
            this.trustProviderType(trustProviderType == null ? null : trustProviderType.toString());
            return this;
        }

        public final String getUserTrustProviderType() {
            return userTrustProviderType;
        }

        public final void setUserTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
        }

        @Override
        public final Builder userTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
            return this;
        }

        @Override
        public final Builder userTrustProviderType(UserTrustProviderType userTrustProviderType) {
            this.userTrustProviderType(userTrustProviderType == null ? null : userTrustProviderType.toString());
            return this;
        }

        public final String getDeviceTrustProviderType() {
            return deviceTrustProviderType;
        }

        public final void setDeviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
        }

        @Override
        public final Builder deviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
            return this;
        }

        @Override
        public final Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType) {
            this.deviceTrustProviderType(deviceTrustProviderType == null ? null : deviceTrustProviderType.toString());
            return this;
        }

        public final CreateVerifiedAccessTrustProviderOidcOptions.Builder getOidcOptions() {
            return oidcOptions != null ? oidcOptions.toBuilder() : null;
        }

        public final void setOidcOptions(CreateVerifiedAccessTrustProviderOidcOptions.BuilderImpl oidcOptions) {
            this.oidcOptions = oidcOptions != null ? oidcOptions.build() : null;
        }

        @Override
        public final Builder oidcOptions(CreateVerifiedAccessTrustProviderOidcOptions oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        public final CreateVerifiedAccessTrustProviderDeviceOptions.Builder getDeviceOptions() {
            return deviceOptions != null ? deviceOptions.toBuilder() : null;
        }

        public final void setDeviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions.BuilderImpl deviceOptions) {
            this.deviceOptions = deviceOptions != null ? deviceOptions.build() : null;
        }

        @Override
        public final Builder deviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        public final String getPolicyReferenceName() {
            return policyReferenceName;
        }

        public final void setPolicyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
        }

        @Override
        public final Builder policyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final VerifiedAccessSseSpecificationRequest.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationRequest.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final CreateVerifiedAccessNativeApplicationOidcOptions.Builder getNativeApplicationOidcOptions() {
            return nativeApplicationOidcOptions != null ? nativeApplicationOidcOptions.toBuilder() : null;
        }

        public final void setNativeApplicationOidcOptions(
                CreateVerifiedAccessNativeApplicationOidcOptions.BuilderImpl nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions != null ? nativeApplicationOidcOptions.build()
                    : null;
        }

        @Override
        public final Builder nativeApplicationOidcOptions(
                CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVerifiedAccessTrustProviderRequest build() {
            return new CreateVerifiedAccessTrustProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
