/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpamPrefixListResolverResponse extends Ec2Response implements
        ToCopyableBuilder<CreateIpamPrefixListResolverResponse.Builder, CreateIpamPrefixListResolverResponse> {
    private static final SdkField<IpamPrefixListResolver> IPAM_PREFIX_LIST_RESOLVER_FIELD = SdkField
            .<IpamPrefixListResolver> builder(MarshallingType.SDK_POJO)
            .memberName("IpamPrefixListResolver")
            .getter(getter(CreateIpamPrefixListResolverResponse::ipamPrefixListResolver))
            .setter(setter(Builder::ipamPrefixListResolver))
            .constructor(IpamPrefixListResolver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolver")
                    .unmarshallLocationName("ipamPrefixListResolver").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IPAM_PREFIX_LIST_RESOLVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpamPrefixListResolver ipamPrefixListResolver;

    private CreateIpamPrefixListResolverResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPrefixListResolver = builder.ipamPrefixListResolver;
    }

    /**
     * <p>
     * Information about the IPAM prefix list resolver that was created.
     * </p>
     * 
     * @return Information about the IPAM prefix list resolver that was created.
     */
    public final IpamPrefixListResolver ipamPrefixListResolver() {
        return ipamPrefixListResolver;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPrefixListResolver());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPrefixListResolverResponse)) {
            return false;
        }
        CreateIpamPrefixListResolverResponse other = (CreateIpamPrefixListResolverResponse) obj;
        return Objects.equals(ipamPrefixListResolver(), other.ipamPrefixListResolver());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpamPrefixListResolverResponse").add("IpamPrefixListResolver", ipamPrefixListResolver())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPrefixListResolver":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolver()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPrefixListResolver", IPAM_PREFIX_LIST_RESOLVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPrefixListResolverResponse, T> g) {
        return obj -> g.apply((CreateIpamPrefixListResolverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpamPrefixListResolverResponse> {
        /**
         * <p>
         * Information about the IPAM prefix list resolver that was created.
         * </p>
         * 
         * @param ipamPrefixListResolver
         *        Information about the IPAM prefix list resolver that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolver(IpamPrefixListResolver ipamPrefixListResolver);

        /**
         * <p>
         * Information about the IPAM prefix list resolver that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPrefixListResolver.Builder} avoiding
         * the need to create one manually via {@link IpamPrefixListResolver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamPrefixListResolver.Builder#build()} is called immediately and
         * its result is passed to {@link #ipamPrefixListResolver(IpamPrefixListResolver)}.
         * 
         * @param ipamPrefixListResolver
         *        a consumer that will call methods on {@link IpamPrefixListResolver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPrefixListResolver(IpamPrefixListResolver)
         */
        default Builder ipamPrefixListResolver(Consumer<IpamPrefixListResolver.Builder> ipamPrefixListResolver) {
            return ipamPrefixListResolver(IpamPrefixListResolver.builder().applyMutation(ipamPrefixListResolver).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamPrefixListResolver ipamPrefixListResolver;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPrefixListResolverResponse model) {
            super(model);
            ipamPrefixListResolver(model.ipamPrefixListResolver);
        }

        public final IpamPrefixListResolver.Builder getIpamPrefixListResolver() {
            return ipamPrefixListResolver != null ? ipamPrefixListResolver.toBuilder() : null;
        }

        public final void setIpamPrefixListResolver(IpamPrefixListResolver.BuilderImpl ipamPrefixListResolver) {
            this.ipamPrefixListResolver = ipamPrefixListResolver != null ? ipamPrefixListResolver.build() : null;
        }

        @Override
        public final Builder ipamPrefixListResolver(IpamPrefixListResolver ipamPrefixListResolver) {
            this.ipamPrefixListResolver = ipamPrefixListResolver;
            return this;
        }

        @Override
        public CreateIpamPrefixListResolverResponse build() {
            return new CreateIpamPrefixListResolverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
