/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersion;

public class GetIpamPrefixListResolverVersionsPublisher
implements SdkPublisher<GetIpamPrefixListResolverVersionsResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamPrefixListResolverVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamPrefixListResolverVersionsPublisher(Ec2AsyncClient client, GetIpamPrefixListResolverVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamPrefixListResolverVersionsPublisher(Ec2AsyncClient client, GetIpamPrefixListResolverVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamPrefixListResolverVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamPrefixListResolverVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPrefixListResolverVersion> ipamPrefixListResolverVersions() {
        Function<GetIpamPrefixListResolverVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPrefixListResolverVersions() != null) {
                return response.ipamPrefixListResolverVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetIpamPrefixListResolverVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetIpamPrefixListResolverVersionsResponseFetcher
    implements AsyncPageFetcher<GetIpamPrefixListResolverVersionsResponse> {
        private GetIpamPrefixListResolverVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPrefixListResolverVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamPrefixListResolverVersionsResponse> nextPage(GetIpamPrefixListResolverVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPrefixListResolverVersionsPublisher.this.client.getIpamPrefixListResolverVersions(GetIpamPrefixListResolverVersionsPublisher.this.firstRequest);
            }
            return GetIpamPrefixListResolverVersionsPublisher.this.client.getIpamPrefixListResolverVersions((GetIpamPrefixListResolverVersionsRequest)((Object)GetIpamPrefixListResolverVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

