/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a state change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateReason implements SdkPojo, Serializable, ToCopyableBuilder<StateReason.Builder, StateReason> {
    private static final SdkField<String> CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Code")
            .getter(getter(StateReason::code))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Message")
            .getter(getter(StateReason::message))
            .setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message")
                    .unmarshallLocationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private StateReason(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The reason code for the state change.
     * </p>
     * 
     * @return The reason code for the state change.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The message for the state change.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy the launch
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests with a
     * maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the
     * Spot price.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot requests with
     * a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in
     * the Spot price.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down from the operating system of the
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was exceeded.
     * Decrease usage or request an increase in your account limits.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The message for the state change.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy
     *         the launch request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests
     *         with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an
     *         increase in the Spot price.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot
     *         requests with a maximum price equal to or higher than the Spot price exceeded available capacity or
     *         because of an increase in the Spot price.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down from the operating system of
     *         the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was
     *         exceeded. Decrease usage or request an increase in your account limits.
     *         </p>
     *         </li>
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateReason)) {
            return false;
        }
        StateReason other = (StateReason) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateReason").add("Code", code()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateReason, T> g) {
        return obj -> g.apply((StateReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateReason> {
        /**
         * <p>
         * The reason code for the state change.
         * </p>
         * 
         * @param code
         *        The reason code for the state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The message for the state change.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy the
         * launch request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests with a
         * maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in
         * the Spot price.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot requests
         * with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an
         * increase in the Spot price.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down from the operating system of the
         * instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was
         * exceeded. Decrease usage or request an increase in your account limits.
         * </p>
         * </li>
         * </ul>
         * 
         * @param message
         *        The message for the state change.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy
         *        the launch request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests
         *        with a maximum price equal to or higher than the Spot price exceeded available capacity or because of
         *        an increase in the Spot price.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot
         *        requests with a maximum price equal to or higher than the Spot price exceeded available capacity or
         *        because of an increase in the Spot price.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down from the operating system of
         *        the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was
         *        exceeded. Decrease usage or request an increase in your account limits.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(StateReason model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public StateReason build() {
            return new StateReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
