/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetAddressAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ResetAddressAttributeRequest.Builder, ResetAddressAttributeRequest> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(ResetAddressAttributeRequest::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("AllocationId").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Attribute")
            .getter(getter(ResetAddressAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ResetAddressAttributeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            ATTRIBUTE_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String allocationId;

    private final String attribute;

    private final Boolean dryRun;

    private ResetAddressAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.attribute = builder.attribute;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * [EC2-VPC] The allocation ID.
     * </p>
     * 
     * @return [EC2-VPC] The allocation ID.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The attribute of the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link AddressAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute of the IP address.
     * @see AddressAttributeName
     */
    public final AddressAttributeName attribute() {
        return AddressAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute of the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link AddressAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute of the IP address.
     * @see AddressAttributeName
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetAddressAttributeRequest)) {
            return false;
        }
        ResetAddressAttributeRequest other = (ResetAddressAttributeRequest) obj;
        return Objects.equals(allocationId(), other.allocationId())
                && Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetAddressAttributeRequest").add("AllocationId", allocationId())
                .add("Attribute", attributeAsString()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetAddressAttributeRequest, T> g) {
        return obj -> g.apply((ResetAddressAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ResetAddressAttributeRequest> {
        /**
         * <p>
         * [EC2-VPC] The allocation ID.
         * </p>
         * 
         * @param allocationId
         *        [EC2-VPC] The allocation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The attribute of the IP address.
         * </p>
         * 
         * @param attribute
         *        The attribute of the IP address.
         * @see AddressAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute of the IP address.
         * </p>
         * 
         * @param attribute
         *        The attribute of the IP address.
         * @see AddressAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressAttributeName
         */
        Builder attribute(AddressAttributeName attribute);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String allocationId;

        private String attribute;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetAddressAttributeRequest model) {
            super(model);
            allocationId(model.allocationId);
            attribute(model.attribute);
            dryRun(model.dryRun);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(AddressAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetAddressAttributeRequest build() {
            return new ResetAddressAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
