/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.OutputFormat;
import software.amazon.awssdk.services.ec2.model.Schedule;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapacityManagerDataExportRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateCapacityManagerDataExportRequest> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(CreateCapacityManagerDataExportRequest.getter(CreateCapacityManagerDataExportRequest::s3BucketName)).setter(CreateCapacityManagerDataExportRequest.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").unmarshallLocationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketPrefix").getter(CreateCapacityManagerDataExportRequest.getter(CreateCapacityManagerDataExportRequest::s3BucketPrefix)).setter(CreateCapacityManagerDataExportRequest.setter(Builder::s3BucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketPrefix").unmarshallLocationName("S3BucketPrefix").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CreateCapacityManagerDataExportRequest.getter(CreateCapacityManagerDataExportRequest::scheduleAsString)).setter(CreateCapacityManagerDataExportRequest.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").unmarshallLocationName("Schedule").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(CreateCapacityManagerDataExportRequest.getter(CreateCapacityManagerDataExportRequest::outputFormatAsString)).setter(CreateCapacityManagerDataExportRequest.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").unmarshallLocationName("OutputFormat").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateCapacityManagerDataExportRequest.getter(CreateCapacityManagerDataExportRequest::clientToken)).setter(CreateCapacityManagerDataExportRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateCapacityManagerDataExportRequest.getter(CreateCapacityManagerDataExportRequest::dryRun)).setter(CreateCapacityManagerDataExportRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateCapacityManagerDataExportRequest.getter(CreateCapacityManagerDataExportRequest::tagSpecifications)).setter(CreateCapacityManagerDataExportRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, S3_BUCKET_PREFIX_FIELD, SCHEDULE_FIELD, OUTPUT_FORMAT_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCapacityManagerDataExportRequest.memberNameToFieldInitializer();
    private final String s3BucketName;
    private final String s3BucketPrefix;
    private final String schedule;
    private final String outputFormat;
    private final String clientToken;
    private final Boolean dryRun;
    private final List<TagSpecification> tagSpecifications;

    private CreateCapacityManagerDataExportRequest(BuilderImpl builder) {
        super(builder);
        this.s3BucketName = builder.s3BucketName;
        this.s3BucketPrefix = builder.s3BucketPrefix;
        this.schedule = builder.schedule;
        this.outputFormat = builder.outputFormat;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3BucketPrefix() {
        return this.s3BucketPrefix;
    }

    public final Schedule schedule() {
        return Schedule.fromValue(this.schedule);
    }

    public final String scheduleAsString() {
        return this.schedule;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityManagerDataExportRequest)) {
            return false;
        }
        CreateCapacityManagerDataExportRequest other = (CreateCapacityManagerDataExportRequest)((Object)obj);
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3BucketPrefix(), other.s3BucketPrefix()) && Objects.equals(this.scheduleAsString(), other.scheduleAsString()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapacityManagerDataExportRequest").add("S3BucketName", (Object)this.s3BucketName()).add("S3BucketPrefix", (Object)this.s3BucketPrefix()).add("Schedule", (Object)this.scheduleAsString()).add("OutputFormat", (Object)this.outputFormatAsString()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3BucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3BucketPrefix()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.scheduleAsString()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3BucketPrefix", S3_BUCKET_PREFIX_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityManagerDataExportRequest, T> g) {
        return obj -> g.apply((CreateCapacityManagerDataExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String s3BucketPrefix;
        private String schedule;
        private String outputFormat;
        private String clientToken;
        private Boolean dryRun;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityManagerDataExportRequest model) {
            super(model);
            this.s3BucketName(model.s3BucketName);
            this.s3BucketPrefix(model.s3BucketPrefix);
            this.schedule(model.schedule);
            this.outputFormat(model.outputFormat);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3BucketPrefix() {
            return this.s3BucketPrefix;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapacityManagerDataExportRequest build() {
            return new CreateCapacityManagerDataExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapacityManagerDataExportRequest> {
        public Builder s3BucketName(String var1);

        public Builder s3BucketPrefix(String var1);

        public Builder schedule(String var1);

        public Builder schedule(Schedule var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

