/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRouteServerEndpointResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteRouteServerEndpointResponse.Builder, DeleteRouteServerEndpointResponse> {
    private static final SdkField<RouteServerEndpoint> ROUTE_SERVER_ENDPOINT_FIELD = SdkField
            .<RouteServerEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("RouteServerEndpoint")
            .getter(getter(DeleteRouteServerEndpointResponse::routeServerEndpoint))
            .setter(setter(Builder::routeServerEndpoint))
            .constructor(RouteServerEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpoint")
                    .unmarshallLocationName("routeServerEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouteServerEndpoint routeServerEndpoint;

    private DeleteRouteServerEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerEndpoint = builder.routeServerEndpoint;
    }

    /**
     * <p>
     * Information about the deleted route server endpoint.
     * </p>
     * 
     * @return Information about the deleted route server endpoint.
     */
    public final RouteServerEndpoint routeServerEndpoint() {
        return routeServerEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeServerEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteServerEndpointResponse)) {
            return false;
        }
        DeleteRouteServerEndpointResponse other = (DeleteRouteServerEndpointResponse) obj;
        return Objects.equals(routeServerEndpoint(), other.routeServerEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRouteServerEndpointResponse").add("RouteServerEndpoint", routeServerEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerEndpoint":
            return Optional.ofNullable(clazz.cast(routeServerEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerEndpoint", ROUTE_SERVER_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteServerEndpointResponse, T> g) {
        return obj -> g.apply((DeleteRouteServerEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRouteServerEndpointResponse> {
        /**
         * <p>
         * Information about the deleted route server endpoint.
         * </p>
         * 
         * @param routeServerEndpoint
         *        Information about the deleted route server endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerEndpoint(RouteServerEndpoint routeServerEndpoint);

        /**
         * <p>
         * Information about the deleted route server endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteServerEndpoint.Builder} avoiding the
         * need to create one manually via {@link RouteServerEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteServerEndpoint.Builder#build()} is called immediately and
         * its result is passed to {@link #routeServerEndpoint(RouteServerEndpoint)}.
         * 
         * @param routeServerEndpoint
         *        a consumer that will call methods on {@link RouteServerEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServerEndpoint(RouteServerEndpoint)
         */
        default Builder routeServerEndpoint(Consumer<RouteServerEndpoint.Builder> routeServerEndpoint) {
            return routeServerEndpoint(RouteServerEndpoint.builder().applyMutation(routeServerEndpoint).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private RouteServerEndpoint routeServerEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteServerEndpointResponse model) {
            super(model);
            routeServerEndpoint(model.routeServerEndpoint);
        }

        public final RouteServerEndpoint.Builder getRouteServerEndpoint() {
            return routeServerEndpoint != null ? routeServerEndpoint.toBuilder() : null;
        }

        public final void setRouteServerEndpoint(RouteServerEndpoint.BuilderImpl routeServerEndpoint) {
            this.routeServerEndpoint = routeServerEndpoint != null ? routeServerEndpoint.build() : null;
        }

        @Override
        public final Builder routeServerEndpoint(RouteServerEndpoint routeServerEndpoint) {
            this.routeServerEndpoint = routeServerEndpoint;
            return this;
        }

        @Override
        public DeleteRouteServerEndpointResponse build() {
            return new DeleteRouteServerEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
