/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PrefixListState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedPrefixList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedPrefixList> {
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(ManagedPrefixList.getter(ManagedPrefixList::prefixListId)).setter(ManagedPrefixList.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("prefixListId").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressFamily").getter(ManagedPrefixList.getter(ManagedPrefixList::addressFamily)).setter(ManagedPrefixList.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily").unmarshallLocationName("addressFamily").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ManagedPrefixList.getter(ManagedPrefixList::stateAsString)).setter(ManagedPrefixList.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(ManagedPrefixList.getter(ManagedPrefixList::stateMessage)).setter(ManagedPrefixList.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListArn").getter(ManagedPrefixList.getter(ManagedPrefixList::prefixListArn)).setter(ManagedPrefixList.setter(Builder::prefixListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListArn").unmarshallLocationName("prefixListArn").build()}).build();
    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListName").getter(ManagedPrefixList.getter(ManagedPrefixList::prefixListName)).setter(ManagedPrefixList.setter(Builder::prefixListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName").unmarshallLocationName("prefixListName").build()}).build();
    private static final SdkField<Integer> MAX_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxEntries").getter(ManagedPrefixList.getter(ManagedPrefixList::maxEntries)).setter(ManagedPrefixList.setter(Builder::maxEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEntries").unmarshallLocationName("maxEntries").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(ManagedPrefixList.getter(ManagedPrefixList::version)).setter(ManagedPrefixList.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").unmarshallLocationName("version").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ManagedPrefixList.getter(ManagedPrefixList::tags)).setter(ManagedPrefixList.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(ManagedPrefixList.getter(ManagedPrefixList::ownerId)).setter(ManagedPrefixList.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_ID_FIELD, ADDRESS_FAMILY_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, PREFIX_LIST_ARN_FIELD, PREFIX_LIST_NAME_FIELD, MAX_ENTRIES_FIELD, VERSION_FIELD, TAGS_FIELD, OWNER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedPrefixList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String prefixListId;
    private final String addressFamily;
    private final String state;
    private final String stateMessage;
    private final String prefixListArn;
    private final String prefixListName;
    private final Integer maxEntries;
    private final Long version;
    private final List<Tag> tags;
    private final String ownerId;

    private ManagedPrefixList(BuilderImpl builder) {
        this.prefixListId = builder.prefixListId;
        this.addressFamily = builder.addressFamily;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.prefixListArn = builder.prefixListArn;
        this.prefixListName = builder.prefixListName;
        this.maxEntries = builder.maxEntries;
        this.version = builder.version;
        this.tags = builder.tags;
        this.ownerId = builder.ownerId;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String addressFamily() {
        return this.addressFamily;
    }

    public final PrefixListState state() {
        return PrefixListState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final String prefixListArn() {
        return this.prefixListArn;
    }

    public final String prefixListName() {
        return this.prefixListName;
    }

    public final Integer maxEntries() {
        return this.maxEntries;
    }

    public final Long version() {
        return this.version;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedPrefixList)) {
            return false;
        }
        ManagedPrefixList other = (ManagedPrefixList)obj;
        return Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.addressFamily(), other.addressFamily()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.prefixListArn(), other.prefixListArn()) && Objects.equals(this.prefixListName(), other.prefixListName()) && Objects.equals(this.maxEntries(), other.maxEntries()) && Objects.equals(this.version(), other.version()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.ownerId(), other.ownerId());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedPrefixList").add("PrefixListId", (Object)this.prefixListId()).add("AddressFamily", (Object)this.addressFamily()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).add("PrefixListArn", (Object)this.prefixListArn()).add("PrefixListName", (Object)this.prefixListName()).add("MaxEntries", (Object)this.maxEntries()).add("Version", (Object)this.version()).add("Tags", this.hasTags() ? this.tags() : null).add("OwnerId", (Object)this.ownerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "AddressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamily()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "PrefixListArn": {
                return Optional.ofNullable(clazz.cast(this.prefixListArn()));
            }
            case "PrefixListName": {
                return Optional.ofNullable(clazz.cast(this.prefixListName()));
            }
            case "MaxEntries": {
                return Optional.ofNullable(clazz.cast(this.maxEntries()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("AddressFamily", ADDRESS_FAMILY_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("PrefixListArn", PREFIX_LIST_ARN_FIELD);
        map.put("PrefixListName", PREFIX_LIST_NAME_FIELD);
        map.put("MaxEntries", MAX_ENTRIES_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedPrefixList, T> g) {
        return obj -> g.apply((ManagedPrefixList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String prefixListId;
        private String addressFamily;
        private String state;
        private String stateMessage;
        private String prefixListArn;
        private String prefixListName;
        private Integer maxEntries;
        private Long version;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedPrefixList model) {
            this.prefixListId(model.prefixListId);
            this.addressFamily(model.addressFamily);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.prefixListArn(model.prefixListArn);
            this.prefixListName(model.prefixListName);
            this.maxEntries(model.maxEntries);
            this.version(model.version);
            this.tags(model.tags);
            this.ownerId(model.ownerId);
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PrefixListState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final String getPrefixListArn() {
            return this.prefixListArn;
        }

        public final void setPrefixListArn(String prefixListArn) {
            this.prefixListArn = prefixListArn;
        }

        @Override
        public final Builder prefixListArn(String prefixListArn) {
            this.prefixListArn = prefixListArn;
            return this;
        }

        public final String getPrefixListName() {
            return this.prefixListName;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final Integer getMaxEntries() {
            return this.maxEntries;
        }

        public final void setMaxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
        }

        @Override
        public final Builder maxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public ManagedPrefixList build() {
            return new ManagedPrefixList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedPrefixList> {
        public Builder prefixListId(String var1);

        public Builder addressFamily(String var1);

        public Builder state(String var1);

        public Builder state(PrefixListState var1);

        public Builder stateMessage(String var1);

        public Builder prefixListArn(String var1);

        public Builder prefixListName(String var1);

        public Builder maxEntries(Integer var1);

        public Builder version(Long var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder ownerId(String var1);
    }
}

