/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse;
import software.amazon.awssdk.services.ec2.model.Ipam;

public class DescribeIpamsIterable
implements SdkIterable<DescribeIpamsResponse> {
    private final Ec2Client client;
    private final DescribeIpamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpamsIterable(Ec2Client client, DescribeIpamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeIpamsResponseFetcher();
    }

    public Iterator<DescribeIpamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Ipam> ipams() {
        Function<DescribeIpamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipams() != null) {
                return response.ipams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpamsResponseFetcher
    implements SyncPageFetcher<DescribeIpamsResponse> {
        private DescribeIpamsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpamsResponse nextPage(DescribeIpamsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamsIterable.this.client.describeIpams(DescribeIpamsIterable.this.firstRequest);
            }
            return DescribeIpamsIterable.this.client.describeIpams((DescribeIpamsRequest)((Object)DescribeIpamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

