/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerPeersResponse;
import software.amazon.awssdk.services.ec2.model.RouteServerPeer;

public class DescribeRouteServerPeersIterable
implements SdkIterable<DescribeRouteServerPeersResponse> {
    private final Ec2Client client;
    private final DescribeRouteServerPeersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRouteServerPeersIterable(Ec2Client client, DescribeRouteServerPeersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRouteServerPeersResponseFetcher();
    }

    public Iterator<DescribeRouteServerPeersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RouteServerPeer> routeServerPeers() {
        Function<DescribeRouteServerPeersResponse, Iterator> getIterator = response -> {
            if (response != null && response.routeServerPeers() != null) {
                return response.routeServerPeers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRouteServerPeersResponseFetcher
    implements SyncPageFetcher<DescribeRouteServerPeersResponse> {
        private DescribeRouteServerPeersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteServerPeersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRouteServerPeersResponse nextPage(DescribeRouteServerPeersResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteServerPeersIterable.this.client.describeRouteServerPeers(DescribeRouteServerPeersIterable.this.firstRequest);
            }
            return DescribeRouteServerPeersIterable.this.client.describeRouteServerPeers((DescribeRouteServerPeersRequest)((Object)DescribeRouteServerPeersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

