/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PurchasedScheduledInstanceSetCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseScheduledInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, PurchaseScheduledInstancesResponse> {
    private static final SdkField<List<ScheduledInstance>> SCHEDULED_INSTANCE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledInstanceSet").getter(PurchaseScheduledInstancesResponse.getter(PurchaseScheduledInstancesResponse::scheduledInstanceSet)).setter(PurchaseScheduledInstancesResponse.setter(Builder::scheduledInstanceSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceSet").unmarshallLocationName("scheduledInstanceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_INSTANCE_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseScheduledInstancesResponse.memberNameToFieldInitializer();
    private final List<ScheduledInstance> scheduledInstanceSet;

    private PurchaseScheduledInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledInstanceSet = builder.scheduledInstanceSet;
    }

    public final boolean hasScheduledInstanceSet() {
        return this.scheduledInstanceSet != null && !(this.scheduledInstanceSet instanceof SdkAutoConstructList);
    }

    public final List<ScheduledInstance> scheduledInstanceSet() {
        return this.scheduledInstanceSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledInstanceSet() ? this.scheduledInstanceSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesResponse)) {
            return false;
        }
        PurchaseScheduledInstancesResponse other = (PurchaseScheduledInstancesResponse)((Object)obj);
        return this.hasScheduledInstanceSet() == other.hasScheduledInstanceSet() && Objects.equals(this.scheduledInstanceSet(), other.scheduledInstanceSet());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseScheduledInstancesResponse").add("ScheduledInstanceSet", this.hasScheduledInstanceSet() ? this.scheduledInstanceSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledInstanceSet": {
                return Optional.ofNullable(clazz.cast(this.scheduledInstanceSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ScheduledInstance>>> map = new HashMap<String, SdkField<List<ScheduledInstance>>>();
        map.put("ScheduledInstanceSet", SCHEDULED_INSTANCE_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseScheduledInstancesResponse, T> g) {
        return obj -> g.apply((PurchaseScheduledInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ScheduledInstance> scheduledInstanceSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesResponse model) {
            super(model);
            this.scheduledInstanceSet(model.scheduledInstanceSet);
        }

        public final List<ScheduledInstance.Builder> getScheduledInstanceSet() {
            List<ScheduledInstance.Builder> result = PurchasedScheduledInstanceSetCopier.copyToBuilder(this.scheduledInstanceSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledInstanceSet(Collection<ScheduledInstance.BuilderImpl> scheduledInstanceSet) {
            this.scheduledInstanceSet = PurchasedScheduledInstanceSetCopier.copyFromBuilder(scheduledInstanceSet);
        }

        @Override
        public final Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = PurchasedScheduledInstanceSetCopier.copy(scheduledInstanceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(ScheduledInstance ... scheduledInstanceSet) {
            this.scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(Consumer<ScheduledInstance.Builder> ... scheduledInstanceSet) {
            this.scheduledInstanceSet(Stream.of(scheduledInstanceSet).map(c -> (ScheduledInstance)((ScheduledInstance.Builder)ScheduledInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PurchaseScheduledInstancesResponse build() {
            return new PurchaseScheduledInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseScheduledInstancesResponse> {
        public Builder scheduledInstanceSet(Collection<ScheduledInstance> var1);

        public Builder scheduledInstanceSet(ScheduledInstance ... var1);

        public Builder scheduledInstanceSet(Consumer<ScheduledInstance.Builder> ... var1);
    }
}

