/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options in use for server side encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessSseSpecificationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessSseSpecificationResponse.Builder, VerifiedAccessSseSpecificationResponse> {
    private static final SdkField<Boolean> CUSTOMER_MANAGED_KEY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CustomerManagedKeyEnabled")
            .getter(getter(VerifiedAccessSseSpecificationResponse::customerManagedKeyEnabled))
            .setter(setter(Builder::customerManagedKeyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerManagedKeyEnabled")
                    .unmarshallLocationName("customerManagedKeyEnabled").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn")
            .getter(getter(VerifiedAccessSseSpecificationResponse::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn")
                    .unmarshallLocationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOMER_MANAGED_KEY_ENABLED_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean customerManagedKeyEnabled;

    private final String kmsKeyArn;

    private VerifiedAccessSseSpecificationResponse(BuilderImpl builder) {
        this.customerManagedKeyEnabled = builder.customerManagedKeyEnabled;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * Indicates whether customer managed KMS keys are in use for server side encryption.
     * </p>
     * <p>
     * Valid values: <code>True</code> | <code>False</code>
     * </p>
     * 
     * @return Indicates whether customer managed KMS keys are in use for server side encryption.</p>
     *         <p>
     *         Valid values: <code>True</code> | <code>False</code>
     */
    public final Boolean customerManagedKeyEnabled() {
        return customerManagedKeyEnabled;
    }

    /**
     * <p>
     * The ARN of the KMS key.
     * </p>
     * 
     * @return The ARN of the KMS key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKeyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessSseSpecificationResponse)) {
            return false;
        }
        VerifiedAccessSseSpecificationResponse other = (VerifiedAccessSseSpecificationResponse) obj;
        return Objects.equals(customerManagedKeyEnabled(), other.customerManagedKeyEnabled())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessSseSpecificationResponse")
                .add("CustomerManagedKeyEnabled", customerManagedKeyEnabled()).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerManagedKeyEnabled":
            return Optional.ofNullable(clazz.cast(customerManagedKeyEnabled()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomerManagedKeyEnabled", CUSTOMER_MANAGED_KEY_ENABLED_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessSseSpecificationResponse, T> g) {
        return obj -> g.apply((VerifiedAccessSseSpecificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessSseSpecificationResponse> {
        /**
         * <p>
         * Indicates whether customer managed KMS keys are in use for server side encryption.
         * </p>
         * <p>
         * Valid values: <code>True</code> | <code>False</code>
         * </p>
         * 
         * @param customerManagedKeyEnabled
         *        Indicates whether customer managed KMS keys are in use for server side encryption.</p>
         *        <p>
         *        Valid values: <code>True</code> | <code>False</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKeyEnabled(Boolean customerManagedKeyEnabled);

        /**
         * <p>
         * The ARN of the KMS key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean customerManagedKeyEnabled;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessSseSpecificationResponse model) {
            customerManagedKeyEnabled(model.customerManagedKeyEnabled);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final Boolean getCustomerManagedKeyEnabled() {
            return customerManagedKeyEnabled;
        }

        public final void setCustomerManagedKeyEnabled(Boolean customerManagedKeyEnabled) {
            this.customerManagedKeyEnabled = customerManagedKeyEnabled;
        }

        @Override
        public final Builder customerManagedKeyEnabled(Boolean customerManagedKeyEnabled) {
            this.customerManagedKeyEnabled = customerManagedKeyEnabled;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public VerifiedAccessSseSpecificationResponse build() {
            return new VerifiedAccessSseSpecificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
