/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The BGP configuration options for a route server peer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteServerBgpOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteServerBgpOptions.Builder, RouteServerBgpOptions> {
    private static final SdkField<Long> PEER_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PeerAsn")
            .getter(getter(RouteServerBgpOptions::peerAsn))
            .setter(setter(Builder::peerAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAsn")
                    .unmarshallLocationName("peerAsn").build()).build();

    private static final SdkField<String> PEER_LIVENESS_DETECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerLivenessDetection")
            .getter(getter(RouteServerBgpOptions::peerLivenessDetectionAsString))
            .setter(setter(Builder::peerLivenessDetection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerLivenessDetection")
                    .unmarshallLocationName("peerLivenessDetection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEER_ASN_FIELD,
            PEER_LIVENESS_DETECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long peerAsn;

    private final String peerLivenessDetection;

    private RouteServerBgpOptions(BuilderImpl builder) {
        this.peerAsn = builder.peerAsn;
        this.peerLivenessDetection = builder.peerLivenessDetection;
    }

    /**
     * <p>
     * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1 to
     * 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294 (32-bit
     * ASN) range.
     * </p>
     * 
     * @return The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from
     *         1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or
     *         4200000000–4294967294 (32-bit ASN) range.
     */
    public final Long peerAsn() {
        return peerAsn;
    }

    /**
     * <p>
     * The liveness detection protocol used for the BGP peer.
     * </p>
     * <p>
     * The requested liveness detection protocol for the BGP peer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
     * href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer to
     * fail-over in cases of network impact or router failure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
     * href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more sensitive
     * liveness detection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Defaults to <code>bgp-keepalive</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #peerLivenessDetection} will return {@link RouteServerPeerLivenessMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #peerLivenessDetectionAsString}.
     * </p>
     * 
     * @return The liveness detection protocol used for the BGP peer.</p>
     *         <p>
     *         The requested liveness detection protocol for the BGP peer.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
     *         href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer to
     *         fail-over in cases of network impact or router failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
     *         href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more
     *         sensitive liveness detection.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Defaults to <code>bgp-keepalive</code>.
     * @see RouteServerPeerLivenessMode
     */
    public final RouteServerPeerLivenessMode peerLivenessDetection() {
        return RouteServerPeerLivenessMode.fromValue(peerLivenessDetection);
    }

    /**
     * <p>
     * The liveness detection protocol used for the BGP peer.
     * </p>
     * <p>
     * The requested liveness detection protocol for the BGP peer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
     * href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer to
     * fail-over in cases of network impact or router failure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
     * href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more sensitive
     * liveness detection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Defaults to <code>bgp-keepalive</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #peerLivenessDetection} will return {@link RouteServerPeerLivenessMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #peerLivenessDetectionAsString}.
     * </p>
     * 
     * @return The liveness detection protocol used for the BGP peer.</p>
     *         <p>
     *         The requested liveness detection protocol for the BGP peer.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
     *         href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer to
     *         fail-over in cases of network impact or router failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
     *         href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more
     *         sensitive liveness detection.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Defaults to <code>bgp-keepalive</code>.
     * @see RouteServerPeerLivenessMode
     */
    public final String peerLivenessDetectionAsString() {
        return peerLivenessDetection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peerAsn());
        hashCode = 31 * hashCode + Objects.hashCode(peerLivenessDetectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServerBgpOptions)) {
            return false;
        }
        RouteServerBgpOptions other = (RouteServerBgpOptions) obj;
        return Objects.equals(peerAsn(), other.peerAsn())
                && Objects.equals(peerLivenessDetectionAsString(), other.peerLivenessDetectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteServerBgpOptions").add("PeerAsn", peerAsn())
                .add("PeerLivenessDetection", peerLivenessDetectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeerAsn":
            return Optional.ofNullable(clazz.cast(peerAsn()));
        case "PeerLivenessDetection":
            return Optional.ofNullable(clazz.cast(peerLivenessDetectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PeerAsn", PEER_ASN_FIELD);
        map.put("PeerLivenessDetection", PEER_LIVENESS_DETECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServerBgpOptions, T> g) {
        return obj -> g.apply((RouteServerBgpOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteServerBgpOptions> {
        /**
         * <p>
         * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are from 1
         * to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294
         * (32-bit ASN) range.
         * </p>
         * 
         * @param peerAsn
         *        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) for the appliance. Valid values are
         *        from 1 to 4294967295. We recommend using a private ASN in the 64512–65534 (16-bit ASN) or
         *        4200000000–4294967294 (32-bit ASN) range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAsn(Long peerAsn);

        /**
         * <p>
         * The liveness detection protocol used for the BGP peer.
         * </p>
         * <p>
         * The requested liveness detection protocol for the BGP peer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
         * href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer to
         * fail-over in cases of network impact or router failure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
         * href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more sensitive
         * liveness detection.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Defaults to <code>bgp-keepalive</code>.
         * </p>
         * 
         * @param peerLivenessDetection
         *        The liveness detection protocol used for the BGP peer.</p>
         *        <p>
         *        The requested liveness detection protocol for the BGP peer.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
         *        href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer
         *        to fail-over in cases of network impact or router failure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
         *        href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more
         *        sensitive liveness detection.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Defaults to <code>bgp-keepalive</code>.
         * @see RouteServerPeerLivenessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerPeerLivenessMode
         */
        Builder peerLivenessDetection(String peerLivenessDetection);

        /**
         * <p>
         * The liveness detection protocol used for the BGP peer.
         * </p>
         * <p>
         * The requested liveness detection protocol for the BGP peer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
         * href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer to
         * fail-over in cases of network impact or router failure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
         * href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more sensitive
         * liveness detection.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Defaults to <code>bgp-keepalive</code>.
         * </p>
         * 
         * @param peerLivenessDetection
         *        The liveness detection protocol used for the BGP peer.</p>
         *        <p>
         *        The requested liveness detection protocol for the BGP peer.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bgp-keepalive</code>: The standard BGP keep alive mechanism (<a
         *        href="https://www.rfc-editor.org/rfc/rfc4271#page-21">RFC4271</a>) that is stable but may take longer
         *        to fail-over in cases of network impact or router failure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bfd</code>: An additional Bidirectional Forwarding Detection (BFD) protocol (<a
         *        href="https://www.rfc-editor.org/rfc/rfc5880">RFC5880</a>) that enables fast failover by using more
         *        sensitive liveness detection.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Defaults to <code>bgp-keepalive</code>.
         * @see RouteServerPeerLivenessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerPeerLivenessMode
         */
        Builder peerLivenessDetection(RouteServerPeerLivenessMode peerLivenessDetection);
    }

    static final class BuilderImpl implements Builder {
        private Long peerAsn;

        private String peerLivenessDetection;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServerBgpOptions model) {
            peerAsn(model.peerAsn);
            peerLivenessDetection(model.peerLivenessDetection);
        }

        public final Long getPeerAsn() {
            return peerAsn;
        }

        public final void setPeerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
        }

        @Override
        public final Builder peerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        public final String getPeerLivenessDetection() {
            return peerLivenessDetection;
        }

        public final void setPeerLivenessDetection(String peerLivenessDetection) {
            this.peerLivenessDetection = peerLivenessDetection;
        }

        @Override
        public final Builder peerLivenessDetection(String peerLivenessDetection) {
            this.peerLivenessDetection = peerLivenessDetection;
            return this;
        }

        @Override
        public final Builder peerLivenessDetection(RouteServerPeerLivenessMode peerLivenessDetection) {
            this.peerLivenessDetection(peerLivenessDetection == null ? null : peerLivenessDetection.toString());
            return this;
        }

        @Override
        public RouteServerBgpOptions build() {
            return new RouteServerBgpOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
