/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum NetworkInterfaceType {
    INTERFACE("interface"),

    NAT_GATEWAY("natGateway"),

    EFA("efa"),

    EFA_ONLY("efa-only"),

    TRUNK("trunk"),

    LOAD_BALANCER("load_balancer"),

    NETWORK_LOAD_BALANCER("network_load_balancer"),

    VPC_ENDPOINT("vpc_endpoint"),

    BRANCH("branch"),

    TRANSIT_GATEWAY("transit_gateway"),

    LAMBDA("lambda"),

    QUICKSIGHT("quicksight"),

    GLOBAL_ACCELERATOR_MANAGED("global_accelerator_managed"),

    API_GATEWAY_MANAGED("api_gateway_managed"),

    GATEWAY_LOAD_BALANCER("gateway_load_balancer"),

    GATEWAY_LOAD_BALANCER_ENDPOINT("gateway_load_balancer_endpoint"),

    IOT_RULES_MANAGED("iot_rules_managed"),

    AWS_CODESTAR_CONNECTIONS_MANAGED("aws_codestar_connections_managed"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfaceType> VALUE_MAP = EnumUtils.uniqueIndex(NetworkInterfaceType.class,
            NetworkInterfaceType::toString);

    private final String value;

    private NetworkInterfaceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return NetworkInterfaceType corresponding to the value
     */
    public static NetworkInterfaceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link NetworkInterfaceType}s
     */
    public static Set<NetworkInterfaceType> knownValues() {
        Set<NetworkInterfaceType> knownValues = EnumSet.allOf(NetworkInterfaceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
