/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkInsightsAccessScopeAnalysisFindingsResponse extends Ec2Response
        implements
        ToCopyableBuilder<GetNetworkInsightsAccessScopeAnalysisFindingsResponse.Builder, GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeAnalysisId")
            .getter(getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::networkInsightsAccessScopeAnalysisId))
            .setter(setter(Builder::networkInsightsAccessScopeAnalysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkInsightsAccessScopeAnalysisId")
                    .unmarshallLocationName("networkInsightsAccessScopeAnalysisId").build()).build();

    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnalysisStatus")
            .getter(getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::analysisStatusAsString))
            .setter(setter(Builder::analysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStatus")
                    .unmarshallLocationName("analysisStatus").build()).build();

    private static final SdkField<List<AccessScopeAnalysisFinding>> ANALYSIS_FINDINGS_FIELD = SdkField
            .<List<AccessScopeAnalysisFinding>> builder(MarshallingType.LIST)
            .memberName("AnalysisFindings")
            .getter(getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::analysisFindings))
            .setter(setter(Builder::analysisFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisFindingSet")
                    .unmarshallLocationName("analysisFindingSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AccessScopeAnalysisFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessScopeAnalysisFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetNetworkInsightsAccessScopeAnalysisFindingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD, ANALYSIS_STATUS_FIELD, ANALYSIS_FINDINGS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String networkInsightsAccessScopeAnalysisId;

    private final String analysisStatus;

    private final List<AccessScopeAnalysisFinding> analysisFindings;

    private final String nextToken;

    private GetNetworkInsightsAccessScopeAnalysisFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeAnalysisId = builder.networkInsightsAccessScopeAnalysisId;
        this.analysisStatus = builder.analysisStatus;
        this.analysisFindings = builder.analysisFindings;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the Network Access Scope analysis.
     * </p>
     * 
     * @return The ID of the Network Access Scope analysis.
     */
    public final String networkInsightsAccessScopeAnalysisId() {
        return networkInsightsAccessScopeAnalysisId;
    }

    /**
     * <p>
     * The status of Network Access Scope Analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of Network Access Scope Analysis.
     * @see AnalysisStatus
     */
    public final AnalysisStatus analysisStatus() {
        return AnalysisStatus.fromValue(analysisStatus);
    }

    /**
     * <p>
     * The status of Network Access Scope Analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisStatus}
     * will return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisStatusAsString}.
     * </p>
     * 
     * @return The status of Network Access Scope Analysis.
     * @see AnalysisStatus
     */
    public final String analysisStatusAsString() {
        return analysisStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisFindings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisFindings() {
        return analysisFindings != null && !(analysisFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The findings associated with Network Access Scope Analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisFindings} method.
     * </p>
     * 
     * @return The findings associated with Network Access Scope Analysis.
     */
    public final List<AccessScopeAnalysisFinding> analysisFindings() {
        return analysisFindings;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisFindings() ? analysisFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkInsightsAccessScopeAnalysisFindingsResponse)) {
            return false;
        }
        GetNetworkInsightsAccessScopeAnalysisFindingsResponse other = (GetNetworkInsightsAccessScopeAnalysisFindingsResponse) obj;
        return Objects.equals(networkInsightsAccessScopeAnalysisId(), other.networkInsightsAccessScopeAnalysisId())
                && Objects.equals(analysisStatusAsString(), other.analysisStatusAsString())
                && hasAnalysisFindings() == other.hasAnalysisFindings()
                && Objects.equals(analysisFindings(), other.analysisFindings()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkInsightsAccessScopeAnalysisFindingsResponse")
                .add("NetworkInsightsAccessScopeAnalysisId", networkInsightsAccessScopeAnalysisId())
                .add("AnalysisStatus", analysisStatusAsString())
                .add("AnalysisFindings", hasAnalysisFindings() ? analysisFindings() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeAnalysisId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeAnalysisId()));
        case "AnalysisStatus":
            return Optional.ofNullable(clazz.cast(analysisStatusAsString()));
        case "AnalysisFindings":
            return Optional.ofNullable(clazz.cast(analysisFindings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetworkInsightsAccessScopeAnalysisId", NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD);
        map.put("AnalysisStatus", ANALYSIS_STATUS_FIELD);
        map.put("AnalysisFindingSet", ANALYSIS_FINDINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkInsightsAccessScopeAnalysisFindingsResponse, T> g) {
        return obj -> g.apply((GetNetworkInsightsAccessScopeAnalysisFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
        /**
         * <p>
         * The ID of the Network Access Scope analysis.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysisId
         *        The ID of the Network Access Scope analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId);

        /**
         * <p>
         * The status of Network Access Scope Analysis.
         * </p>
         * 
         * @param analysisStatus
         *        The status of Network Access Scope Analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder analysisStatus(String analysisStatus);

        /**
         * <p>
         * The status of Network Access Scope Analysis.
         * </p>
         * 
         * @param analysisStatus
         *        The status of Network Access Scope Analysis.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder analysisStatus(AnalysisStatus analysisStatus);

        /**
         * <p>
         * The findings associated with Network Access Scope Analysis.
         * </p>
         * 
         * @param analysisFindings
         *        The findings associated with Network Access Scope Analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisFindings(Collection<AccessScopeAnalysisFinding> analysisFindings);

        /**
         * <p>
         * The findings associated with Network Access Scope Analysis.
         * </p>
         * 
         * @param analysisFindings
         *        The findings associated with Network Access Scope Analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisFindings(AccessScopeAnalysisFinding... analysisFindings);

        /**
         * <p>
         * The findings associated with Network Access Scope Analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding.Builder#build()} is called
         * immediately and its result is passed to {@link #analysisFindings(List<AccessScopeAnalysisFinding>)}.
         * 
         * @param analysisFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisFindings(java.util.Collection<AccessScopeAnalysisFinding>)
         */
        Builder analysisFindings(Consumer<AccessScopeAnalysisFinding.Builder>... analysisFindings);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String networkInsightsAccessScopeAnalysisId;

        private String analysisStatus;

        private List<AccessScopeAnalysisFinding> analysisFindings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkInsightsAccessScopeAnalysisFindingsResponse model) {
            super(model);
            networkInsightsAccessScopeAnalysisId(model.networkInsightsAccessScopeAnalysisId);
            analysisStatus(model.analysisStatus);
            analysisFindings(model.analysisFindings);
            nextToken(model.nextToken);
        }

        public final String getNetworkInsightsAccessScopeAnalysisId() {
            return networkInsightsAccessScopeAnalysisId;
        }

        public final void setNetworkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        public final String getAnalysisStatus() {
            return analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final List<AccessScopeAnalysisFinding.Builder> getAnalysisFindings() {
            List<AccessScopeAnalysisFinding.Builder> result = AccessScopeAnalysisFindingListCopier
                    .copyToBuilder(this.analysisFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisFindings(Collection<AccessScopeAnalysisFinding.BuilderImpl> analysisFindings) {
            this.analysisFindings = AccessScopeAnalysisFindingListCopier.copyFromBuilder(analysisFindings);
        }

        @Override
        public final Builder analysisFindings(Collection<AccessScopeAnalysisFinding> analysisFindings) {
            this.analysisFindings = AccessScopeAnalysisFindingListCopier.copy(analysisFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisFindings(AccessScopeAnalysisFinding... analysisFindings) {
            analysisFindings(Arrays.asList(analysisFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisFindings(Consumer<AccessScopeAnalysisFinding.Builder>... analysisFindings) {
            analysisFindings(Stream.of(analysisFindings).map(c -> AccessScopeAnalysisFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetNetworkInsightsAccessScopeAnalysisFindingsResponse build() {
            return new GetNetworkInsightsAccessScopeAnalysisFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
