/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequestIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotInstanceRequestsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeSpotInstanceRequestsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpotInstanceRequestsRequest.getter(DescribeSpotInstanceRequestsRequest::nextToken)).setter(DescribeSpotInstanceRequestsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeSpotInstanceRequestsRequest.getter(DescribeSpotInstanceRequestsRequest::maxResults)).setter(DescribeSpotInstanceRequestsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeSpotInstanceRequestsRequest.getter(DescribeSpotInstanceRequestsRequest::dryRun)).setter(DescribeSpotInstanceRequestsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<String>> SPOT_INSTANCE_REQUEST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpotInstanceRequestIds").getter(DescribeSpotInstanceRequestsRequest.getter(DescribeSpotInstanceRequestsRequest::spotInstanceRequestIds)).setter(DescribeSpotInstanceRequestsRequest.setter(Builder::spotInstanceRequestIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("SpotInstanceRequestId").build(), ListTrait.builder().memberLocationName("SpotInstanceRequestId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("SpotInstanceRequestId").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeSpotInstanceRequestsRequest.getter(DescribeSpotInstanceRequestsRequest::filters)).setter(DescribeSpotInstanceRequestsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, DRY_RUN_FIELD, SPOT_INSTANCE_REQUEST_IDS_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSpotInstanceRequestsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final Boolean dryRun;
    private final List<String> spotInstanceRequestIds;
    private final List<Filter> filters;

    private DescribeSpotInstanceRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.dryRun = builder.dryRun;
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
        this.filters = builder.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasSpotInstanceRequestIds() {
        return this.spotInstanceRequestIds != null && !(this.spotInstanceRequestIds instanceof SdkAutoConstructList);
    }

    public final List<String> spotInstanceRequestIds() {
        return this.spotInstanceRequestIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpotInstanceRequestIds() ? this.spotInstanceRequestIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotInstanceRequestsRequest)) {
            return false;
        }
        DescribeSpotInstanceRequestsRequest other = (DescribeSpotInstanceRequestsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasSpotInstanceRequestIds() == other.hasSpotInstanceRequestIds() && Objects.equals(this.spotInstanceRequestIds(), other.spotInstanceRequestIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpotInstanceRequestsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("DryRun", (Object)this.dryRun()).add("SpotInstanceRequestIds", this.hasSpotInstanceRequestIds() ? this.spotInstanceRequestIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SpotInstanceRequestIds": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SpotInstanceRequestId", SPOT_INSTANCE_REQUEST_IDS_FIELD);
        map.put("Filter", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotInstanceRequestsRequest, T> g) {
        return obj -> g.apply((DescribeSpotInstanceRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private Boolean dryRun;
        private List<String> spotInstanceRequestIds = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotInstanceRequestsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.dryRun(model.dryRun);
            this.spotInstanceRequestIds(model.spotInstanceRequestIds);
            this.filters(model.filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            if (this.spotInstanceRequestIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.spotInstanceRequestIds;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String ... spotInstanceRequestIds) {
            this.spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSpotInstanceRequestsRequest build() {
            return new DescribeSpotInstanceRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotInstanceRequestsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder spotInstanceRequestIds(Collection<String> var1);

        public Builder spotInstanceRequestIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

