/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CidrAuthorizationContext;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionByoipCidrRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ProvisionByoipCidrRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::cidr)).setter(ProvisionByoipCidrRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<CidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CidrAuthorizationContext").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::cidrAuthorizationContext)).setter(ProvisionByoipCidrRequest.setter(Builder::cidrAuthorizationContext)).constructor(CidrAuthorizationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext").unmarshallLocationName("CidrAuthorizationContext").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ADVERTISABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAdvertisable").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::publiclyAdvertisable)).setter(ProvisionByoipCidrRequest.setter(Builder::publiclyAdvertisable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAdvertisable").unmarshallLocationName("PubliclyAdvertisable").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::description)).setter(ProvisionByoipCidrRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::dryRun)).setter(ProvisionByoipCidrRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<TagSpecification>> POOL_TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PoolTagSpecifications").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::poolTagSpecifications)).setter(ProvisionByoipCidrRequest.setter(Builder::poolTagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolTagSpecification").unmarshallLocationName("PoolTagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiRegion").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::multiRegion)).setter(ProvisionByoipCidrRequest.setter(Builder::multiRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegion").unmarshallLocationName("MultiRegion").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(ProvisionByoipCidrRequest.getter(ProvisionByoipCidrRequest::networkBorderGroup)).setter(ProvisionByoipCidrRequest.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("NetworkBorderGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, CIDR_AUTHORIZATION_CONTEXT_FIELD, PUBLICLY_ADVERTISABLE_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, POOL_TAG_SPECIFICATIONS_FIELD, MULTI_REGION_FIELD, NETWORK_BORDER_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisionByoipCidrRequest.memberNameToFieldInitializer();
    private final String cidr;
    private final CidrAuthorizationContext cidrAuthorizationContext;
    private final Boolean publiclyAdvertisable;
    private final String description;
    private final Boolean dryRun;
    private final List<TagSpecification> poolTagSpecifications;
    private final Boolean multiRegion;
    private final String networkBorderGroup;

    private ProvisionByoipCidrRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
        this.publiclyAdvertisable = builder.publiclyAdvertisable;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.poolTagSpecifications = builder.poolTagSpecifications;
        this.multiRegion = builder.multiRegion;
        this.networkBorderGroup = builder.networkBorderGroup;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final CidrAuthorizationContext cidrAuthorizationContext() {
        return this.cidrAuthorizationContext;
    }

    public final Boolean publiclyAdvertisable() {
        return this.publiclyAdvertisable;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasPoolTagSpecifications() {
        return this.poolTagSpecifications != null && !(this.poolTagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> poolTagSpecifications() {
        return this.poolTagSpecifications;
    }

    public final Boolean multiRegion() {
        return this.multiRegion;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrAuthorizationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAdvertisable());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPoolTagSpecifications() ? this.poolTagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionByoipCidrRequest)) {
            return false;
        }
        ProvisionByoipCidrRequest other = (ProvisionByoipCidrRequest)((Object)obj);
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.cidrAuthorizationContext(), other.cidrAuthorizationContext()) && Objects.equals(this.publiclyAdvertisable(), other.publiclyAdvertisable()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasPoolTagSpecifications() == other.hasPoolTagSpecifications() && Objects.equals(this.poolTagSpecifications(), other.poolTagSpecifications()) && Objects.equals(this.multiRegion(), other.multiRegion()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionByoipCidrRequest").add("Cidr", (Object)this.cidr()).add("CidrAuthorizationContext", (Object)this.cidrAuthorizationContext()).add("PubliclyAdvertisable", (Object)this.publiclyAdvertisable()).add("Description", (Object)this.description()).add("DryRun", (Object)this.dryRun()).add("PoolTagSpecifications", this.hasPoolTagSpecifications() ? this.poolTagSpecifications() : null).add("MultiRegion", (Object)this.multiRegion()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "CidrAuthorizationContext": {
                return Optional.ofNullable(clazz.cast(this.cidrAuthorizationContext()));
            }
            case "PubliclyAdvertisable": {
                return Optional.ofNullable(clazz.cast(this.publiclyAdvertisable()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "PoolTagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.poolTagSpecifications()));
            }
            case "MultiRegion": {
                return Optional.ofNullable(clazz.cast(this.multiRegion()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Cidr", CIDR_FIELD);
        map.put("CidrAuthorizationContext", CIDR_AUTHORIZATION_CONTEXT_FIELD);
        map.put("PubliclyAdvertisable", PUBLICLY_ADVERTISABLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PoolTagSpecification", POOL_TAG_SPECIFICATIONS_FIELD);
        map.put("MultiRegion", MULTI_REGION_FIELD);
        map.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionByoipCidrRequest, T> g) {
        return obj -> g.apply((ProvisionByoipCidrRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String cidr;
        private CidrAuthorizationContext cidrAuthorizationContext;
        private Boolean publiclyAdvertisable;
        private String description;
        private Boolean dryRun;
        private List<TagSpecification> poolTagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiRegion;
        private String networkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionByoipCidrRequest model) {
            super(model);
            this.cidr(model.cidr);
            this.cidrAuthorizationContext(model.cidrAuthorizationContext);
            this.publiclyAdvertisable(model.publiclyAdvertisable);
            this.description(model.description);
            this.dryRun(model.dryRun);
            this.poolTagSpecifications(model.poolTagSpecifications);
            this.multiRegion(model.multiRegion);
            this.networkBorderGroup(model.networkBorderGroup);
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final CidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return this.cidrAuthorizationContext != null ? this.cidrAuthorizationContext.toBuilder() : null;
        }

        public final void setCidrAuthorizationContext(CidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        @Override
        public final Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        public final Boolean getPubliclyAdvertisable() {
            return this.publiclyAdvertisable;
        }

        public final void setPubliclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
        }

        @Override
        public final Builder publiclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getPoolTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.poolTagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPoolTagSpecifications(Collection<TagSpecification.BuilderImpl> poolTagSpecifications) {
            this.poolTagSpecifications = TagSpecificationListCopier.copyFromBuilder(poolTagSpecifications);
        }

        @Override
        public final Builder poolTagSpecifications(Collection<TagSpecification> poolTagSpecifications) {
            this.poolTagSpecifications = TagSpecificationListCopier.copy(poolTagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolTagSpecifications(TagSpecification ... poolTagSpecifications) {
            this.poolTagSpecifications(Arrays.asList(poolTagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolTagSpecifications(Consumer<TagSpecification.Builder> ... poolTagSpecifications) {
            this.poolTagSpecifications(Stream.of(poolTagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegion() {
            return this.multiRegion;
        }

        public final void setMultiRegion(Boolean multiRegion) {
            this.multiRegion = multiRegion;
        }

        @Override
        public final Builder multiRegion(Boolean multiRegion) {
            this.multiRegion = multiRegion;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionByoipCidrRequest build() {
            return new ProvisionByoipCidrRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionByoipCidrRequest> {
        public Builder cidr(String var1);

        public Builder cidrAuthorizationContext(CidrAuthorizationContext var1);

        default public Builder cidrAuthorizationContext(Consumer<CidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return this.cidrAuthorizationContext((CidrAuthorizationContext)((CidrAuthorizationContext.Builder)CidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext)).build());
        }

        public Builder publiclyAdvertisable(Boolean var1);

        public Builder description(String var1);

        public Builder dryRun(Boolean var1);

        public Builder poolTagSpecifications(Collection<TagSpecification> var1);

        public Builder poolTagSpecifications(TagSpecification ... var1);

        public Builder poolTagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder multiRegion(Boolean var1);

        public Builder networkBorderGroup(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

