/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.ServiceLinkVirtualInterfaceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutpostLag
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutpostLag> {
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(OutpostLag.getter(OutpostLag::outpostArn)).setter(OutpostLag.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(OutpostLag.getter(OutpostLag::ownerId)).setter(OutpostLag.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(OutpostLag.getter(OutpostLag::state)).setter(OutpostLag.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostLagId").getter(OutpostLag.getter(OutpostLag::outpostLagId)).setter(OutpostLag.setter(Builder::outpostLagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId").unmarshallLocationName("outpostLagId").build()}).build();
    private static final SdkField<List<String>> LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalGatewayVirtualInterfaceIds").getter(OutpostLag.getter(OutpostLag::localGatewayVirtualInterfaceIds)).setter(OutpostLag.setter(Builder::localGatewayVirtualInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceIdSet").unmarshallLocationName("localGatewayVirtualInterfaceIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICE_LINK_VIRTUAL_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceLinkVirtualInterfaceIds").getter(OutpostLag.getter(OutpostLag::serviceLinkVirtualInterfaceIds)).setter(OutpostLag.setter(Builder::serviceLinkVirtualInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkVirtualInterfaceIdSet").unmarshallLocationName("serviceLinkVirtualInterfaceIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(OutpostLag.getter(OutpostLag::tags)).setter(OutpostLag.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARN_FIELD, OWNER_ID_FIELD, STATE_FIELD, OUTPOST_LAG_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD, SERVICE_LINK_VIRTUAL_INTERFACE_IDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutpostLag.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outpostArn;
    private final String ownerId;
    private final String state;
    private final String outpostLagId;
    private final List<String> localGatewayVirtualInterfaceIds;
    private final List<String> serviceLinkVirtualInterfaceIds;
    private final List<Tag> tags;

    private OutpostLag(BuilderImpl builder) {
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.outpostLagId = builder.outpostLagId;
        this.localGatewayVirtualInterfaceIds = builder.localGatewayVirtualInterfaceIds;
        this.serviceLinkVirtualInterfaceIds = builder.serviceLinkVirtualInterfaceIds;
        this.tags = builder.tags;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String state() {
        return this.state;
    }

    public final String outpostLagId() {
        return this.outpostLagId;
    }

    public final boolean hasLocalGatewayVirtualInterfaceIds() {
        return this.localGatewayVirtualInterfaceIds != null && !(this.localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> localGatewayVirtualInterfaceIds() {
        return this.localGatewayVirtualInterfaceIds;
    }

    public final boolean hasServiceLinkVirtualInterfaceIds() {
        return this.serviceLinkVirtualInterfaceIds != null && !(this.serviceLinkVirtualInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> serviceLinkVirtualInterfaceIds() {
        return this.serviceLinkVirtualInterfaceIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostLagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalGatewayVirtualInterfaceIds() ? this.localGatewayVirtualInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceLinkVirtualInterfaceIds() ? this.serviceLinkVirtualInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutpostLag)) {
            return false;
        }
        OutpostLag other = (OutpostLag)obj;
        return Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.outpostLagId(), other.outpostLagId()) && this.hasLocalGatewayVirtualInterfaceIds() == other.hasLocalGatewayVirtualInterfaceIds() && Objects.equals(this.localGatewayVirtualInterfaceIds(), other.localGatewayVirtualInterfaceIds()) && this.hasServiceLinkVirtualInterfaceIds() == other.hasServiceLinkVirtualInterfaceIds() && Objects.equals(this.serviceLinkVirtualInterfaceIds(), other.serviceLinkVirtualInterfaceIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"OutpostLag").add("OutpostArn", (Object)this.outpostArn()).add("OwnerId", (Object)this.ownerId()).add("State", (Object)this.state()).add("OutpostLagId", (Object)this.outpostLagId()).add("LocalGatewayVirtualInterfaceIds", this.hasLocalGatewayVirtualInterfaceIds() ? this.localGatewayVirtualInterfaceIds() : null).add("ServiceLinkVirtualInterfaceIds", this.hasServiceLinkVirtualInterfaceIds() ? this.serviceLinkVirtualInterfaceIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "OutpostLagId": {
                return Optional.ofNullable(clazz.cast(this.outpostLagId()));
            }
            case "LocalGatewayVirtualInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceIds()));
            }
            case "ServiceLinkVirtualInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkVirtualInterfaceIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceIdSet", LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD);
        map.put("ServiceLinkVirtualInterfaceIdSet", SERVICE_LINK_VIRTUAL_INTERFACE_IDS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutpostLag, T> g) {
        return obj -> g.apply((OutpostLag)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outpostArn;
        private String ownerId;
        private String state;
        private String outpostLagId;
        private List<String> localGatewayVirtualInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> serviceLinkVirtualInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutpostLag model) {
            this.outpostArn(model.outpostArn);
            this.ownerId(model.ownerId);
            this.state(model.state);
            this.outpostLagId(model.outpostLagId);
            this.localGatewayVirtualInterfaceIds(model.localGatewayVirtualInterfaceIds);
            this.serviceLinkVirtualInterfaceIds(model.serviceLinkVirtualInterfaceIds);
            this.tags(model.tags);
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getOutpostLagId() {
            return this.outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final Collection<String> getLocalGatewayVirtualInterfaceIds() {
            if (this.localGatewayVirtualInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.localGatewayVirtualInterfaceIds;
        }

        public final void setLocalGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
        }

        @Override
        public final Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaceIds(String ... localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds(Arrays.asList(localGatewayVirtualInterfaceIds));
            return this;
        }

        public final Collection<String> getServiceLinkVirtualInterfaceIds() {
            if (this.serviceLinkVirtualInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceLinkVirtualInterfaceIds;
        }

        public final void setServiceLinkVirtualInterfaceIds(Collection<String> serviceLinkVirtualInterfaceIds) {
            this.serviceLinkVirtualInterfaceIds = ServiceLinkVirtualInterfaceIdSetCopier.copy(serviceLinkVirtualInterfaceIds);
        }

        @Override
        public final Builder serviceLinkVirtualInterfaceIds(Collection<String> serviceLinkVirtualInterfaceIds) {
            this.serviceLinkVirtualInterfaceIds = ServiceLinkVirtualInterfaceIdSetCopier.copy(serviceLinkVirtualInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceLinkVirtualInterfaceIds(String ... serviceLinkVirtualInterfaceIds) {
            this.serviceLinkVirtualInterfaceIds(Arrays.asList(serviceLinkVirtualInterfaceIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OutpostLag build() {
            return new OutpostLag(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutpostLag> {
        public Builder outpostArn(String var1);

        public Builder ownerId(String var1);

        public Builder state(String var1);

        public Builder outpostLagId(String var1);

        public Builder localGatewayVirtualInterfaceIds(Collection<String> var1);

        public Builder localGatewayVirtualInterfaceIds(String ... var1);

        public Builder serviceLinkVirtualInterfaceIds(Collection<String> var1);

        public Builder serviceLinkVirtualInterfaceIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

