/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FleetIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFleetsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteFleetsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteFleetsRequest.getter(DeleteFleetsRequest::dryRun)).setter(DeleteFleetsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FleetIds").getter(DeleteFleetsRequest.getter(DeleteFleetsRequest::fleetIds)).setter(DeleteFleetsRequest.setter(Builder::fleetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").unmarshallLocationName("FleetId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> TERMINATE_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminateInstances").getter(DeleteFleetsRequest.getter(DeleteFleetsRequest::terminateInstances)).setter(DeleteFleetsRequest.setter(Builder::terminateInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstances").unmarshallLocationName("TerminateInstances").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, FLEET_IDS_FIELD, TERMINATE_INSTANCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteFleetsRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final List<String> fleetIds;
    private final Boolean terminateInstances;

    private DeleteFleetsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.fleetIds = builder.fleetIds;
        this.terminateInstances = builder.terminateInstances;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasFleetIds() {
        return this.fleetIds != null && !(this.fleetIds instanceof SdkAutoConstructList);
    }

    public final List<String> fleetIds() {
        return this.fleetIds;
    }

    public final Boolean terminateInstances() {
        return this.terminateInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetIds() ? this.fleetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstances());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetsRequest)) {
            return false;
        }
        DeleteFleetsRequest other = (DeleteFleetsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasFleetIds() == other.hasFleetIds() && Objects.equals(this.fleetIds(), other.fleetIds()) && Objects.equals(this.terminateInstances(), other.terminateInstances());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFleetsRequest").add("DryRun", (Object)this.dryRun()).add("FleetIds", this.hasFleetIds() ? this.fleetIds() : null).add("TerminateInstances", (Object)this.terminateInstances()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "FleetIds": {
                return Optional.ofNullable(clazz.cast(this.fleetIds()));
            }
            case "TerminateInstances": {
                return Optional.ofNullable(clazz.cast(this.terminateInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("FleetId", FLEET_IDS_FIELD);
        map.put("TerminateInstances", TERMINATE_INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetsRequest, T> g) {
        return obj -> g.apply((DeleteFleetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean terminateInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.fleetIds(model.fleetIds);
            this.terminateInstances(model.terminateInstances);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getFleetIds() {
            if (this.fleetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fleetIds;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String ... fleetIds) {
            this.fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final Boolean getTerminateInstances() {
            return this.terminateInstances;
        }

        public final void setTerminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
        }

        @Override
        public final Builder terminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFleetsRequest build() {
            return new DeleteFleetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFleetsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder fleetIds(Collection<String> var1);

        public Builder fleetIds(String ... var1);

        public Builder terminateInstances(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

