/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNetworkAclRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteNetworkAclRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteNetworkAclRequest.getter(DeleteNetworkAclRequest::dryRun)).setter(DeleteNetworkAclRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkAclId").getter(DeleteNetworkAclRequest.getter(DeleteNetworkAclRequest::networkAclId)).setter(DeleteNetworkAclRequest.setter(Builder::networkAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").unmarshallLocationName("networkAclId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, NETWORK_ACL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteNetworkAclRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String networkAclId;

    private DeleteNetworkAclRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.networkAclId = builder.networkAclId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String networkAclId() {
        return this.networkAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclRequest)) {
            return false;
        }
        DeleteNetworkAclRequest other = (DeleteNetworkAclRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.networkAclId(), other.networkAclId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteNetworkAclRequest").add("DryRun", (Object)this.dryRun()).add("NetworkAclId", (Object)this.networkAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "NetworkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("NetworkAclId", NETWORK_ACL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkAclRequest, T> g) {
        return obj -> g.apply((DeleteNetworkAclRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String networkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.networkAclId(model.networkAclId);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNetworkAclRequest build() {
            return new DeleteNetworkAclRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteNetworkAclRequest> {
        public Builder dryRun(Boolean var1);

        public Builder networkAclId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

