/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.MacModificationTaskState;
import software.amazon.awssdk.services.ec2.model.MacModificationTaskType;
import software.amazon.awssdk.services.ec2.model.MacSystemIntegrityProtectionConfiguration;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MacModificationTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MacModificationTask> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(MacModificationTask.getter(MacModificationTask::instanceId)).setter(MacModificationTask.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> MAC_MODIFICATION_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacModificationTaskId").getter(MacModificationTask.getter(MacModificationTask::macModificationTaskId)).setter(MacModificationTask.setter(Builder::macModificationTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacModificationTaskId").unmarshallLocationName("macModificationTaskId").build()}).build();
    private static final SdkField<MacSystemIntegrityProtectionConfiguration> MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MacSystemIntegrityProtectionConfig").getter(MacModificationTask.getter(MacModificationTask::macSystemIntegrityProtectionConfig)).setter(MacModificationTask.setter(Builder::macSystemIntegrityProtectionConfig)).constructor(MacSystemIntegrityProtectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacSystemIntegrityProtectionConfig").unmarshallLocationName("macSystemIntegrityProtectionConfig").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MacModificationTask.getter(MacModificationTask::startTime)).setter(MacModificationTask.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(MacModificationTask.getter(MacModificationTask::tags)).setter(MacModificationTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskState").getter(MacModificationTask.getter(MacModificationTask::taskStateAsString)).setter(MacModificationTask.setter(Builder::taskState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskState").unmarshallLocationName("taskState").build()}).build();
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskType").getter(MacModificationTask.getter(MacModificationTask::taskTypeAsString)).setter(MacModificationTask.setter(Builder::taskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").unmarshallLocationName("taskType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, MAC_MODIFICATION_TASK_ID_FIELD, MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIG_FIELD, START_TIME_FIELD, TAGS_FIELD, TASK_STATE_FIELD, TASK_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MacModificationTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String macModificationTaskId;
    private final MacSystemIntegrityProtectionConfiguration macSystemIntegrityProtectionConfig;
    private final Instant startTime;
    private final List<Tag> tags;
    private final String taskState;
    private final String taskType;

    private MacModificationTask(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.macModificationTaskId = builder.macModificationTaskId;
        this.macSystemIntegrityProtectionConfig = builder.macSystemIntegrityProtectionConfig;
        this.startTime = builder.startTime;
        this.tags = builder.tags;
        this.taskState = builder.taskState;
        this.taskType = builder.taskType;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String macModificationTaskId() {
        return this.macModificationTaskId;
    }

    public final MacSystemIntegrityProtectionConfiguration macSystemIntegrityProtectionConfig() {
        return this.macSystemIntegrityProtectionConfig;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final MacModificationTaskState taskState() {
        return MacModificationTaskState.fromValue(this.taskState);
    }

    public final String taskStateAsString() {
        return this.taskState;
    }

    public final MacModificationTaskType taskType() {
        return MacModificationTaskType.fromValue(this.taskType);
    }

    public final String taskTypeAsString() {
        return this.taskType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.macModificationTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.macSystemIntegrityProtectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacModificationTask)) {
            return false;
        }
        MacModificationTask other = (MacModificationTask)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.macModificationTaskId(), other.macModificationTaskId()) && Objects.equals(this.macSystemIntegrityProtectionConfig(), other.macSystemIntegrityProtectionConfig()) && Objects.equals(this.startTime(), other.startTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.taskStateAsString(), other.taskStateAsString()) && Objects.equals(this.taskTypeAsString(), other.taskTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MacModificationTask").add("InstanceId", (Object)this.instanceId()).add("MacModificationTaskId", (Object)this.macModificationTaskId()).add("MacSystemIntegrityProtectionConfig", (Object)this.macSystemIntegrityProtectionConfig()).add("StartTime", (Object)this.startTime()).add("Tags", this.hasTags() ? this.tags() : null).add("TaskState", (Object)this.taskStateAsString()).add("TaskType", (Object)this.taskTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "MacModificationTaskId": {
                return Optional.ofNullable(clazz.cast(this.macModificationTaskId()));
            }
            case "MacSystemIntegrityProtectionConfig": {
                return Optional.ofNullable(clazz.cast(this.macSystemIntegrityProtectionConfig()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TaskState": {
                return Optional.ofNullable(clazz.cast(this.taskStateAsString()));
            }
            case "TaskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("MacModificationTaskId", MAC_MODIFICATION_TASK_ID_FIELD);
        map.put("MacSystemIntegrityProtectionConfig", MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIG_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("TaskState", TASK_STATE_FIELD);
        map.put("TaskType", TASK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MacModificationTask, T> g) {
        return obj -> g.apply((MacModificationTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String macModificationTaskId;
        private MacSystemIntegrityProtectionConfiguration macSystemIntegrityProtectionConfig;
        private Instant startTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String taskState;
        private String taskType;

        private BuilderImpl() {
        }

        private BuilderImpl(MacModificationTask model) {
            this.instanceId(model.instanceId);
            this.macModificationTaskId(model.macModificationTaskId);
            this.macSystemIntegrityProtectionConfig(model.macSystemIntegrityProtectionConfig);
            this.startTime(model.startTime);
            this.tags(model.tags);
            this.taskState(model.taskState);
            this.taskType(model.taskType);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getMacModificationTaskId() {
            return this.macModificationTaskId;
        }

        public final void setMacModificationTaskId(String macModificationTaskId) {
            this.macModificationTaskId = macModificationTaskId;
        }

        @Override
        public final Builder macModificationTaskId(String macModificationTaskId) {
            this.macModificationTaskId = macModificationTaskId;
            return this;
        }

        public final MacSystemIntegrityProtectionConfiguration.Builder getMacSystemIntegrityProtectionConfig() {
            return this.macSystemIntegrityProtectionConfig != null ? this.macSystemIntegrityProtectionConfig.toBuilder() : null;
        }

        public final void setMacSystemIntegrityProtectionConfig(MacSystemIntegrityProtectionConfiguration.BuilderImpl macSystemIntegrityProtectionConfig) {
            this.macSystemIntegrityProtectionConfig = macSystemIntegrityProtectionConfig != null ? macSystemIntegrityProtectionConfig.build() : null;
        }

        @Override
        public final Builder macSystemIntegrityProtectionConfig(MacSystemIntegrityProtectionConfiguration macSystemIntegrityProtectionConfig) {
            this.macSystemIntegrityProtectionConfig = macSystemIntegrityProtectionConfig;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTaskState() {
            return this.taskState;
        }

        public final void setTaskState(String taskState) {
            this.taskState = taskState;
        }

        @Override
        public final Builder taskState(String taskState) {
            this.taskState = taskState;
            return this;
        }

        @Override
        public final Builder taskState(MacModificationTaskState taskState) {
            this.taskState(taskState == null ? null : taskState.toString());
            return this;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MacModificationTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public MacModificationTask build() {
            return new MacModificationTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MacModificationTask> {
        public Builder instanceId(String var1);

        public Builder macModificationTaskId(String var1);

        public Builder macSystemIntegrityProtectionConfig(MacSystemIntegrityProtectionConfiguration var1);

        default public Builder macSystemIntegrityProtectionConfig(Consumer<MacSystemIntegrityProtectionConfiguration.Builder> macSystemIntegrityProtectionConfig) {
            return this.macSystemIntegrityProtectionConfig((MacSystemIntegrityProtectionConfiguration)((MacSystemIntegrityProtectionConfiguration.Builder)MacSystemIntegrityProtectionConfiguration.builder().applyMutation(macSystemIntegrityProtectionConfig)).build());
        }

        public Builder startTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder taskState(String var1);

        public Builder taskState(MacModificationTaskState var1);

        public Builder taskType(String var1);

        public Builder taskType(MacModificationTaskType var1);
    }
}

