/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.StatusName;
import software.amazon.awssdk.services.ec2.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsStatusDetails> {
    private static final SdkField<Instant> IMPAIRED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImpairedSince").getter(EbsStatusDetails.getter(EbsStatusDetails::impairedSince)).setter(EbsStatusDetails.setter(Builder::impairedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpairedSince").unmarshallLocationName("impairedSince").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EbsStatusDetails.getter(EbsStatusDetails::nameAsString)).setter(EbsStatusDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EbsStatusDetails.getter(EbsStatusDetails::statusAsString)).setter(EbsStatusDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPAIRED_SINCE_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EbsStatusDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant impairedSince;
    private final String name;
    private final String status;

    private EbsStatusDetails(BuilderImpl builder) {
        this.impairedSince = builder.impairedSince;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final Instant impairedSince() {
        return this.impairedSince;
    }

    public final StatusName name() {
        return StatusName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.impairedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsStatusDetails)) {
            return false;
        }
        EbsStatusDetails other = (EbsStatusDetails)obj;
        return Objects.equals(this.impairedSince(), other.impairedSince()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EbsStatusDetails").add("ImpairedSince", (Object)this.impairedSince()).add("Name", (Object)this.nameAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImpairedSince": {
                return Optional.ofNullable(clazz.cast(this.impairedSince()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImpairedSince", IMPAIRED_SINCE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsStatusDetails, T> g) {
        return obj -> g.apply((EbsStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant impairedSince;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsStatusDetails model) {
            this.impairedSince(model.impairedSince);
            this.name(model.name);
            this.status(model.status);
        }

        public final Instant getImpairedSince() {
            return this.impairedSince;
        }

        public final void setImpairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
        }

        @Override
        public final Builder impairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(StatusName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public EbsStatusDetails build() {
            return new EbsStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsStatusDetails> {
        public Builder impairedSince(Instant var1);

        public Builder name(String var1);

        public Builder name(StatusName var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);
    }
}

