/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer;
import software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassicLoadBalancersConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClassicLoadBalancersConfig> {
    private static final SdkField<List<ClassicLoadBalancer>> CLASSIC_LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClassicLoadBalancers").getter(ClassicLoadBalancersConfig.getter(ClassicLoadBalancersConfig::classicLoadBalancers)).setter(ClassicLoadBalancersConfig.setter(Builder::classicLoadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLoadBalancers").unmarshallLocationName("classicLoadBalancers").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClassicLoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIC_LOAD_BALANCERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClassicLoadBalancersConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ClassicLoadBalancer> classicLoadBalancers;

    private ClassicLoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancers = builder.classicLoadBalancers;
    }

    public final boolean hasClassicLoadBalancers() {
        return this.classicLoadBalancers != null && !(this.classicLoadBalancers instanceof SdkAutoConstructList);
    }

    public final List<ClassicLoadBalancer> classicLoadBalancers() {
        return this.classicLoadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClassicLoadBalancers() ? this.classicLoadBalancers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassicLoadBalancersConfig)) {
            return false;
        }
        ClassicLoadBalancersConfig other = (ClassicLoadBalancersConfig)obj;
        return this.hasClassicLoadBalancers() == other.hasClassicLoadBalancers() && Objects.equals(this.classicLoadBalancers(), other.classicLoadBalancers());
    }

    public final String toString() {
        return ToString.builder((String)"ClassicLoadBalancersConfig").add("ClassicLoadBalancers", this.hasClassicLoadBalancers() ? this.classicLoadBalancers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClassicLoadBalancers": {
                return Optional.ofNullable(clazz.cast(this.classicLoadBalancers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ClassicLoadBalancer>>> map = new HashMap<String, SdkField<List<ClassicLoadBalancer>>>();
        map.put("ClassicLoadBalancers", CLASSIC_LOAD_BALANCERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClassicLoadBalancersConfig, T> g) {
        return obj -> g.apply((ClassicLoadBalancersConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ClassicLoadBalancer> classicLoadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClassicLoadBalancersConfig model) {
            this.classicLoadBalancers(model.classicLoadBalancers);
        }

        public final List<ClassicLoadBalancer.Builder> getClassicLoadBalancers() {
            List<ClassicLoadBalancer.Builder> result = ClassicLoadBalancersCopier.copyToBuilder(this.classicLoadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClassicLoadBalancers(Collection<ClassicLoadBalancer.BuilderImpl> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copyFromBuilder(classicLoadBalancers);
        }

        @Override
        public final Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copy(classicLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(ClassicLoadBalancer ... classicLoadBalancers) {
            this.classicLoadBalancers(Arrays.asList(classicLoadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(Consumer<ClassicLoadBalancer.Builder> ... classicLoadBalancers) {
            this.classicLoadBalancers(Stream.of(classicLoadBalancers).map(c -> (ClassicLoadBalancer)((ClassicLoadBalancer.Builder)ClassicLoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClassicLoadBalancersConfig build() {
            return new ClassicLoadBalancersConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClassicLoadBalancersConfig> {
        public Builder classicLoadBalancers(Collection<ClassicLoadBalancer> var1);

        public Builder classicLoadBalancers(ClassicLoadBalancer ... var1);

        public Builder classicLoadBalancers(Consumer<ClassicLoadBalancer.Builder> ... var1);
    }
}

