/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.MaintenanceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVpnTunnelReplacementStatusResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetVpnTunnelReplacementStatusResponse> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionId").getter(GetVpnTunnelReplacementStatusResponse.getter(GetVpnTunnelReplacementStatusResponse::vpnConnectionId)).setter(GetVpnTunnelReplacementStatusResponse.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("vpnConnectionId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(GetVpnTunnelReplacementStatusResponse.getter(GetVpnTunnelReplacementStatusResponse::transitGatewayId)).setter(GetVpnTunnelReplacementStatusResponse.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerGatewayId").getter(GetVpnTunnelReplacementStatusResponse.getter(GetVpnTunnelReplacementStatusResponse::customerGatewayId)).setter(GetVpnTunnelReplacementStatusResponse.setter(Builder::customerGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").unmarshallLocationName("customerGatewayId").build()}).build();
    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnGatewayId").getter(GetVpnTunnelReplacementStatusResponse.getter(GetVpnTunnelReplacementStatusResponse::vpnGatewayId)).setter(GetVpnTunnelReplacementStatusResponse.setter(Builder::vpnGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").unmarshallLocationName("vpnGatewayId").build()}).build();
    private static final SdkField<String> VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnTunnelOutsideIpAddress").getter(GetVpnTunnelReplacementStatusResponse.getter(GetVpnTunnelReplacementStatusResponse::vpnTunnelOutsideIpAddress)).setter(GetVpnTunnelReplacementStatusResponse.setter(Builder::vpnTunnelOutsideIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOutsideIpAddress").unmarshallLocationName("vpnTunnelOutsideIpAddress").build()}).build();
    private static final SdkField<MaintenanceDetails> MAINTENANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceDetails").getter(GetVpnTunnelReplacementStatusResponse.getter(GetVpnTunnelReplacementStatusResponse::maintenanceDetails)).setter(GetVpnTunnelReplacementStatusResponse.setter(Builder::maintenanceDetails)).constructor(MaintenanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceDetails").unmarshallLocationName("maintenanceDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, CUSTOMER_GATEWAY_ID_FIELD, VPN_GATEWAY_ID_FIELD, VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD, MAINTENANCE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetVpnTunnelReplacementStatusResponse.memberNameToFieldInitializer();
    private final String vpnConnectionId;
    private final String transitGatewayId;
    private final String customerGatewayId;
    private final String vpnGatewayId;
    private final String vpnTunnelOutsideIpAddress;
    private final MaintenanceDetails maintenanceDetails;

    private GetVpnTunnelReplacementStatusResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.transitGatewayId = builder.transitGatewayId;
        this.customerGatewayId = builder.customerGatewayId;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.vpnTunnelOutsideIpAddress = builder.vpnTunnelOutsideIpAddress;
        this.maintenanceDetails = builder.maintenanceDetails;
    }

    public final String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final String customerGatewayId() {
        return this.customerGatewayId;
    }

    public final String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public final String vpnTunnelOutsideIpAddress() {
        return this.vpnTunnelOutsideIpAddress;
    }

    public final MaintenanceDetails maintenanceDetails() {
        return this.maintenanceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnTunnelOutsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVpnTunnelReplacementStatusResponse)) {
            return false;
        }
        GetVpnTunnelReplacementStatusResponse other = (GetVpnTunnelReplacementStatusResponse)((Object)obj);
        return Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.customerGatewayId(), other.customerGatewayId()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId()) && Objects.equals(this.vpnTunnelOutsideIpAddress(), other.vpnTunnelOutsideIpAddress()) && Objects.equals(this.maintenanceDetails(), other.maintenanceDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetVpnTunnelReplacementStatusResponse").add("VpnConnectionId", (Object)this.vpnConnectionId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("CustomerGatewayId", (Object)this.customerGatewayId()).add("VpnGatewayId", (Object)this.vpnGatewayId()).add("VpnTunnelOutsideIpAddress", (Object)this.vpnTunnelOutsideIpAddress()).add("MaintenanceDetails", (Object)this.maintenanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "CustomerGatewayId": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayId()));
            }
            case "VpnGatewayId": {
                return Optional.ofNullable(clazz.cast(this.vpnGatewayId()));
            }
            case "VpnTunnelOutsideIpAddress": {
                return Optional.ofNullable(clazz.cast(this.vpnTunnelOutsideIpAddress()));
            }
            case "MaintenanceDetails": {
                return Optional.ofNullable(clazz.cast(this.maintenanceDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpnConnectionId", VPN_CONNECTION_ID_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("CustomerGatewayId", CUSTOMER_GATEWAY_ID_FIELD);
        map.put("VpnGatewayId", VPN_GATEWAY_ID_FIELD);
        map.put("VpnTunnelOutsideIpAddress", VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD);
        map.put("MaintenanceDetails", MAINTENANCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVpnTunnelReplacementStatusResponse, T> g) {
        return obj -> g.apply((GetVpnTunnelReplacementStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String vpnConnectionId;
        private String transitGatewayId;
        private String customerGatewayId;
        private String vpnGatewayId;
        private String vpnTunnelOutsideIpAddress;
        private MaintenanceDetails maintenanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVpnTunnelReplacementStatusResponse model) {
            super(model);
            this.vpnConnectionId(model.vpnConnectionId);
            this.transitGatewayId(model.transitGatewayId);
            this.customerGatewayId(model.customerGatewayId);
            this.vpnGatewayId(model.vpnGatewayId);
            this.vpnTunnelOutsideIpAddress(model.vpnTunnelOutsideIpAddress);
            this.maintenanceDetails(model.maintenanceDetails);
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final String getVpnTunnelOutsideIpAddress() {
            return this.vpnTunnelOutsideIpAddress;
        }

        public final void setVpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
        }

        @Override
        public final Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
            return this;
        }

        public final MaintenanceDetails.Builder getMaintenanceDetails() {
            return this.maintenanceDetails != null ? this.maintenanceDetails.toBuilder() : null;
        }

        public final void setMaintenanceDetails(MaintenanceDetails.BuilderImpl maintenanceDetails) {
            this.maintenanceDetails = maintenanceDetails != null ? maintenanceDetails.build() : null;
        }

        @Override
        public final Builder maintenanceDetails(MaintenanceDetails maintenanceDetails) {
            this.maintenanceDetails = maintenanceDetails;
            return this;
        }

        @Override
        public GetVpnTunnelReplacementStatusResponse build() {
            return new GetVpnTunnelReplacementStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVpnTunnelReplacementStatusResponse> {
        public Builder vpnConnectionId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder customerGatewayId(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder vpnTunnelOutsideIpAddress(String var1);

        public Builder maintenanceDetails(MaintenanceDetails var1);

        default public Builder maintenanceDetails(Consumer<MaintenanceDetails.Builder> maintenanceDetails) {
            return this.maintenanceDetails((MaintenanceDetails)((MaintenanceDetails.Builder)MaintenanceDetails.builder().applyMutation(maintenanceDetails)).build());
        }
    }
}

